/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTableModel
extends AbstractTableModel
implements SelectionChangedListener,
Layer.LayerChangeListener {
    private OsmDataLayer layer;
    private ArrayList<OsmPrimitive> cache;

    public SelectionTableModel(OsmDataLayer layer) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        this.layer = layer;
        this.cache = new ArrayList();
        DataSet.selListeners.add(this);
        Layer.listeners.add(this);
        this.populateSelectedPrimitives(layer);
    }

    public void unregister() {
        DataSet.selListeners.remove(this);
        Layer.listeners.remove(this);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (Main.map.mapView.getEditLayer() != this.layer) {
            return 0;
        }
        return this.cache.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.cache.get(rowIndex);
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (oldLayer == this.layer) {
            this.cache.clear();
        }
        if (newLayer == this.layer) {
            this.cache.addAll(((OsmDataLayer)newLayer).data.getSelected());
        }
        this.fireTableDataChanged();
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.layer) {
            this.unregister();
        }
        this.cache.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.layer == Main.map.mapView.getEditLayer()) {
            this.cache.clear();
            this.cache.addAll(newSelection);
        } else {
            this.cache.clear();
        }
        this.fireTableDataChanged();
    }

    public List<OsmPrimitive> getSelection() {
        return this.cache;
    }

    protected void populateSelectedPrimitives(OsmDataLayer layer) {
        this.selectionChanged(layer.data.getSelected());
    }
}

