/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.BookmarkList;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BookmarkSelection
implements DownloadSelection {
    private Preferences.Bookmark tempBookmark = null;
    private BookmarkList bookmarks;

    public void addGui(final DownloadDialog gui) {
        JPanel dlg = new JPanel(new GridBagLayout());
        gui.tabpane.addTab(I18n.tr("Bookmarks"), dlg);
        this.bookmarks = new BookmarkList();
        this.bookmarks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Preferences.Bookmark b = (Preferences.Bookmark)BookmarkSelection.this.bookmarks.getSelectedValue();
                if (b != null) {
                    gui.minlat = b.latlon[0];
                    gui.minlon = b.latlon[1];
                    gui.maxlat = b.latlon[2];
                    gui.maxlon = b.latlon[3];
                    gui.boundingBoxChanged(BookmarkSelection.this);
                }
            }
        });
        dlg.add((Component)new JScrollPane(this.bookmarks), GBC.eol().fill());
        JPanel buttons = new JPanel(new GridLayout(1, 2));
        JButton add = new JButton(I18n.tr("Add"));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BookmarkSelection.this.tempBookmark == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please enter the desired coordinates first."), I18n.tr("Information"), 1);
                    return;
                }
                ((BookmarkSelection)BookmarkSelection.this).tempBookmark.name = JOptionPane.showInputDialog(Main.parent, I18n.tr("Please enter a name for the location."), I18n.tr("Name of location"), 3);
                if (((BookmarkSelection)BookmarkSelection.this).tempBookmark.name != null && !((BookmarkSelection)BookmarkSelection.this).tempBookmark.name.equals("")) {
                    ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).addElement(BookmarkSelection.this.tempBookmark);
                    BookmarkSelection.this.bookmarks.save();
                }
            }
        });
        buttons.add(add);
        JButton remove = new JButton(I18n.tr("Remove"));
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object sel = BookmarkSelection.this.bookmarks.getSelectedValue();
                if (sel == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Select a bookmark first."), I18n.tr("Information"), 1);
                    return;
                }
                ((DefaultListModel)BookmarkSelection.this.bookmarks.getModel()).removeElement(sel);
                BookmarkSelection.this.bookmarks.save();
            }
        });
        buttons.add(remove);
        dlg.add((Component)buttons, GBC.eop().fill(2));
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        this.tempBookmark = new Preferences.Bookmark();
        this.tempBookmark.latlon[0] = gui.minlat;
        this.tempBookmark.latlon[1] = gui.minlon;
        this.tempBookmark.latlon[2] = gui.maxlat;
        this.tempBookmark.latlon[3] = gui.maxlon;
        this.bookmarks.clearSelection();
    }
}

