/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelection
implements DownloadSelection {
    private JTextField[] latlon = new JTextField[]{new JTextField(11), new JTextField(11), new JTextField(11), new JTextField(11)};
    final JTextArea osmUrl = new JTextArea();
    final JTextArea showUrl = new JTextArea();

    public void addGui(final DownloadDialog gui) {
        JPanel dlg = new JPanel(new GridBagLayout());
        FocusAdapter dialogUpdater = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            double minlat = Double.parseDouble(BoundingBoxSelection.this.latlon[0].getText());
                            double minlon = Double.parseDouble(BoundingBoxSelection.this.latlon[1].getText());
                            double maxlat = Double.parseDouble(BoundingBoxSelection.this.latlon[2].getText());
                            double maxlon = Double.parseDouble(BoundingBoxSelection.this.latlon[3].getText());
                            if (minlat != gui.minlat || minlon != gui.minlon || maxlat != gui.maxlat || maxlon != gui.maxlon) {
                                gui.minlat = minlat;
                                gui.minlon = minlon;
                                gui.maxlat = maxlat;
                                gui.maxlon = maxlon;
                                gui.boundingBoxChanged(BoundingBoxSelection.this);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        BoundingBoxSelection.this.updateUrl(gui);
                    }
                });
            }
        };
        for (JTextField f : this.latlon) {
            f.setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            f.addFocusListener(dialogUpdater);
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OsmUrlRefresher
        implements DocumentListener {
            OsmUrlRefresher() {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BoundingBoxSelection.this.parseURL(gui);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BoundingBoxSelection.this.parseURL(gui);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BoundingBoxSelection.this.parseURL(gui);
            }
        }
        this.osmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.osmUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BoundingBoxSelection.this.osmUrl.selectAll();
                    }
                });
            }
        });
        this.osmUrl.setLineWrap(true);
        this.osmUrl.setBorder(this.latlon[0].getBorder());
        dlg.add((Component)new JLabel(I18n.tr("min lat")), GBC.std().insets(10, 20, 5, 0));
        dlg.add((Component)this.latlon[0], GBC.std().insets(0, 20, 0, 0));
        dlg.add((Component)new JLabel(I18n.tr("min lon")), GBC.std().insets(10, 20, 5, 0));
        dlg.add((Component)this.latlon[1], GBC.eol().insets(0, 20, 0, 0));
        dlg.add((Component)new JLabel(I18n.tr("max lat")), GBC.std().insets(10, 0, 5, 0));
        dlg.add((Component)this.latlon[2], GBC.std());
        dlg.add((Component)new JLabel(I18n.tr("max lon")), GBC.std().insets(10, 0, 5, 0));
        dlg.add((Component)this.latlon[3], GBC.eol());
        dlg.add((Component)new JLabel(I18n.tr("URL from www.openstreetmap.org (you can paste an URL here to download the area)")), GBC.eol().insets(10, 20, 5, 0));
        dlg.add((Component)this.osmUrl, GBC.eop().insets(10, 0, 5, 0).fill());
        dlg.add((Component)this.showUrl, GBC.eop().insets(10, 0, 5, 5));
        this.showUrl.setEditable(false);
        this.showUrl.setBackground(dlg.getBackground());
        this.showUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BoundingBoxSelection.this.showUrl.selectAll();
            }
        });
        gui.tabpane.addTab(I18n.tr("Bounding Box"), dlg);
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        this.updateBboxFields(gui);
        this.updateUrl(gui);
    }

    private boolean parseURL(DownloadDialog gui) {
        Bounds b = OsmUrlToBounds.parse(this.osmUrl.getText());
        if (b == null) {
            return false;
        }
        gui.minlon = b.min.lon();
        gui.minlat = b.min.lat();
        gui.maxlon = b.max.lon();
        gui.maxlat = b.max.lat();
        gui.boundingBoxChanged(this);
        this.updateBboxFields(gui);
        this.updateUrl(gui);
        return true;
    }

    private void updateBboxFields(DownloadDialog gui) {
        this.latlon[0].setText(Double.toString(gui.minlat));
        this.latlon[1].setText(Double.toString(gui.minlon));
        this.latlon[2].setText(Double.toString(gui.maxlat));
        this.latlon[3].setText(Double.toString(gui.maxlon));
        for (JTextField f : this.latlon) {
            f.setCaretPosition(0);
        }
    }

    private void updateUrl(DownloadDialog gui) {
        this.showUrl.setText(OsmUrlToBounds.getURL(new Bounds(new LatLon(gui.minlat, gui.minlon), new LatLon(gui.maxlat, gui.maxlon))));
    }
}

