/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.OsmMapControl;
import org.openstreetmap.josm.gui.download.SizeButton;
import org.openstreetmap.josm.gui.download.SourceButton;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JMapViewer
implements DownloadSelection {
    private DownloadDialog iGui;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;
    private SizeButton iSizeButton = new SizeButton();
    private SourceButton iSourceButton = new SourceButton();
    private Dimension iDownloadDialogDimension;
    private Dimension iScreenSize;
    private TileSource[] sources = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome(), new OsmTileSource.CycleMap()};
    TileLoader cachedLoader;
    TileLoader uncachedLoader;
    JPanel slipyyMapTabPanel;

    public SlippyMapChooser() {
        try {
            this.cachedLoader = new OsmFileCacheTileLoader(this);
        }
        catch (SecurityException e) {
            this.cachedLoader = null;
        }
        this.uncachedLoader = new OsmTileLoader(this);
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        String mapStyle = Main.pref.get("slippy_map_chooser.mapstyle", "mapnik");
        if (mapStyle.equals("osmarender")) {
            this.iSourceButton.setMapStyle(3);
            this.setTileSource(this.sources[1]);
        } else if (mapStyle.equals("cyclemap")) {
            this.iSourceButton.setMapStyle(4);
            this.setTileSource(this.sources[2]);
        } else if (!mapStyle.equals("mapnik")) {
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        }
    }

    public void setMaxTilesInMemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public void setFileCacheEnabled(boolean enabled) {
        if (enabled) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void addGui(DownloadDialog gui) {
        this.iGui = gui;
        this.slipyyMapTabPanel = new JPanel();
        this.slipyyMapTabPanel.setLayout(new BorderLayout());
        this.slipyyMapTabPanel.add((Component)this, "Center");
        String labelText = I18n.tr("<b>Zoom:</b> Mousewheel, double click or Ctrl + Up/Down <b>Move map:</b> Hold right mousebutton and move mouse or use cursor keys. <b>Select:</b> Hold left mousebutton and draw a frame.");
        this.slipyyMapTabPanel.add((Component)new JLabel("<html>" + labelText + "</html>"), "South");
        this.iGui.tabpane.add((Component)this.slipyyMapTabPanel, I18n.tr("Slippy map"));
        new OsmMapControl(this, this.slipyyMapTabPanel, this.iSizeButton, this.iSourceButton);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int zoomDiff = 22 - this.zoom;
                Point tlc = this.getTopLeftCoordinates();
                int x_min = (this.iSelectionRectStart.x >> zoomDiff) - tlc.x;
                int y_min = (this.iSelectionRectStart.y >> zoomDiff) - tlc.y;
                int x_max = (this.iSelectionRectEnd.x >> zoomDiff) - tlc.x;
                int y_max = (this.iSelectionRectEnd.y >> zoomDiff) - tlc.y;
                int w = x_max - x_min;
                int h = y_max - y_min;
                g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                g.fillRect(x_min, y_min, w, h);
                g.setColor(Color.BLACK);
                g.drawRect(x_min, y_min, w, h);
            }
            this.iSizeButton.paint(g);
            this.iSourceButton.paint(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        if (gui.minlat == 0.0 && gui.minlon == 0.0 && gui.maxlat == 0.0 && gui.maxlon == 0.0) {
            return;
        }
        int y1 = OsmMercator.LatToY(gui.minlat, 22);
        int y2 = OsmMercator.LatToY(gui.maxlat, 22);
        int x1 = OsmMercator.LonToX(gui.minlon, 22);
        int x2 = OsmMercator.LonToX(gui.maxlon, 22);
        this.iSelectionRectStart = new Point(Math.min(x1, x2), Math.min(y1, y2));
        this.iSelectionRectEnd = new Point(Math.max(x1, x2), Math.max(y1, y2));
        MapMarkerDot xmin_ymin = new MapMarkerDot(gui.minlat, gui.minlon);
        MapMarkerDot xmax_ymax = new MapMarkerDot(gui.maxlat, gui.maxlon);
        Vector<MapMarker> marker = new Vector<MapMarker>(2);
        marker.add(xmin_ymin);
        marker.add(xmax_ymax);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null) {
            return;
        }
        Point p_max = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point p_min = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        Point tlc = this.getTopLeftCoordinates();
        int zoomDiff = 22 - this.zoom;
        Point pEnd = new Point(p_max.x + tlc.x, p_max.y + tlc.y);
        Point pStart = new Point(p_min.x + tlc.x, p_min.y + tlc.y);
        pEnd.x <<= zoomDiff;
        pEnd.y <<= zoomDiff;
        pStart.x <<= zoomDiff;
        pStart.y <<= zoomDiff;
        this.iSelectionRectStart = pStart;
        this.iSelectionRectEnd = pEnd;
        Coordinate l1 = this.getPosition(p_max);
        Coordinate l2 = this.getPosition(p_min);
        this.iGui.minlon = Math.min(l2.getLon(), l1.getLon());
        this.iGui.minlat = Math.min(l1.getLat(), l2.getLat());
        this.iGui.maxlon = Math.max(l2.getLon(), l1.getLon());
        this.iGui.maxlat = Math.max(l1.getLat(), l2.getLat());
        this.iGui.boundingBoxChanged(this);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Container co;
        Dimension currentDimension;
        if (this.iScreenSize == null) {
            Container c = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent();
            this.iDownloadDialogDimension = c.getSize();
            this.iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if ((currentDimension = (co = this.iGui.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent().getParent()).getSize()).equals(this.iDownloadDialogDimension)) {
            int w = this.iScreenSize.width * 90 / 100;
            int h = this.iScreenSize.height * 90 / 100;
            co.setBounds((this.iScreenSize.width - w) / 2, (this.iScreenSize.height - h) / 2, w, h);
        } else {
            int w = this.iDownloadDialogDimension.width;
            int h = this.iDownloadDialogDimension.height;
            co.setBounds((this.iScreenSize.width - w) / 2, (this.iScreenSize.height - h) / 2, w, h);
        }
        this.repaint();
    }

    public void toggleMapSource(int mapSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        if (mapSource == 2) {
            this.setTileSource(this.sources[0]);
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        } else if (mapSource == 4) {
            this.setTileSource(this.sources[2]);
            Main.pref.put("slippy_map_chooser.mapstyle", "cyclemap");
        } else {
            this.setTileSource(this.sources[1]);
            Main.pref.put("slippy_map_chooser.mapstyle", "osmarender");
        }
    }
}

