/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.tools.I18n;

public class HelpBrowserCommandProcessor
implements Runnable {
    private static final Logger logger = Logger.getLogger(HelpBrowserCommandProcessor.class.getName());
    private HelpBrowser browser;

    public HelpBrowserCommandProcessor(HelpBrowser browser) {
        this.browser = browser;
    }

    protected void setUrlForHelpTopic(final String helpTopic) {
        Runnable r = new Runnable(){

            public void run() {
                HelpBrowserCommandProcessor.this.browser.openHelpTopic(helpTopic);
                HelpBrowserCommandProcessor.this.browser.setVisible(true);
                HelpBrowserCommandProcessor.this.browser.toFront();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void exit() {
        Runnable r = new Runnable(){

            public void run() {
                HelpBrowserCommandProcessor.this.browser.setVisible(false);
                System.exit(0);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String cmd = null;
            try {
                cmd = reader.readLine();
                logger.info("got command: " + cmd);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString());
                System.out.println(I18n.tr("Failed to read command. Exiting help browser. Exception was:" + e.toString()));
                System.exit(1);
            }
            if (cmd.startsWith("exit")) {
                this.exit();
                continue;
            }
            if (!cmd.startsWith("setUrlForHelpTopic ")) continue;
            String helpTopic = cmd.substring("setUrlForHelpTopic ".length());
            this.setUrlForHelpTopic(helpTopic);
        }
    }
}

