/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import org.openstreetmap.josm.gui.help.HelpBrowser;

public class HelpBrowserHistory
extends Observable {
    private HelpBrowser browser;
    private ArrayList<String> history;
    private int historyPos = 0;

    public HelpBrowserHistory(HelpBrowser brower) {
        this.browser = brower;
        this.history = new ArrayList();
    }

    public void clear() {
        this.history.clear();
        this.historyPos = 0;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canGoBack() {
        return this.historyPos > 0;
    }

    public boolean canGoForward() {
        return this.historyPos + 1 < this.history.size();
    }

    public void back() {
        --this.historyPos;
        if (this.historyPos < 0) {
            return;
        }
        String url = this.history.get(this.historyPos);
        this.browser.openUrl(url);
        this.setChanged();
        this.notifyObservers();
    }

    public void forward() {
        ++this.historyPos;
        if (this.historyPos >= this.history.size()) {
            return;
        }
        String url = this.history.get(this.historyPos);
        this.browser.openUrl(url);
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentUrl(String url) {
        if (this.historyPos != this.history.size() - 1) {
            this.history = this.historyPos == 0 && this.history.size() > 0 ? new ArrayList<String>(Collections.singletonList(this.history.get(0))) : (this.historyPos < this.history.size() - 1 && this.historyPos > 0 ? new ArrayList<String>(this.history.subList(0, this.historyPos)) : new ArrayList());
        }
        this.history.add(url);
        this.historyPos = this.history.size() - 1;
        this.setChanged();
        this.notifyObservers();
    }
}

