/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(TagTableCellRenderer.class.getName());
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);

    public TagTableCellRenderer() {
        this.setOpaque(true);
        this.setForeground(Color.BLACK);
    }

    protected void renderName(String key, HistoryBrowserModel.TagTableModel model, boolean isSelected) {
        String text = key;
        Color bgColor = Color.WHITE;
        if (!model.hasTag(key)) {
            text = I18n.tr("<undefined>");
            bgColor = BGCOLOR_DIFFERENCE;
        } else if (!model.oppositeHasTag(key)) {
            bgColor = BGCOLOR_DIFFERENCE;
        }
        if (isSelected) {
            bgColor = BGCOLOR_SELECTED;
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    protected void renderValue(String key, HistoryBrowserModel.TagTableModel model, boolean isSelected) {
        String text = "";
        Color bgColor = Color.WHITE;
        if (!model.hasTag(key)) {
            text = I18n.tr("<undefined>");
            bgColor = BGCOLOR_DIFFERENCE;
        } else {
            text = model.getValue(key);
            if (!model.hasSameValueAsOpposite(key)) {
                bgColor = BGCOLOR_DIFFERENCE;
            }
        }
        if (isSelected) {
            bgColor = BGCOLOR_SELECTED;
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String key = (String)value;
        HistoryBrowserModel.TagTableModel model = this.getTagTableModel(table);
        switch (column) {
            case 0: {
                this.renderName(key, model, isSelected);
                break;
            }
            case 1: {
                this.renderValue(key, model, isSelected);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable table) {
        return (HistoryBrowserModel.TagTableModel)table.getModel();
    }
}

