/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.DateParser;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageLayer
extends Layer {
    private static final int ICON_SIZE = 16;
    private static ImageLoader imageLoader = new ImageLoader();
    public ArrayList<ImageEntry> data;
    private LinkedList<TimedPoint> gps = new LinkedList();
    private long delta = Long.parseLong(Main.pref.get("tagimages.delta", "0"));
    private long gpstimezone = Long.parseLong(Main.pref.get("tagimages.gpstimezone", "0")) * 60L * 60L * 1000L;
    private boolean mousePressed = false;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private MouseAdapter mouseAdapter;
    private ImageViewerDialog imageViewerDialog;

    public static void create(Collection<File> files, GpxLayer gpxLayer) {
        Loader loader = new Loader(files, gpxLayer);
        Main.worker.execute(loader);
    }

    private GeoImageLayer(final ArrayList<ImageEntry> data, LinkedList<TimedPoint> gps) {
        super(I18n.tr("Geotagged Images"));
        Collections.sort(data);
        Collections.sort(gps);
        this.data = data;
        this.gps = gps;
        final GeoImageLayer self = this;
        this.mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = true;
                if (GeoImageLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() != 1) {
                    return;
                }
                GeoImageLayer.this.mousePressed = false;
                if (!GeoImageLayer.this.isVisible()) {
                    return;
                }
                for (int i = data.size(); i > 0; --i) {
                    ImageEntry e = (ImageEntry)data.get(i - 1);
                    if (e.pos == null) continue;
                    Point p = Main.map.mapView.getPoint(e.pos);
                    Rectangle r = new Rectangle(p.x - 8, p.y - 8, 16, 16);
                    if (!r.contains(ev.getPoint())) continue;
                    GeoImageLayer.this.showImage(i - 1);
                    break;
                }
                Main.map.mapView.repaint();
            }
        };
        Main.map.mapView.addMouseListener(this.mouseAdapter);
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            }

            public void layerAdded(Layer newLayer) {
            }

            public void layerRemoved(Layer oldLayer) {
                if (oldLayer == self) {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        });
    }

    private void showImage(int i) {
        if (this.imageViewerDialog == null) {
            this.imageViewerDialog = new ImageViewerDialog(this.data.get(i));
        }
        this.imageViewerDialog.showImage(i);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "tagimages_small");
    }

    @Override
    public Object getInfoComponent() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(this.getToolTipText()), GBC.eop());
        p.add((Component)new JLabel(I18n.tr("GPS start: {0}", dateFormat.format(this.gps.getFirst().time))), GBC.eol());
        p.add((Component)new JLabel(I18n.tr("GPS end: {0}", dateFormat.format(this.gps.getLast().time))), GBC.eop());
        p.add((Component)new JLabel(I18n.tr("current delta: {0}s", (double)this.delta / 1000.0)), GBC.eol());
        p.add((Component)new JLabel(I18n.tr("timezone difference: ") + (this.gpstimezone > 0L ? "+" : "") + this.gpstimezone / 1000L / 60L / 60L), GBC.eop());
        JList<Object> img = new JList<Object>(this.data.toArray());
        img.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ImageEntry e = (ImageEntry)value;
                this.setIcon(new ImageIcon(e.getIcon()));
                this.setText(e.image.getName() + " (" + dateFormat.format(new Date(e.time.getTime() + (GeoImageLayer.this.delta + GeoImageLayer.this.gpstimezone))) + ")");
                if (e.pos == null) {
                    this.setForeground(Color.red);
                }
                return this;
            }
        });
        img.setVisibleRowCount(5);
        p.add((Component)new JScrollPane(img), GBC.eop().fill(1));
        return p;
    }

    @Override
    public String getToolTipText() {
        int i = 0;
        for (ImageEntry e : this.data) {
            if (e.pos == null) continue;
            ++i;
        }
        return this.data.size() + " " + I18n.trn("image", "images", this.data.size()) + ". " + I18n.tr("{0} within the track.", i);
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        GeoImageLayer l = (GeoImageLayer)from;
        this.data.addAll(l.data);
    }

    @Override
    public void paint(Graphics g, MapView mv) {
        Rectangle r;
        Point p;
        ImageEntry e;
        int i;
        int clickedIndex = -1;
        Point mousePosition = mv.getMousePosition();
        if (mousePosition != null && this.mousePressed) {
            for (i = this.data.size() - 1; i >= 0; --i) {
                e = this.data.get(i);
                if (e.pos == null) continue;
                p = mv.getPoint(e.pos);
                r = new Rectangle(p.x - 8, p.y - 8, 16, 16);
                if (!r.contains(mousePosition)) continue;
                clickedIndex = i;
                break;
            }
        }
        for (i = 0; i < this.data.size(); ++i) {
            e = this.data.get(i);
            if (e.pos == null) continue;
            p = mv.getPoint(e.pos);
            r = new Rectangle(p.x - 8, p.y - 8, 16, 16);
            g.drawImage(e.getIcon(), r.x, r.y, null);
            Border b = null;
            b = i == clickedIndex ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0);
            Insets inset = b.getBorderInsets(mv);
            r.grow((inset.top + inset.bottom) / 2, (inset.left + inset.right) / 2);
            b.paintBorder(mv, g, r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data) {
            v.visit(e.pos);
        }
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem sync = new JMenuItem(I18n.tr("Sync clock"), ImageProvider.get("clock"));
        sync.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                fc.setFileSelectionMode(0);
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".jpg");
                    }

                    public String getDescription() {
                        return I18n.tr("JPEG images (*.jpg)");
                    }
                });
                fc.showOpenDialog(Main.parent);
                File sel = fc.getSelectedFile();
                if (sel == null) {
                    return;
                }
                Main.pref.put("tagimages.lastdirectory", sel.getPath());
                GeoImageLayer.this.sync(sel);
                Main.map.repaint();
            }
        });
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), sync, new JSeparator(), new JMenuItem(new RenameLayerAction(null, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    private void calculatePosition() {
        for (ImageEntry e : this.data) {
            TimedPoint lastTP = null;
            for (TimedPoint tp : this.gps) {
                Date time = new Date(tp.time.getTime() - (this.delta + this.gpstimezone));
                if (time.after(e.time) && lastTP != null) {
                    e.pos = new CachedLatLon(lastTP.pos.getCenter(tp.pos));
                    break;
                }
                lastTP = tp;
            }
            if (e.pos != null) continue;
            e.pos = this.gps.getLast().pos;
        }
    }

    private void sync(File f) {
        Date exifDate;
        try {
            exifDate = ExifReader.readTime(f);
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The date in file \"{0}\" could not be parsed.", f.getName()), I18n.tr("Error"), 0);
            return;
        }
        if (exifDate == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There is no EXIF time within the file \"{0}\".", f.getName()), I18n.tr("Error"), 0);
            return;
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Image")), GBC.eol());
        p.add((Component)new JLabel(new ImageIcon(imageLoader.waitForImage(f, 300))), GBC.eop());
        p.add((Component)new JLabel(I18n.tr("Enter shown date (mm/dd/yyyy HH:MM:SS)")), GBC.eol());
        JTextField gpsText = new JTextField(dateFormat.format(new Date(exifDate.getTime() + this.delta)));
        p.add((Component)gpsText, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("GPS unit timezone (difference to photo)")), GBC.eol());
        String t = Main.pref.get("tagimages.gpstimezone", "0");
        if (t.charAt(0) != '-') {
            t = "+" + t;
        }
        JTextField gpsTimezone = new JTextField(t);
        p.add((Component)gpsTimezone, GBC.eol().fill(2));
        int answer;
        while ((answer = JOptionPane.showConfirmDialog(Main.parent, p, I18n.tr("Synchronize Time with GPS Unit"), 2, 3)) == 0 && !gpsText.getText().equals("")) {
            try {
                this.delta = DateParser.parse(gpsText.getText()).getTime() - exifDate.getTime();
                String time = gpsTimezone.getText();
                if (!time.equals("") && time.charAt(0) == '+') {
                    time = time.substring(1);
                }
                if (time.equals("")) {
                    time = "0";
                }
                this.gpstimezone = Long.valueOf(time) * 60L * 60L * 1000L;
                Main.pref.put("tagimages.delta", "" + this.delta);
                Main.pref.put("tagimages.gpstimezone", time);
                this.calculatePosition();
                return;
            }
            catch (NumberFormatException x) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."), I18n.tr("Error"), 0);
                continue;
            }
            catch (ParseException x) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Time entered could not be parsed."), I18n.tr("Error"), 0);
                continue;
            }
            break;
        }
        return;
    }

    private class ImageViewerDialog {
        private int currentImage;
        private ImageEntry currentImageEntry;
        private final JDialog dlg;
        private final JButton nextButton;
        private final JButton prevButton;
        private final JToggleButton scaleToggle;
        private final JToggleButton centerToggle;
        private final JViewport imageViewport;
        private final JLabel imageLabel;

        public ImageViewerDialog(ImageEntry firstImage) {
            JPanel p = new JPanel(new BorderLayout());
            this.imageLabel = new JLabel(new ImageIcon(imageLoader.waitForImage(firstImage.image, 580)));
            JScrollPane scroll = new JScrollPane(this.imageLabel);
            scroll.setVerticalScrollBarPolicy(21);
            scroll.setHorizontalScrollBarPolicy(31);
            this.imageViewport = scroll.getViewport();
            p.add((Component)scroll, "Center");
            this.scaleToggle = new JToggleButton(ImageProvider.get("dialogs", "zoom-best-fit"));
            this.nextButton = new JButton(ImageProvider.get("dialogs", "next"));
            this.prevButton = new JButton(ImageProvider.get("dialogs", "previous"));
            this.centerToggle = new JToggleButton(ImageProvider.get("dialogs", "centreview"));
            JPanel p2 = new JPanel();
            p2.add(this.prevButton);
            p2.add(this.scaleToggle);
            p2.add(this.centerToggle);
            p2.add(this.nextButton);
            p.add((Component)p2, "South");
            JOptionPane pane = new JOptionPane(p, -1);
            this.dlg = pane.createDialog(Main.parent, "");
            this.scaleToggle.addActionListener(new ImageAction(0));
            this.scaleToggle.setSelected(true);
            this.centerToggle.addActionListener(new ImageAction(0));
            this.nextButton.setActionCommand("Next");
            this.prevButton.setActionCommand("Previous");
            this.nextButton.setMnemonic(39);
            this.prevButton.setMnemonic(37);
            this.scaleToggle.setMnemonic(70);
            this.centerToggle.setMnemonic(67);
            this.nextButton.setToolTipText("Show next image");
            this.prevButton.setToolTipText("Show previous image");
            this.centerToggle.setToolTipText("Centre image location in main display");
            this.scaleToggle.setToolTipText("Scale image to fit");
            this.prevButton.addActionListener(new ImageAction(-1));
            this.nextButton.addActionListener(new ImageAction(1));
            this.centerToggle.setSelected(false);
            this.dlg.addComponentListener(new ComponentListener(){
                boolean ignoreEvent = true;

                public void componentHidden(ComponentEvent e) {
                }

                public void componentMoved(ComponentEvent e) {
                }

                public void componentResized(ComponentEvent ev) {
                    if (ImageViewerDialog.this.scaleToggle.getModel().isSelected() && !this.ignoreEvent) {
                        ImageViewerDialog.this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(((ImageViewerDialog)ImageViewerDialog.this).currentImageEntry.image, Math.max(ImageViewerDialog.this.imageViewport.getWidth(), ImageViewerDialog.this.imageViewport.getHeight()))));
                    }
                    this.ignoreEvent = false;
                }

                public void componentShown(ComponentEvent e) {
                }
            });
            this.dlg.setModal(false);
            this.dlg.setResizable(true);
            this.dlg.pack();
        }

        public void showImage(int index) {
            this.dlg.setVisible(true);
            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
            if (index < 0) {
                index = 0;
            } else if (index >= GeoImageLayer.this.data.size() - 1) {
                index = GeoImageLayer.this.data.size() - 1;
            }
            this.currentImage = index;
            this.currentImageEntry = GeoImageLayer.this.data.get(this.currentImage);
            this.prevButton.setEnabled(this.currentImage > 0);
            this.nextButton.setEnabled(this.currentImage < GeoImageLayer.this.data.size() - 1);
            if (this.scaleToggle.getModel().isSelected()) {
                this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(this.currentImageEntry.image, Math.max(this.imageViewport.getWidth(), this.imageViewport.getHeight()))));
            } else {
                this.imageLabel.setIcon(new ImageIcon(imageLoader.waitForImage(this.currentImageEntry.image)));
            }
            if (this.centerToggle.getModel().isSelected()) {
                Main.map.mapView.zoomTo(this.currentImageEntry.pos);
            }
            this.dlg.setTitle(this.currentImageEntry.image + " (" + this.currentImageEntry.pos.toDisplayString() + ")");
            this.dlg.setCursor(Cursor.getDefaultCursor());
        }

        private class ImageAction
        implements ActionListener {
            private final int offset;

            public ImageAction(int offset) {
                this.offset = offset;
            }

            public void actionPerformed(ActionEvent e) {
                ImageViewerDialog.this.showImage(ImageViewerDialog.this.currentImage + this.offset);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TimedPoint
    implements Comparable<TimedPoint> {
        Date time;
        CachedLatLon pos;

        public TimedPoint(Date time, LatLon pos) {
            this.time = time;
            this.pos = new CachedLatLon(pos);
        }

        @Override
        public int compareTo(TimedPoint point) {
            return this.time.compareTo(point.time);
        }
    }

    public static final class GpsTimeIncorrect
    extends Exception {
        public GpsTimeIncorrect(String message, Throwable cause) {
            super(message, cause);
        }

        public GpsTimeIncorrect(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Loader
    extends PleaseWaitRunnable {
        private GeoImageLayer layer;
        private final Collection<File> files;
        private final GpxLayer gpxLayer;

        public Loader(Collection<File> files, GpxLayer gpxLayer) {
            super(I18n.tr("Images for {0}", gpxLayer.getName()));
            this.files = files;
            this.gpxLayer = gpxLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Read GPX..."));
            this.progressMonitor.setTicksCount(10 + this.files.size());
            LinkedList<TimedPoint> gps = new LinkedList<TimedPoint>();
            ProgressMonitor gpxSubTask = this.progressMonitor.createSubTaskMonitor(10, true);
            int size = 0;
            for (GpxTrack trk : this.gpxLayer.data.tracks) {
                for (Collection<WayPoint> segment : trk.trackSegs) {
                    size += segment.size();
                }
            }
            gpxSubTask.beginTask(null, size);
            try {
                for (GpxTrack trk : this.gpxLayer.data.tracks) {
                    for (Collection<WayPoint> segment : trk.trackSegs) {
                        for (WayPoint p : segment) {
                            LatLon c = p.getCoor();
                            if (!p.attr.containsKey("time")) {
                                throw new IOException(I18n.tr("No time for point {0} x {1}", c.lat(), c.lon()));
                            }
                            Date d = null;
                            try {
                                d = DateParser.parse((String)p.attr.get("time"));
                            }
                            catch (ParseException e) {
                                throw new IOException(I18n.tr("Cannot read time \"{0}\" from point {1} x {2}", p.attr.get("time"), c.lat(), c.lon()));
                            }
                            gps.add(new TimedPoint(d, c));
                            gpxSubTask.worked(1);
                        }
                    }
                }
            }
            finally {
                gpxSubTask.finishTask();
            }
            if (gps.isEmpty()) {
                this.progressMonitor.setErrorMessage(I18n.tr("No images with readable timestamps found."));
                return;
            }
            ArrayList<ImageEntry> data = new ArrayList<ImageEntry>(this.files.size());
            for (File f : this.files) {
                if (this.progressMonitor.isCancelled()) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", f.getName()));
                ImageEntry e = new ImageEntry(f);
                try {
                    e.time = ExifReader.readTime(f);
                    this.progressMonitor.worked(1);
                }
                catch (ParseException e1) {
                    continue;
                }
                if (e.time == null) continue;
                data.add(e);
            }
            this.layer = new GeoImageLayer(data, gps);
            this.layer.calculatePosition();
        }

        @Override
        protected void finish() {
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
            }
        }

        @Override
        protected void cancel() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageEntry
    implements Comparable<ImageEntry>,
    ImageLoader.ImageLoadedListener {
        private static final Image EMPTY_IMAGE = new BufferedImage(1, 1, 12);
        final File image;
        ImageLoader.Entry icon;
        Date time;
        CachedLatLon pos;

        public ImageEntry(File image) {
            this.image = image;
            this.icon = imageLoader.loadImage(image, 16, 16, -1, this);
        }

        @Override
        public int compareTo(ImageEntry image) {
            return this.time.compareTo(image.time);
        }

        public Image getIcon() {
            if (this.icon.scaledImage == null) {
                return EMPTY_IMAGE;
            }
            return this.icon.scaledImage;
        }

        @Override
        public void imageLoaded() {
            MapFrame frame = Main.map;
            if (frame != null) {
                frame.mapView.repaint();
            }
        }
    }

    public static class ImageLoader
    implements ImageObserver {
        private final List<Entry> queue = new ArrayList<Entry>();
        private final WeakHashMap<File, SoftReference<Image>> loadedImageCache = new WeakHashMap();
        private Entry currentEntry;

        private Image getOrLoadImage(File file) {
            Image cachedImage;
            SoftReference<Image> cachedImageRef = this.loadedImageCache.get(file);
            if (cachedImageRef != null && (cachedImage = cachedImageRef.get()) != null) {
                return cachedImage;
            }
            return Toolkit.getDefaultToolkit().createImage(this.currentEntry.file.getAbsolutePath());
        }

        private BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight) {
            BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, 1);
            Graphics2D g = scaledBI.createGraphics();
            while (!g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {}
            }
            g.dispose();
            return scaledBI;
        }

        private void loadImage() {
            if (this.currentEntry != null) {
                return;
            }
            while (!this.queue.isEmpty()) {
                this.currentEntry = this.queue.get(0);
                this.queue.remove(0);
                Image newImage = this.getOrLoadImage(this.currentEntry.file);
                if (newImage.getWidth(this) == -1) break;
                this.finishImage(newImage, this.currentEntry);
                this.currentEntry = null;
            }
        }

        private void finishImage(Image img, Entry entry) {
            this.loadedImageCache.put(entry.file, new SoftReference<Image>(img));
            if (entry.maxSize != -1) {
                int h;
                int w = img.getWidth(null);
                if (w > (h = img.getHeight(null))) {
                    h = Math.round((float)entry.maxSize * ((float)h / (float)w));
                    w = entry.maxSize;
                } else {
                    w = Math.round((float)entry.maxSize * ((float)w / (float)h));
                    h = entry.maxSize;
                }
                entry.scaledImage = this.createResizedCopy(img, w, h);
            } else {
                entry.scaledImage = entry.width != -1 && entry.height != -1 ? this.createResizedCopy(img, entry.width, entry.height) : img;
            }
            if (entry.listener != null) {
                entry.listener.imageLoaded();
            }
        }

        public synchronized Entry loadImage(File file, int width, int height, int maxSize, ImageLoadedListener listener) {
            Entry e = new Entry(file, width, height, maxSize, listener);
            this.queue.add(e);
            this.loadImage();
            return e;
        }

        public Image waitForImage(File file, int width, int height) {
            return this.waitForImage(file, width, height, -1);
        }

        public Image waitForImage(File file, int maxSize) {
            return this.waitForImage(file, -1, -1, maxSize);
        }

        public Image waitForImage(File file) {
            return this.waitForImage(file, -1, -1, -1);
        }

        private synchronized Image waitForImage(File file, int width, int height, int maxSize) {
            Entry entry;
            if (this.currentEntry != null && this.currentEntry.file.equals(file)) {
                entry = this.currentEntry;
            } else {
                entry = new Entry(file, width, height, maxSize, null);
                this.queue.add(0, entry);
            }
            this.loadImage();
            while (entry.scaledImage == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                }
            }
            return entry.scaledImage;
        }

        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x20) != 0) {
                this.finishImage(img, this.currentEntry);
                this.currentEntry = null;
                this.loadImage();
                this.notifyAll();
            } else if ((infoflags & 0x40) != 0) {
                this.currentEntry.scaledImage = new BufferedImage(1, 1, 12);
                this.currentEntry = null;
            }
            return true;
        }

        public static interface ImageLoadedListener {
            public void imageLoaded();
        }

        public static class Entry {
            final File file;
            final int width;
            final int height;
            final int maxSize;
            private final ImageLoadedListener listener;
            volatile Image scaledImage;

            public Entry(File file, int width, int height, int maxSize, ImageLoadedListener listener) {
                this.file = file;
                this.height = height;
                this.width = width;
                this.maxSize = maxSize;
                this.listener = listener;
            }
        }
    }
}

