/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.command.PurgePrimitivesCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.MapPaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private static int dataLayerCounter = 0;
    public final DataSet data;
    private ConflictCollection conflicts;
    public final LinkedList<DataChangeListener> listenerDataChanged = new LinkedList();
    private static TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean newValue) {
        boolean oldValue = this.requiresSaveToFile;
        this.requiresSaveToFile = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, oldValue, newValue);
        }
    }

    protected void setRequiresUploadToServer(boolean newValue) {
        boolean oldValue = this.requiresUploadToServer;
        this.requiresUploadToServer = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, oldValue, newValue);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public static void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(Main.pref.getColor(I18n.marktr("background"), Color.BLACK));
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW));
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bi, r);
    }

    public OsmDataLayer(DataSet data, String name, File associatedFile) {
        super(name);
        this.data = data;
        this.setAssociatedFile(associatedFile);
        this.conflicts = new ConflictCollection();
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics g, MapView mv) {
        boolean virtual;
        boolean active = mv.getActiveLayer() == this;
        boolean inactive = !active && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl = virtual = !inactive && mv.isVirtualNodesEnabled();
        if (active && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            Rectangle b = mv.getBounds();
            b.grow(100, 100);
            Area a = new Area(b);
            for (DataSource src : this.data.dataSources) {
                if (src.bounds == null || src.bounds.min.equals(src.bounds.max)) continue;
                EastNorth en1 = mv.getProjection().latlon2eastNorth(src.bounds.min);
                EastNorth en2 = mv.getProjection().latlon2eastNorth(src.bounds.max);
                Point p1 = mv.getPoint(en1);
                Point p2 = mv.getPoint(en2);
                Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                a.subtract(new Area(r));
            }
            ((Graphics2D)g).setPaint(hatched);
            ((Graphics2D)g).fill(a);
        }
        SimplePaintVisitor painter = Main.pref.getBoolean("draw.wireframe") ? new SimplePaintVisitor() : new MapPaintVisitor();
        painter.setGraphics(g);
        painter.setNavigatableComponent(mv);
        painter.inactive = inactive;
        painter.visitAll(this.data, virtual);
        Main.map.conflictDialog.paintConflicts(g, mv);
    }

    @Override
    public String getToolTipText() {
        File f;
        String tool = "";
        tool = tool + this.undeletedSize(this.data.nodes) + " " + I18n.trn("node", "nodes", this.undeletedSize(this.data.nodes)) + ", ";
        tool = tool + this.undeletedSize(this.data.ways) + " " + I18n.trn("way", "ways", this.undeletedSize(this.data.ways));
        if (this.data.version != null) {
            tool = tool + ", " + I18n.tr("version {0}", this.data.version);
        }
        if ((f = this.getAssociatedFile()) != null) {
            tool = "<html>" + tool + "<br>" + f.getPath() + "</html>";
        }
        return tool;
    }

    @Override
    public void mergeFrom(Layer from) {
        this.mergeFrom(((OsmDataLayer)from).data);
    }

    public void mergeFrom(DataSet from) {
        MergeVisitor visitor = new MergeVisitor(this.data, from);
        visitor.merge();
        Area a = this.data.getDataSourceArea();
        for (DataSource src : from.dataSources) {
            if (a != null && a.contains(src.bounds.asRect())) continue;
            this.data.dataSources.add(src);
        }
        if (this.data.version == null) {
            this.data.version = from.version;
        } else if ("0.5".equals(this.data.version) ^ "0.5".equals(from.version)) {
            System.err.println(I18n.tr("Warning: mixing 0.6 and 0.5 data results in version 0.5"));
            this.data.version = "0.5";
        }
        int numNewConflicts = 0;
        for (Conflict<?> c : visitor.getConflicts()) {
            if (this.conflicts.hasConflict(c)) continue;
            ++numNewConflicts;
            this.conflicts.add(c);
        }
        PurgePrimitivesCommand cmd = this.buildPurgeCommand();
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
        }
        this.fireDataChange();
        Main.map.mapView.repaint();
        this.warnNumNewConflicts(numNewConflicts, cmd == null ? 0 : cmd.getPurgedPrimitives().size());
    }

    protected void warnNumNewConflicts(int numNewConflicts, int numPurgedPrimitives) {
        if (numNewConflicts == 0 && numPurgedPrimitives == 0) {
            return;
        }
        String msg1 = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", numNewConflicts, numNewConflicts);
        String msg2 = I18n.trn("{0} object has been purged from the local dataset because it is deleted on the server.", "{0} objects have been purged from the local dataset because they are deleted on the server.", numPurgedPrimitives, numPurgedPrimitives);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>").append(msg1);
        if (numPurgedPrimitives > 0) {
            sb.append("<br>").append(msg2);
        }
        sb.append("<br>").append(I18n.tr("Please consult the Conflict List Dialog<br>and manually resolve them."));
        sb.append("</html>");
        if (numNewConflicts > 0) {
            Object[] options = new JButton[]{new JButton(I18n.tr("OK")), new JButton(I18n.tr("Help"))};
            options[0].setIcon(ImageProvider.get("ok"));
            options[1].setIcon(ImageProvider.get("help"));
            JOptionPane pane = new JOptionPane(sb.toString(), 2, -1, null, options, options[0]);
            final JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(Main.parent), I18n.tr("Conflicts detected"), true);
            ((AbstractButton)options[0]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            });
            ((AbstractButton)options[1]).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpBrowser b = new HelpBrowser();
                    b.openHelpTopic("Help/Concepts/Conflict");
                    b.setVisible(true);
                }
            });
            dialog.setContentPane(pane);
            dialog.pack();
            HelpUtil.setHelpContext(dialog.getRootPane(), "/Concepts/Conflict");
            WindowGeometry.centerOnScreen(dialog.getSize()).applySafe(dialog);
            dialog.setVisible(true);
        }
    }

    protected PurgePrimitivesCommand buildPurgeCommand() {
        BackreferencedDataSet ds = new BackreferencedDataSet(this.data);
        ds.build();
        ArrayList<OsmPrimitive> toPurge = new ArrayList<OsmPrimitive>();
        block0: for (Conflict<?> c : this.conflicts) {
            if (((OsmPrimitive)c.getMy()).isDeleted() && !((OsmPrimitive)c.getTheir()).isVisible()) {
                toPurge.add((OsmPrimitive)c.getMy());
                continue;
            }
            if (((OsmPrimitive)c.getMy()).isModified() || ((OsmPrimitive)c.getTheir()).isVisible()) continue;
            if (c.getMy() instanceof Way || c.getMy() instanceof Relation) {
                toPurge.add((OsmPrimitive)c.getMy());
                continue;
            }
            for (OsmPrimitive parent : ds.getParents((OsmPrimitive)c.getMy())) {
                if (!parent.isModified() || !(parent instanceof Way)) continue;
                continue block0;
            }
            toPurge.add((OsmPrimitive)c.getMy());
        }
        if (toPurge.isEmpty()) {
            return null;
        }
        PurgePrimitivesCommand cmd = new PurgePrimitivesCommand(this, toPurge);
        cmd.setBackreferenceDataSet(ds);
        return cmd;
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node n : this.data.nodes) {
            if (!n.isUsable()) continue;
            v.visit(n);
        }
    }

    public void cleanupAfterUpload(Collection<OsmPrimitive> processed) {
        if (processed == null || processed.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        HashSet<OsmPrimitive> processedSet = new HashSet<OsmPrimitive>(processed);
        Iterator<OsmPrimitive> it = this.data.nodes.iterator();
        while (it.hasNext()) {
            this.cleanIterator(it, processedSet);
        }
        it = this.data.ways.iterator();
        while (it.hasNext()) {
            this.cleanIterator(it, processedSet);
        }
        it = this.data.relations.iterator();
        while (it.hasNext()) {
            this.cleanIterator(it, processedSet);
        }
    }

    private void cleanIterator(Iterator<? extends OsmPrimitive> it, Collection<OsmPrimitive> processed) {
        OsmPrimitive osm = it.next();
        if (!processed.remove(osm)) {
            return;
        }
        osm.setModified(false);
        if (osm.isDeleted()) {
            it.remove();
        }
    }

    private int undeletedSize(Collection<? extends OsmPrimitive> list) {
        int size = 0;
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive.isDeleted()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor counter = new DataCountVisitor();
        for (OsmPrimitive osm : this.data.allPrimitives()) {
            osm.visit(counter);
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        for (int i = 0; i < counter.normal.length; ++i) {
            String s = counter.normal[i] + " " + I18n.trn(counter.names[i], counter.names[i] + "s", counter.normal[i]);
            if (counter.deleted[i] > 0) {
                s = s + I18n.tr(" ({0} deleted.)", counter.deleted[i]);
            }
            p.add((Component)new JLabel(s, ImageProvider.get("data", counter.names[i]), 0), GBC.eop().insets(15, 0, 0, 0));
        }
        p.add(new JLabel(I18n.tr("API version: {0}", this.data.version != null ? this.data.version : I18n.tr("unset"))));
        return p;
    }

    @Override
    public Component[] getMenuEntries() {
        if (Main.applet) {
            return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(LayerListDialog.getInstance().createActivateLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)), new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)), new JSeparator(), new JMenuItem(LayerListDialog.getInstance().createMergeLayerAction(this)), new JMenuItem(new Layer.LayerSaveAction(this)), new JMenuItem(new Layer.LayerSaveAsAction(this)), new JMenuItem(new Layer.LayerGpxExportAction(this)), new JMenuItem(new ConvertToGpxLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    public void fireDataChange() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
        for (DataChangeListener dcl : this.listenerDataChanged) {
            dcl.dataChanged(this);
        }
    }

    public static GpxData toGpxData(DataSet data, File file) {
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> doneNodes = new HashSet<Node>();
        for (Way w : data.ways) {
            if (!w.isUsable()) continue;
            GpxTrack trk = new GpxTrack();
            gpxData.tracks.add(trk);
            if (w.get("name") != null) {
                trk.attr.put("name", w.get("name"));
            }
            ArrayList<WayPoint> trkseg = null;
            for (Node n : w.getNodes()) {
                if (!n.isUsable()) {
                    trkseg = null;
                    continue;
                }
                if (trkseg == null) {
                    trkseg = new ArrayList<WayPoint>();
                    trk.trackSegs.add(trkseg);
                }
                if (!n.isTagged()) {
                    doneNodes.add(n);
                }
                WayPoint wpt = new WayPoint(n.getCoor());
                if (!n.isTimestampEmpty()) {
                    wpt.attr.put("time", DateUtils.fromDate(n.getTimestamp()));
                    wpt.setTime();
                }
                trkseg.add(wpt);
            }
        }
        for (Node n : data.nodes) {
            String name;
            if (n.incomplete || n.isDeleted() || doneNodes.contains(n)) continue;
            WayPoint wpt = new WayPoint(n.getCoor());
            if (!n.isTimestampEmpty()) {
                wpt.attr.put("time", DateUtils.fromDate(n.getTimestamp()));
                wpt.setTime();
            }
            if ((name = n.get("name")) == null) continue;
            wpt.attr.put("name", name);
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon coor) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean layer_bounds_point = false;
        for (DataSource src : this.data.dataSources) {
            if (!src.bounds.contains(coor)) continue;
            layer_bounds_point = true;
            break;
        }
        return layer_bounds_point;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.data.isModified());
    }

    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.data.isModified());
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer"), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public final int[] normal = new int[3];
        public final int[] deleted = new int[3];
        public final String[] names = new String[]{OsmPrimitiveType.NODE.getAPIName(), OsmPrimitiveType.WAY.getAPIName(), OsmPrimitiveType.RELATION.getAPIName()};

        private void inc(OsmPrimitive osm, int i) {
            int n = i;
            this.normal[n] = this.normal[n] + 1;
            if (osm.isDeleted()) {
                int n2 = i;
                this.deleted[n2] = this.deleted[n2] + 1;
            }
        }

        public void visit(Node n) {
            this.inc(n, 0);
        }

        public void visit(Way w) {
            this.inc(w, 1);
        }

        public void visit(Relation w) {
            this.inc(w, 2);
        }
    }
}

