/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProxyPreferences
implements PreferenceSetting {
    public static final String PROXY_ENABLE = "proxy.enable";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String PROXY_ANONYMOUS = "proxy.anonymous";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_PASS = "proxy.pass";
    private JCheckBox proxyEnable = new JCheckBox(I18n.tr("Enable proxy server"));
    private JTextField proxyHost = new JTextField(20);
    private JTextField proxyPort = new JTextField(5);
    private JCheckBox proxyAnonymous = new JCheckBox(I18n.tr("Anonymous"));
    private JTextField proxyUser = new JTextField(20);
    private JPasswordField proxyPass = new JPasswordField(20);

    public void addGui(PreferenceDialog gui) {
        this.proxyEnable.setSelected(Main.pref.getBoolean(PROXY_ENABLE));
        this.proxyEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyPreferences.this.proxyHost.setEnabled(ProxyPreferences.this.proxyEnable.isSelected());
                ProxyPreferences.this.proxyPort.setEnabled(ProxyPreferences.this.proxyEnable.isSelected());
                ProxyPreferences.this.proxyAnonymous.setEnabled(ProxyPreferences.this.proxyEnable.isSelected());
                ProxyPreferences.this.proxyUser.setEnabled(ProxyPreferences.this.proxyEnable.isSelected() && !ProxyPreferences.this.proxyAnonymous.isSelected());
                ProxyPreferences.this.proxyPass.setEnabled(ProxyPreferences.this.proxyEnable.isSelected() && !ProxyPreferences.this.proxyAnonymous.isSelected());
            }
        });
        this.proxyHost.setEnabled(Main.pref.getBoolean(PROXY_ENABLE));
        this.proxyHost.setText(Main.pref.get(PROXY_HOST));
        this.proxyPort.setEnabled(Main.pref.getBoolean(PROXY_ENABLE));
        this.proxyPort.setText(Main.pref.get(PROXY_PORT));
        this.proxyAnonymous.setEnabled(Main.pref.getBoolean(PROXY_ENABLE));
        this.proxyAnonymous.setSelected(Main.pref.getBoolean(PROXY_ANONYMOUS));
        this.proxyAnonymous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProxyPreferences.this.proxyUser.setEnabled(ProxyPreferences.this.proxyEnable.isSelected() && !ProxyPreferences.this.proxyAnonymous.isSelected());
                ProxyPreferences.this.proxyPass.setEnabled(ProxyPreferences.this.proxyEnable.isSelected() && !ProxyPreferences.this.proxyAnonymous.isSelected());
            }
        });
        this.proxyUser.setEnabled(Main.pref.getBoolean(PROXY_ENABLE) && Main.pref.getBoolean(PROXY_ANONYMOUS));
        this.proxyUser.setText(Main.pref.get(PROXY_USER));
        this.proxyPass.setEnabled(Main.pref.getBoolean(PROXY_ENABLE) && Main.pref.getBoolean(PROXY_ANONYMOUS));
        this.proxyPass.setText(Main.pref.get(PROXY_USER));
        gui.connection.add((Component)new JSeparator(0), GBC.eol().fill(2));
        gui.connection.add((Component)new JLabel(I18n.tr("Proxy Settings")), GBC.eol());
        gui.connection.add((Component)this.proxyEnable, GBC.eol().insets(20, 0, 0, 0));
        gui.connection.add((Component)new JLabel(I18n.tr("Proxy server host")), GBC.std());
        gui.connection.add((Component)this.proxyHost, GBC.eol().fill(2).insets(5, 0, 0, 5));
        gui.connection.add((Component)new JLabel(I18n.tr("Proxy server port")), GBC.std());
        gui.connection.add((Component)this.proxyPort, GBC.eol().fill(2).insets(5, 0, 0, 5));
        gui.connection.add((Component)this.proxyAnonymous, GBC.eop().insets(20, 0, 0, 0));
        gui.connection.add((Component)new JLabel(I18n.tr("Proxy server username")), GBC.std());
        gui.connection.add((Component)this.proxyUser, GBC.eol().fill(2).insets(5, 0, 0, 5));
        gui.connection.add((Component)new JLabel(I18n.tr("Proxy server password")), GBC.std());
        gui.connection.add((Component)this.proxyPass, GBC.eol().fill(2).insets(5, 0, 0, 5));
        gui.connection.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Main.pref.put(PROXY_ENABLE, this.proxyEnable.isSelected());
        Main.pref.put(PROXY_HOST, this.proxyHost.getText());
        Main.pref.put(PROXY_PORT, this.proxyPort.getText());
        Main.pref.put(PROXY_ANONYMOUS, this.proxyAnonymous.isSelected());
        Main.pref.put(PROXY_USER, this.proxyUser.getText());
        Main.pref.put(PROXY_PASS, new String(this.proxyPass.getPassword()));
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProxyPreferences();
        }
    }
}

