/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.ComboBoxEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.util.TableCellEditorSupport;

public class AutoCompletingTextField
extends JTextField
implements ComboBoxEditor,
TableCellEditor {
    private static Logger logger = Logger.getLogger(AutoCompletingTextField.class.getName());
    protected AutoCompletionList autoCompletionList = null;
    private TableCellEditorSupport tableCellEditorSupport;
    private String originalValue;

    protected Document createDefaultModel() {
        return new AutoCompletionDocument();
    }

    protected void init() {
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AutoCompletingTextField.this.selectAll();
                AutoCompletingTextField.this.applyFilter(AutoCompletingTextField.this.getText());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (AutoCompletingTextField.this.getText().equals("")) {
                    AutoCompletingTextField.this.applyFilter("");
                }
            }
        });
        this.tableCellEditorSupport = new TableCellEditorSupport(this);
    }

    public AutoCompletingTextField() {
        this.init();
    }

    public AutoCompletingTextField(int columns) {
        super(columns);
        this.init();
    }

    protected void applyFilter(String filter) {
        if (this.autoCompletionList != null) {
            this.autoCompletionList.applyFilter(filter);
        }
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
    }

    public Component getEditorComponent() {
        return this;
    }

    public Object getItem() {
        return this.getText();
    }

    public void setItem(Object anObject) {
        if (anObject == null) {
            this.setText("");
        } else {
            this.setText(anObject.toString());
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.addCellEditorListener(l);
    }

    protected void rememberOriginalValue(String value) {
        this.originalValue = value;
    }

    protected void restoreOriginalValue() {
        this.setText(this.originalValue);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.tableCellEditorSupport.removeCellEditorListener(l);
    }

    public void cancelCellEditing() {
        this.restoreOriginalValue();
        this.tableCellEditorSupport.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.tableCellEditorSupport.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setText(value == null ? "" : value.toString());
        this.rememberOriginalValue(this.getText());
        return this;
    }

    class AutoCompletionDocument
    extends PlainDocument {
        AutoCompletionDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (AutoCompletingTextField.this.autoCompletionList == null) {
                super.insertString(offs, str, a);
                return;
            }
            if (offs < this.getLength()) {
                super.insertString(offs, str, a);
                return;
            }
            String currentText = this.getText(0, this.getLength());
            try {
                Long.parseLong(str);
                if (currentText.length() == 0) {
                    super.insertString(offs, str, a);
                    return;
                }
                Long.parseLong(currentText);
                super.insertString(offs, str, a);
                return;
            }
            catch (NumberFormatException e) {
                String prefix = currentText.substring(0, offs);
                AutoCompletingTextField.this.autoCompletionList.applyFilter(prefix + str);
                if (AutoCompletingTextField.this.autoCompletionList.getFilteredSize() > 0) {
                    String matchingString = AutoCompletingTextField.this.autoCompletionList.getFilteredItem(0).getValue();
                    this.remove(0, this.getLength());
                    super.insertString(0, matchingString, a);
                    AutoCompletingTextField.this.setCaretPosition(this.getLength());
                    AutoCompletingTextField.this.moveCaretPosition(offs + str.length());
                } else {
                    String newText = prefix + str;
                    this.remove(0, this.getLength());
                    super.insertString(0, newText, a);
                    AutoCompletingTextField.this.setCaretPosition(this.getLength());
                }
                return;
            }
        }
    }
}

