/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.I18n;

public class TagCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(TagCellRenderer.class.getName());
    public static final Color BG_COLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BG_COLOR_HIGHLIGHTED = new Color(255, 255, 204);
    public static final Border BORDER_EMPHASIZED = BorderFactory.createLineBorder(new Color(253, 75, 45));
    private ImageIcon deleteIcon = null;
    private Font fontStandard = this.getFont();
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TagCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tag) {
        this.setText(tag.getName());
    }

    protected void renderTagValue(TagModel tag) {
        if (tag.getValueCount() == 0) {
            this.setText("");
        } else if (tag.getValueCount() == 1) {
            this.setText(tag.getValues().get(0));
        } else if (tag.getValueCount() > 1) {
            this.setText(I18n.tr("<multiple>"));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable table) {
        return (TagEditorModel)table.getModel();
    }

    protected void renderBackgroundColor(TagModel tagModel, TagEditorModel model) {
        this.setBackground(Color.WHITE);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        if (isSelected) {
            this.setBackground(BG_COLOR_SELECTED);
        } else {
            this.renderBackgroundColor(this.getModel(table).get(rowIndex), this.getModel(table));
        }
        switch (vColIndex) {
            case 0: {
                this.renderTagName((TagModel)value);
                break;
            }
            case 1: {
                this.renderTagValue((TagModel)value);
                break;
            }
            default: {
                throw new RuntimeException("unexpected index in switch statement");
            }
        }
        if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1) {
            boolean success = table.editCellAt(rowIndex, vColIndex);
            if (table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        }
        return this;
    }
}

