/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteComboBox
extends JComboBox {
    private boolean autocompleteEnabled = true;

    public AutoCompleteComboBox() {
        final JTextComponent editor = (JTextComponent)this.getEditor().getEditorComponent();
        editor.setDocument(new AutoCompleteComboBoxDocument(this));
        editor.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                editor.selectAll();
            }
        });
    }

    public void setPossibleItems(Collection<String> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (String elem : elems) {
            model.addElement(elem);
        }
        this.getEditor().setItem(oldValue);
    }

    protected boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    protected void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this.autocompleteEnabled = autocompleteEnabled;
    }

    class AutoCompleteComboBoxDocument
    extends PlainDocument {
        private JComboBox comboBox;
        private boolean selecting = false;

        public AutoCompleteComboBoxDocument(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            super.remove(offs, len);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String newText;
            int start;
            if (this.selecting || offs == 0 && str.equals(this.getText(0, this.getLength()))) {
                return;
            }
            boolean initial = offs == 0 && this.getLength() == 0 && str.length() > 1;
            super.insertString(offs, str, a);
            if (this.selecting) {
                return;
            }
            if (!AutoCompleteComboBox.this.autocompleteEnabled) {
                return;
            }
            int size = this.getLength();
            int end = start = offs + str.length();
            String curText = this.getText(0, size);
            Object item = this.lookupItem(curText);
            this.setSelectedItem(item);
            if (initial) {
                start = 0;
            }
            if (item != null && !(newText = item.toString()).equals(curText)) {
                this.selecting = true;
                super.remove(0, size);
                super.insertString(0, newText, a);
                this.selecting = false;
                start = size;
                end = this.getLength();
            }
            JTextComponent editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            editor.setSelectionStart(start);
            editor.setSelectionEnd(end);
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            this.comboBox.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            ComboBoxModel model = this.comboBox.getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                Object currentItem = model.getElementAt(i);
                if (!currentItem.toString().startsWith(pattern)) continue;
                return currentItem;
            }
            return null;
        }
    }
}

