/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;

    public BoundingBoxDownloader(double lat1, double lon1, double lat2, double lon2) {
        this.lat1 = lat1;
        this.lon1 = lon1;
        this.lat2 = lat2;
        this.lon2 = lon2;
        Main.pref.put("osm-download.bounds", lat1 + ";" + lon1 + ";" + lat2 + ";" + lon2);
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws IOException, SAXException, OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server..."));
            String url = "trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=";
            boolean done = false;
            GpxData result = null;
            int i = 0;
            while (!done) {
                progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", i * 5000, (i + 1) * 5000));
                InputStream in = this.getInputStream(url + i, progressMonitor.createSubTaskMonitor(1, true));
                if (in == null) break;
                progressMonitor.setTicks(0);
                GpxData currentGpx = new GpxReader((InputStream)in, null).data;
                if (result == null) {
                    result = currentGpx;
                } else if (currentGpx.hasTrackPoints()) {
                    result.mergeFrom(currentGpx);
                } else {
                    done = true;
                }
                in.close();
                this.activeConnection = null;
                ++i;
            }
            result.fromServer = true;
            GpxData gpxData = result;
            return gpxData;
        }
        catch (IllegalArgumentException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new SAXException("Illegal characters within the HTTP-header response.", e);
        }
        catch (IOException e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server..."), 10);
        InputStream in = null;
        try {
            progressMonitor.indeterminateSubTask(null);
            in = this.getInputStream("map?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2, progressMonitor.createSubTaskMonitor(9, false));
            if (in == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, false));
            return dataSet;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            this.activeConnection = null;
        }
    }
}

