/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxWriter
extends XmlWriter {
    private GpxData data;
    private String indent = "";
    private static final int WAY_POINT = 0;
    private static final int ROUTE_POINT = 1;
    private static final int TRACK_POINT = 2;

    public GpxWriter(PrintWriter out) {
        super(out);
    }

    public GpxWriter(OutputStream out) throws UnsupportedEncodingException {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"))));
    }

    public GpxWriter() {
        super(null);
    }

    public void write(GpxData data) {
        this.data = data;
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.println("<gpx version=\"1.1\" creator=\"JOSM GPX export\" xmlns=\"http://www.topografix.com/GPX/1/1\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n    xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\">");
        this.indent = "  ";
        this.writeMetaData();
        this.writeWayPoints();
        this.writeRoutes();
        this.writeTracks();
        this.out.print("</gpx>");
        this.out.flush();
    }

    private void writeAttr(Map<String, Object> attr) {
        for (Map.Entry<String, Object> ent : attr.entrySet()) {
            String k = ent.getKey();
            if (k.equals("meta.links")) {
                for (Object link : (Collection)ent.getValue()) {
                    this.gpxLink((GpxLink)link);
                }
                continue;
            }
            this.simpleTag(k, ent.getValue().toString());
        }
    }

    private void writeMetaData() {
        Bounds bounds;
        Map attr = this.data.attr;
        this.openln("metadata");
        if (attr.containsKey("meta.desc")) {
            this.simpleTag("desc", (String)attr.get("meta.desc"));
        }
        if (attr.containsKey("meta.author.name") || attr.containsKey("meta.author.email")) {
            String[] tmp;
            this.openln("author");
            this.simpleTag("name", (String)attr.get("meta.author.name"));
            if (attr.containsKey("meta.author.email") && (tmp = ((String)attr.get("meta.author.email")).split("@")).length == 2) {
                this.inline("email", "id=\"" + tmp[0] + "\" domain=\"" + tmp[1] + "\"");
            }
            this.gpxLink((GpxLink)attr.get("meta.author.link"));
            this.closeln("author");
        }
        if (attr.containsKey("meta.copyright.license") || attr.containsKey("meta.copyright.year")) {
            this.openAtt("copyright", "author=\"" + attr.get("meta.copyright.author") + "\"");
            if (attr.containsKey("meta.copyright.year")) {
                this.simpleTag("year", (String)attr.get("meta.copyright.year"));
            }
            if (attr.containsKey("meta.copyright.license")) {
                this.simpleTag("license", GpxWriter.encode((String)attr.get("meta.copyright.license")));
            }
            this.closeln("copyright");
        }
        if (attr.containsKey("meta.links")) {
            for (Object link : (Collection)attr.get("meta.links")) {
                this.gpxLink((GpxLink)link);
            }
        }
        if (attr.containsKey("meta.keywords")) {
            this.simpleTag("keywords", (String)attr.get("meta.keywords"));
        }
        if ((bounds = this.data.recalculateBounds()) != null) {
            String b = "minlat=\"" + bounds.min.lat() + "\" minlon=\"" + bounds.min.lon() + "\" maxlat=\"" + bounds.max.lat() + "\" maxlon=\"" + bounds.max.lon() + "\"";
            this.inline("bounds", b);
        }
        this.closeln("metadata");
    }

    private void writeWayPoints() {
        for (WayPoint pnt : this.data.waypoints) {
            this.wayPoint(pnt, 0);
        }
    }

    private void writeRoutes() {
        for (GpxRoute rte : this.data.routes) {
            this.openln("rte");
            this.writeAttr(rte.attr);
            for (WayPoint pnt : rte.routePoints) {
                this.wayPoint(pnt, 1);
            }
            this.closeln("rte");
        }
    }

    private void writeTracks() {
        for (GpxTrack trk : this.data.tracks) {
            this.open("trk");
            this.writeAttr(trk.attr);
            for (Collection<WayPoint> seg : trk.trackSegs) {
                this.openln("trkseg");
                for (WayPoint pnt : seg) {
                    this.wayPoint(pnt, 2);
                }
                this.closeln("trkseg");
            }
            this.closeln("trk");
        }
    }

    private void openln(String tag) {
        this.open(tag);
        this.out.println();
    }

    private void open(String tag) {
        this.out.print(this.indent + "<" + tag + ">");
        this.indent = this.indent + "  ";
    }

    private void openAtt(String tag, String attributes) {
        this.out.println(this.indent + "<" + tag + " " + attributes + ">");
        this.indent = this.indent + "  ";
    }

    private void inline(String tag, String attributes) {
        this.out.println(this.indent + "<" + tag + " " + attributes + " />");
    }

    private void close(String tag) {
        this.indent = this.indent.substring(2);
        this.out.print(this.indent + "</" + tag + ">");
    }

    private void closeln(String tag) {
        this.close(tag);
        this.out.println();
    }

    private void simpleTag(String tag, String content) {
        if (content != null && content.length() > 0) {
            this.open(tag);
            this.out.print(GpxWriter.encode(content));
            this.out.println("</" + tag + ">");
            this.indent = this.indent.substring(2);
        }
    }

    private void gpxLink(GpxLink link) {
        if (link != null) {
            this.openAtt("link", "href=\"" + link.uri + "\"");
            this.simpleTag("text", link.text);
            this.simpleTag("type", link.type);
            this.closeln("link");
        }
    }

    private void wayPoint(WayPoint pnt, int mode) {
        String type;
        switch (mode) {
            case 0: {
                type = "wpt";
                break;
            }
            case 1: {
                type = "rtept";
                break;
            }
            case 2: {
                type = "trkpt";
                break;
            }
            default: {
                throw new RuntimeException(I18n.tr("Unknown mode {0}.", mode));
            }
        }
        if (pnt != null) {
            LatLon c = pnt.getCoor();
            this.openAtt(type, "lat=\"" + c.lat() + "\" lon=\"" + c.lon() + "\"");
            this.writeAttr(pnt.attr);
            this.closeln(type);
        }
    }
}

