/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.tools.DateUtils;

public class NmeaReader {
    public GpxData data = new GpxData();
    private static final SimpleDateFormat RMCTIMEFMT = new SimpleDateFormat("ddMMyyHHmmss.SSS");
    private static final SimpleDateFormat RMCTIMEFMTSTD = new SimpleDateFormat("ddMMyyHHmmss");
    public NMEAParserState ps;

    private Date readTime(String p) {
        Date d = RMCTIMEFMT.parse(p, new ParsePosition(0));
        if (d == null) {
            d = RMCTIMEFMTSTD.parse(p, new ParsePosition(0));
        }
        if (d == null) {
            throw null;
        }
        return d;
    }

    public int getParserUnknown() {
        return this.ps.unknown;
    }

    public int getParserZeroCoordinates() {
        return this.ps.zero_coord;
    }

    public int getParserChecksumErrors() {
        return this.ps.checksum_errors + this.ps.no_checksum;
    }

    public int getParserMalformed() {
        return this.ps.malformed;
    }

    public int getNumberOfCoordinates() {
        return this.ps.success;
    }

    public NmeaReader(InputStream source, File relativeMarkerPath) {
        GpxTrack currentTrack = new GpxTrack();
        this.data.tracks.add(currentTrack);
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(source));
            StringBuffer sb = new StringBuffer(1024);
            int loopstart_char = rd.read();
            this.ps = new NMEAParserState();
            if (loopstart_char == -1) {
                return;
            }
            sb.append((char)loopstart_char);
            this.ps.p_Date = "010100";
            while (true) {
                int c;
                if (sb.length() >= 1020) {
                    sb.delete(0, sb.length() - 1);
                }
                if ((c = rd.read()) == 36) {
                    this.ParseNMEASentence(sb.toString(), this.ps);
                    sb.delete(0, sb.length());
                    sb.append('$');
                    continue;
                }
                if (c == -1) break;
                sb.append((char)c);
            }
            this.ParseNMEASentence(sb.toString(), this.ps);
            rd.close();
            currentTrack.trackSegs.add(this.ps.waypoints);
            this.data.recalculateBounds();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private boolean ParseNMEASentence(String s, NMEAParserState ps) {
        try {
            if (s.equals("")) {
                throw null;
            }
            String[] chkstrings = s.split("\\*");
            if (chkstrings.length > 1) {
                byte[] chb = chkstrings[0].getBytes();
                int chk = 0;
                for (int i = 1; i < chb.length; ++i) {
                    chk ^= chb[i];
                }
                if (Integer.parseInt(chkstrings[1].substring(0, 2), 16) != chk) {
                    ++ps.checksum_errors;
                    ps.p_Wp = null;
                    return false;
                }
            } else {
                ++ps.no_checksum;
            }
            String[] e = chkstrings[0].split(",");
            WayPoint currentwp = ps.p_Wp;
            String currentDate = ps.p_Date;
            if (e[0].equals("$GPGGA")) {
                LatLon latLon = this.parseLatLon(e[GPGGA.LATITUDE_NAME.position], e[GPGGA.LONGITUDE_NAME.position], e[GPGGA.LATITUDE.position], e[GPGGA.LONGITUDE.position]);
                if (latLon == null) {
                    throw null;
                }
                if (latLon.lat() == 0.0 && latLon.lon() == 0.0) {
                    ++ps.zero_coord;
                    return false;
                }
                String accu = e[GPGGA.TIME.position];
                Date d = this.readTime(currentDate + accu);
                if (ps.p_Time == null || currentwp == null || !ps.p_Time.equals(accu)) {
                    ps.p_Time = accu;
                    currentwp = new WayPoint(latLon);
                }
                if (!currentwp.attr.containsKey("time")) {
                    currentwp.attr.put("time", DateUtils.fromDate(d));
                }
                if ((accu = e[GPGGA.HEIGHT_UNTIS.position]).equals("M") && !(accu = e[GPGGA.HEIGHT.position]).equals("")) {
                    Double.parseDouble(accu);
                    if (!accu.equals("")) {
                        currentwp.attr.put("ele", accu);
                    }
                }
                accu = e[GPGGA.SATELLITE_COUNT.position];
                int sat = 0;
                if (!accu.equals("")) {
                    sat = Integer.parseInt(accu);
                    currentwp.attr.put("sat", accu);
                }
                if (!(accu = e[GPGGA.HDOP.position]).equals("")) {
                    currentwp.attr.put("hdop", Float.valueOf(Float.parseFloat(accu)));
                }
                if (!(accu = e[GPGGA.QUALITY.position]).equals("")) {
                    int fixtype = Integer.parseInt(accu);
                    switch (fixtype) {
                        case 0: {
                            currentwp.attr.put("fix", "none");
                            break;
                        }
                        case 1: {
                            if (sat < 4) {
                                currentwp.attr.put("fix", "2d");
                                break;
                            }
                            currentwp.attr.put("fix", "3d");
                            break;
                        }
                        case 2: {
                            currentwp.attr.put("fix", "dgps");
                            break;
                        }
                    }
                }
            } else if (e[0].equals("$GPVTG")) {
                String accu = e[GPVTG.COURSE_REF.position];
                if (accu.equals("T") && !(accu = e[GPVTG.COURSE.position]).equals("")) {
                    Double.parseDouble(accu);
                    currentwp.attr.put("course", accu);
                }
                if ((accu = e[GPVTG.SPEED_KMH_UNIT.position]).startsWith("K") && !(accu = e[GPVTG.SPEED_KMH.position]).equals("")) {
                    double speed = Double.parseDouble(accu);
                    currentwp.attr.put("speed", Double.toString(speed /= 3.6));
                }
            } else if (e[0].equals("$GPGSA")) {
                String accu = e[GPGSA.VDOP.position];
                if (!accu.equals("")) {
                    currentwp.attr.put("vdop", Float.valueOf(Float.parseFloat(accu)));
                }
                if (!(accu = e[GPGSA.HDOP.position]).equals("")) {
                    currentwp.attr.put("hdop", Float.valueOf(Float.parseFloat(accu)));
                }
                if (!(accu = e[GPGSA.PDOP.position]).equals("")) {
                    currentwp.attr.put("pdop", Float.valueOf(Float.parseFloat(accu)));
                }
            } else if (e[0].equals("$GPRMC")) {
                LatLon latLon = this.parseLatLon(e[GPRMC.WIDTH_NORTH_NAME.position], e[GPRMC.LENGTH_EAST_NAME.position], e[GPRMC.WIDTH_NORTH.position], e[GPRMC.LENGTH_EAST.position]);
                if (latLon == null) {
                    throw null;
                }
                if (latLon.lat() == 0.0 && latLon.lon() == 0.0) {
                    ++ps.zero_coord;
                    return false;
                }
                currentDate = e[GPRMC.DATE.position];
                String time = e[GPRMC.TIME.position];
                Date d = this.readTime(currentDate + time);
                if (ps.p_Time == null || currentwp == null || !ps.p_Time.equals(time)) {
                    ps.p_Time = time;
                    currentwp = new WayPoint(latLon);
                }
                currentwp.attr.put("time", DateUtils.fromDate(d));
                String accu = e[GPRMC.SPEED.position];
                if (!accu.equals("") && !currentwp.attr.containsKey("speed")) {
                    double speed = Double.parseDouble(accu);
                    currentwp.attr.put("speed", Double.toString(speed *= 0.514444444));
                }
                if (!(accu = e[GPRMC.COURSE.position]).equals("") && !currentwp.attr.containsKey("course")) {
                    Double.parseDouble(accu);
                    currentwp.attr.put("course", accu);
                }
            } else {
                ++ps.unknown;
                return false;
            }
            ps.p_Date = currentDate;
            if (ps.p_Wp != currentwp) {
                if (ps.p_Wp != null) {
                    ps.p_Wp.setTime();
                }
                ps.p_Wp = currentwp;
                ps.waypoints.add(currentwp);
                ++ps.success;
                return true;
            }
            return true;
        }
        catch (Exception x) {
            ++ps.malformed;
            ps.p_Wp = null;
            return false;
        }
    }

    private LatLon parseLatLon(String ns, String ew, String dlat, String dlon) throws NumberFormatException {
        int londegsep;
        String widthNorth = dlat.trim();
        String lengthEast = dlon.trim();
        if (widthNorth.equals("") && lengthEast.equals("")) {
            return new LatLon(0.0, 0.0);
        }
        int latdegsep = widthNorth.indexOf(46) - 2;
        if (latdegsep < 0) {
            return null;
        }
        int latdeg = Integer.parseInt(widthNorth.substring(0, latdegsep));
        double latmin = Double.parseDouble(widthNorth.substring(latdegsep));
        if (latdeg < 0) {
            latmin *= -1.0;
        }
        double lat = (double)latdeg + latmin / 60.0;
        if ("S".equals(ns)) {
            lat = -lat;
        }
        if ((londegsep = lengthEast.indexOf(46) - 2) < 0) {
            return null;
        }
        int londeg = Integer.parseInt(lengthEast.substring(0, londegsep));
        double lonmin = Double.parseDouble(lengthEast.substring(londegsep));
        if (londeg < 0) {
            lonmin *= -1.0;
        }
        double lon = (double)londeg + lonmin / 60.0;
        if ("W".equals(ew)) {
            lon = -lon;
        }
        return new LatLon(lat, lon);
    }

    private class NMEAParserState {
        protected Collection<WayPoint> waypoints = new ArrayList<WayPoint>();
        protected String p_Time;
        protected String p_Date;
        protected WayPoint p_Wp;
        protected int success = 0;
        protected int malformed = 0;
        protected int checksum_errors = 0;
        protected int no_checksum = 0;
        protected int unknown = 0;
        protected int zero_coord = 0;

        private NMEAParserState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPGSA {
        AUTOMATIC(1),
        FIX_TYPE(2),
        PRN_1(3),
        PRN_2(4),
        PRN_3(5),
        PRN_4(6),
        PRN_5(7),
        PRN_6(8),
        PRN_7(9),
        PRN_8(10),
        PRN_9(11),
        PRN_10(12),
        PRN_11(13),
        PRN_12(14),
        PDOP(15),
        HDOP(16),
        VDOP(17);

        public final int position;

        private GPGSA(int position) {
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPGGA {
        TIME(1),
        LATITUDE(2),
        LATITUDE_NAME(3),
        LONGITUDE(4),
        LONGITUDE_NAME(5),
        QUALITY(6),
        SATELLITE_COUNT(7),
        HDOP(8),
        HEIGHT(9),
        HEIGHT_UNTIS(10),
        HEIGHT_2(11),
        HEIGHT_2_UNTIS(12),
        GPS_AGE(13),
        REF(14);

        public final int position;

        private GPGGA(int position) {
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPRMC {
        TIME(1),
        RECEIVER_WARNING(2),
        WIDTH_NORTH(3),
        WIDTH_NORTH_NAME(4),
        LENGTH_EAST(5),
        LENGTH_EAST_NAME(6),
        SPEED(7),
        COURSE(8),
        DATE(9),
        MAGNETIC_DECLINATION(10),
        UNKNOWN(11),
        MODE(12);

        public final int position;

        private GPRMC(int position) {
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GPVTG {
        COURSE(1),
        COURSE_REF(2),
        COURSE_M(3),
        COURSE_M_REF(4),
        SPEED_KN(5),
        SPEED_KN_UNIT(6),
        SPEED_KMH(7),
        SPEED_KMH_UNIT(8),
        REST(9);

        public final int position;

        private GPVTG(int position) {
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NMEA_TYPE {
        GPRMC("$GPRMC"),
        GPGGA("$GPGGA"),
        GPGSA("$GPGSA"),
        GPVTG("$GPVTG");

        private final String type;

        private NMEA_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(String type) {
            return this.type.equals(type);
        }
    }
}

