/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmApiException
extends OsmTransferException {
    private int responseCode;
    private String errorHeader;
    private String errorBody;

    public OsmApiException() {
    }

    public OsmApiException(int responseCode, String errorHeader, String errorBody) {
        this.responseCode = responseCode;
        this.errorHeader = errorHeader;
        this.errorBody = errorBody;
    }

    public OsmApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public OsmApiException(String message) {
        super(message);
    }

    public OsmApiException(Throwable cause) {
        super(cause);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getErrorHeader() {
        return this.errorHeader;
    }

    public void setErrorHeader(String errorHeader) {
        this.errorHeader = errorHeader;
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public void setErrorBody(String errorBody) {
        this.errorBody = errorBody;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResponseCode=").append(this.responseCode);
        if (this.errorHeader != null && !this.errorBody.trim().equals("")) {
            sb.append(", Error Header=<").append(I18n.tr(this.errorHeader)).append(">");
        }
        if (this.errorBody != null && !this.errorBody.trim().equals("")) {
            this.errorBody = this.errorBody.trim();
            if (!this.errorBody.equals(this.errorHeader)) {
                sb.append(", Error Body=<").append(I18n.tr(this.errorBody)).append(">");
            }
        }
        return sb.toString();
    }

    public String getDisplayMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.errorHeader != null) {
            sb.append(I18n.tr(this.errorHeader));
            sb.append(I18n.tr("(Code={0})", this.responseCode));
        } else if (this.errorBody != null && !this.errorBody.trim().equals("")) {
            this.errorBody = this.errorBody.trim();
            sb.append(I18n.tr(this.errorBody));
            sb.append(I18n.tr("(Code={0})", this.responseCode));
        } else {
            sb.append(I18n.tr("The server replied an error with code {0}.", this.responseCode));
        }
        return sb.toString();
    }
}

