/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmReader {
    private static final Logger logger = Logger.getLogger(OsmReader.class.getName());
    private DataSet ds = new DataSet();
    private Map<String, OsmPrimitive> externalIdMap = new HashMap<String, OsmPrimitive>();
    private Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    private Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();

    public DataSet getDataSet() {
        return this.ds;
    }

    private OsmReader() {
        this.externalIdMap = new HashMap<String, OsmPrimitive>();
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Long externalWayId : this.ways.keySet()) {
            Way w = (Way)this.externalIdMap.get("w" + externalWayId);
            boolean incomplete = false;
            ArrayList<Node> wayNodes = new ArrayList<Node>();
            for (long id : this.ways.get(externalWayId)) {
                Node n = (Node)this.externalIdMap.get("n" + id);
                if (n == null) {
                    if (id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", externalWayId, id));
                    }
                    n = new Node(id);
                    n.incomplete = true;
                    incomplete = true;
                }
                wayNodes.add(n);
            }
            w.setNodes(wayNodes);
            if (incomplete) {
                logger.warning(I18n.tr("Marked way {0} with {1} nodes incomplete because at least one node was missing in the loaded data and is therefore incomplete too.", externalWayId, w.getNodesCount()));
                w.incomplete = true;
                this.ds.addPrimitive(w);
                continue;
            }
            w.incomplete = false;
            this.ds.addPrimitive(w);
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive primitive : this.externalIdMap.values()) {
            if (!(primitive instanceof Node)) continue;
            this.ds.addPrimitive(primitive);
        }
    }

    private void processRelationsAfterParsing() throws IllegalDataException {
        for (Long externalRelationId : this.relations.keySet()) {
            Relation relation = (Relation)this.externalIdMap.get("r" + externalRelationId);
            ArrayList<RelationMember> relationMembers = new ArrayList<RelationMember>();
            for (RelationMemberData rm : this.relations.get(externalRelationId)) {
                OsmPrimitive primitive = null;
                if (rm.type.equals("node")) {
                    primitive = this.externalIdMap.get("n" + rm.id);
                } else if (rm.type.equals("way")) {
                    primitive = this.externalIdMap.get("w" + rm.id);
                } else if (rm.type.equals("relation")) {
                    primitive = this.externalIdMap.get("r" + rm.id);
                } else {
                    throw new IllegalDataException(I18n.tr("Unknown relation member type ''{0}'' in relation with external id ''{1}''.", rm.type, externalRelationId));
                }
                if (primitive == null) {
                    if (rm.id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", externalRelationId, rm.id));
                    }
                    if (rm.type.equals("node")) {
                        primitive = new Node(rm.id);
                    } else if (rm.type.equals("way")) {
                        primitive = new Way(rm.id);
                    } else if (rm.type.equals("relation")) {
                        primitive = new Relation(rm.id);
                    }
                    this.ds.addPrimitive(primitive);
                }
                relationMembers.add(new RelationMember(rm.role, primitive));
            }
            relation.setMembers(relationMembers);
            this.ds.addPrimitive(relation);
        }
    }

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        OsmReader reader = new OsmReader();
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.subTask(I18n.tr("Parsing OSM data..."));
            InputSource inputSource = new InputSource(new InputStreamReader(source, "UTF-8"));
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            OsmReader osmReader = reader;
            osmReader.getClass();
            sAXParser.parse(inputSource, (DefaultHandler)osmReader.new Parser());
            progressMonitor.worked(1);
            progressMonitor.subTask(I18n.tr("Preparing data set..."));
            reader.processNodesAfterParsing();
            reader.processWaysAfterParsing();
            reader.processRelationsAfterParsing();
            progressMonitor.worked(1);
            DataSet dataSet = reader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new IllegalDataException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new IllegalDataException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private class Parser
    extends DefaultHandler {
        private Locator locator;
        private OsmPrimitiveData current;
        private String generator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String msg) throws OsmDataParsingException {
            throw new OsmDataParsingException(msg).rememberLocation(this.locator);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("osm")) {
                String v;
                if (atts == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' of XML element {1}.", "version", "osm"));
                }
                if ((v = atts.getValue("version")) == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
                }
                if (!v.equals("0.5") && !v.equals("0.6")) {
                    this.throwException(I18n.tr("Unsupported version: {0}", v));
                }
                this.generator = atts.getValue("generator");
                ((OsmReader)OsmReader.this).ds.version = v;
            } else if (qName.equals("bounds")) {
                String minlon = atts.getValue("minlon");
                String minlat = atts.getValue("minlat");
                String maxlon = atts.getValue("maxlon");
                String maxlat = atts.getValue("maxlat");
                String origin = atts.getValue("origin");
                if (minlon != null && maxlon != null && minlat != null && maxlat != null) {
                    if (origin == null) {
                        origin = this.generator;
                    }
                    Bounds bounds = new Bounds(new LatLon(Double.parseDouble(minlat), Double.parseDouble(minlon)), new LatLon(Double.parseDouble(maxlat), Double.parseDouble(maxlon)));
                    DataSource src = new DataSource(bounds, origin);
                    ((OsmReader)OsmReader.this).ds.dataSources.add(src);
                } else {
                    this.throwException(I18n.tr("Missing manadatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", minlon, minlat, maxlon, maxlat, origin));
                }
            } else if (qName.equals("node")) {
                this.current = new OsmPrimitiveData();
                this.current.latlon = new LatLon(this.getDouble(atts, "lat"), this.getDouble(atts, "lon"));
                this.readCommon(atts, this.current);
                Node n = this.current.createNode();
                OsmReader.this.externalIdMap.put("n" + this.current.id, n);
            } else if (qName.equals("way")) {
                this.current = new OsmPrimitiveData();
                this.readCommon(atts, this.current);
                Way w = this.current.createWay();
                OsmReader.this.externalIdMap.put("w" + this.current.id, w);
                OsmReader.this.ways.put(this.current.id, new ArrayList());
            } else if (qName.equals("nd")) {
                long id;
                Collection list = (Collection)OsmReader.this.ways.get(this.current.id);
                if (list == null) {
                    this.throwException(I18n.tr("Found XML element <nd> not as direct child of element <way>."));
                }
                if (atts.getValue("ref") == null) {
                    this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", this.current.id));
                }
                if ((id = this.getLong(atts, "ref")) == 0L) {
                    this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", id));
                }
                list.add(id);
            } else if (qName.equals("relation")) {
                this.current = new OsmPrimitiveData();
                this.readCommon(atts, this.current);
                Relation r = this.current.createRelation();
                OsmReader.this.externalIdMap.put("r" + this.current.id, r);
                OsmReader.this.relations.put(this.current.id, new LinkedList());
            } else if (qName.equals("member")) {
                Collection list = (Collection)OsmReader.this.relations.get(this.current.id);
                if (list == null) {
                    this.throwException(I18n.tr("Found XML element <member> not as direct child of element <relation>."));
                }
                RelationMemberData emd = new RelationMemberData();
                String value = atts.getValue("ref");
                if (value == null) {
                    this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", this.current.id));
                }
                try {
                    emd.id = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(this.current.id), value));
                }
                value = atts.getValue("type");
                if (value == null) {
                    this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(emd.id), Long.toString(this.current.id)));
                }
                if (!(value.equals("way") || value.equals("node") || value.equals("relation"))) {
                    this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(emd.id), Long.toString(this.current.id), value));
                }
                emd.type = value;
                emd.role = value = atts.getValue("role");
                if (emd.id == 0L) {
                    this.throwException(I18n.tr("Incomplete <member> specification with ref=0"));
                }
                list.add(emd);
            } else if (qName.equals("tag")) {
                String key = atts.getValue("k");
                String value = atts.getValue("v");
                this.current.rememberTag(key, value);
            } else {
                System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", qName));
            }
        }

        private double getDouble(Attributes atts, String value) {
            return Double.parseDouble(atts.getValue(value));
        }

        private User createUser(String uid, String name) throws SAXException {
            if (uid == null) {
                if (name == null) {
                    return null;
                }
                return User.createLocalUser(name);
            }
            try {
                long id = Long.parseLong(uid);
                return User.createOsmUser(id, name);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal value for attribute ''uid''. Got ''{0}''.", uid));
                return null;
            }
        }

        void readCommon(Attributes atts, OsmPrimitiveData current) throws SAXException {
            String time;
            current.id = this.getLong(atts, "id");
            if (current.id == 0L) {
                this.throwException(I18n.tr("Illegal object with ID=0."));
            }
            if ((time = atts.getValue("timestamp")) != null && time.length() != 0) {
                current.timestamp = DateUtils.fromString(time);
            }
            String user = atts.getValue("user");
            String uid = atts.getValue("uid");
            current.user = this.createUser(uid, user);
            String visible = atts.getValue("visible");
            if (visible != null) {
                current.visible = Boolean.parseBoolean(visible);
            }
            String version = atts.getValue("version");
            current.version = 0;
            if (version != null) {
                try {
                    current.version = Integer.parseInt(version);
                }
                catch (NumberFormatException e) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.id), version));
                }
                if (((OsmReader)OsmReader.this).ds.version.equals("0.6")) {
                    if (current.version <= 0 && current.id > 0L) {
                        this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.id), version));
                    } else if (current.version < 0 && current.id <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.id, current.version, 0, "0.6"));
                        current.version = 0;
                    }
                } else if (((OsmReader)OsmReader.this).ds.version.equals("0.5")) {
                    if (current.version <= 0 && current.id > 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.id, current.version, 1, "0.5"));
                        current.version = 1;
                    } else if (current.version < 0 && current.id <= 0L) {
                        System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.id, current.version, 0, "0.5"));
                        current.version = 0;
                    }
                } else {
                    this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", ((OsmReader)OsmReader.this).ds.version));
                }
            } else if (current.id > 0L && ((OsmReader)OsmReader.this).ds.version != null && ((OsmReader)OsmReader.this).ds.version.equals("0.6")) {
                this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(current.id)));
            }
            String action = atts.getValue("action");
            if (action == null) {
                return;
            }
            if (action.equals("delete")) {
                current.deleted = true;
            } else if (action.startsWith("modify")) {
                current.modified = true;
            }
        }

        private long getLong(Attributes atts, String name) throws SAXException {
            String value = atts.getValue(name);
            if (value == null) {
                this.throwException(I18n.tr("Missing required attribute ''{0}''.", name));
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", name, value));
                return 0L;
            }
        }
    }

    private static class RelationMemberData {
        public String type;
        public long id;
        public String role;

        private RelationMemberData() {
        }
    }

    private static class OsmPrimitiveData {
        public long id = 0L;
        public boolean modified = false;
        public boolean deleted = false;
        public Date timestamp = new Date();
        public User user = null;
        public boolean visible = true;
        public int version = 0;
        public LatLon latlon = new LatLon(0.0, 0.0);
        private OsmPrimitive primitive;

        private OsmPrimitiveData() {
        }

        public void copyTo(OsmPrimitive osm) {
            if (this.id <= 0L) {
                osm.clearOsmId();
            } else {
                osm.setOsmId(this.id, this.version);
            }
            osm.setDeleted(this.deleted);
            osm.setModified(this.modified | this.deleted);
            osm.setTimestamp(this.timestamp);
            osm.setUser(this.user);
            osm.setVisible(this.visible);
            osm.mappaintStyle = null;
        }

        public Node createNode() {
            Node node = new Node();
            node.setCoor(this.latlon);
            this.copyTo(node);
            this.primitive = node;
            return node;
        }

        public Way createWay() {
            Way way = new Way();
            this.copyTo(way);
            this.primitive = way;
            return way;
        }

        public Relation createRelation() {
            Relation relation = new Relation();
            this.copyTo(relation);
            this.primitive = relation;
            return relation;
        }

        public void rememberTag(String key, String value) {
            this.primitive.put(key, value);
        }
    }
}

