/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.PluginDownloader;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PluginSelection {
    private Map<String, Boolean> pluginMap;
    private Map<String, PluginInformation> availablePlugins;
    private Map<String, PluginInformation> localPlugins;
    private JTextField txtFilter = null;

    public void passTxtFilter(JTextField filter) {
        this.txtFilter = filter;
    }

    public void updateDescription(JPanel pluginPanel) {
        int count = PluginDownloader.downloadDescription();
        if (count > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.trn("Downloaded plugin information from {0} site", "Downloaded plugin information from {0} sites", count, count), I18n.tr("Information"), 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No plugin information found."), I18n.tr("Error"), 0);
        }
        this.loadPlugins();
        this.drawPanel(pluginPanel);
    }

    public void update(JPanel pluginPanel) {
        int num = PluginDownloader.downloadDescription();
        Boolean done = false;
        this.loadPlugins();
        this.drawPanel(pluginPanel);
        HashSet<PluginInformation> toUpdate = new HashSet<PluginInformation>();
        StringBuilder toUpdateStr = new StringBuilder();
        for (String pluginName : Main.pref.getCollection("plugins", Collections.<String>emptySet())) {
            PluginInformation local = this.localPlugins.get(pluginName);
            PluginInformation description = this.availablePlugins.get(pluginName);
            if (description == null) {
                System.out.println(I18n.tr("Plug-in named {0} is not available. Update skipped.", pluginName));
                continue;
            }
            if (local != null && (description.version == null || description.version.equals(local.version))) continue;
            toUpdate.add(description);
            toUpdateStr.append(pluginName + "\n");
        }
        if (toUpdate.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("All installed plugins are up to date."), I18n.tr("Information"), 1);
            done = true;
        } else {
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Update"), new String[]{I18n.tr("Update Plugins"), I18n.tr("Cancel")});
            ed.setButtonIcons(new String[]{"dialogs/refresh.png", "cancel.png"});
            ed.setContent(I18n.tr("Update the following plugins:\n\n{0}", toUpdateStr.toString()));
            ed.showDialog();
            if (ed.getValue() == 1) {
                PluginDownloader.update(toUpdate);
                done = true;
            }
        }
        if (done.booleanValue() && num >= 1) {
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        this.loadPlugins();
        this.drawPanel(pluginPanel);
    }

    public boolean finish() {
        LinkedList<PluginInformation> toDownload = new LinkedList<PluginInformation>();
        Collection<String> installedPlugins = Main.pref.getCollection("plugins", Collections.<String>emptySet());
        String msg = "";
        for (Map.Entry<String, Boolean> entry : this.pluginMap.entrySet()) {
            if (!entry.getValue().booleanValue() || installedPlugins.contains(entry.getKey())) continue;
            String name = entry.getKey();
            PluginInformation ap = this.availablePlugins.get(name);
            PluginInformation pi = this.localPlugins.get(name);
            if (pi != null && (pi.version != null || ap.version == null) && (pi.version == null || pi.version.equals(ap.version))) continue;
            toDownload.add(ap);
            msg = msg + name + "\n";
        }
        if (!toDownload.isEmpty()) {
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Download missing plugins"), new String[]{I18n.tr("Download Plugins"), I18n.tr("Cancel")});
            ed.setButtonIcons(new String[]{"download.png", "cancel.png"});
            ed.setContent(I18n.tr("Download the following plugins?\n\n{0}", msg));
            ed.showDialog();
            LinkedList<PluginInformation> error = ed.getValue() != 1 ? toDownload : new PluginDownloader().download(toDownload);
            for (PluginInformation pd : error) {
                this.pluginMap.put(pd.name, false);
            }
        }
        LinkedList<String> plugins = new LinkedList<String>();
        for (Map.Entry<String, Boolean> d : this.pluginMap.entrySet()) {
            if (!d.getValue().booleanValue()) continue;
            plugins.add(d.getKey());
        }
        Collections.sort(plugins);
        return Main.pref.putCollection("plugins", plugins);
    }

    public void drawPanel(JPanel pluginPanel) {
        Collection<String> enabledPlugins = Main.pref.getCollection("plugins", null);
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<String, Boolean>();
        } else {
            HashSet<String> pluginsToRemove = new HashSet<String>();
            for (String pname : this.pluginMap.keySet()) {
                if (this.availablePlugins.get(pname) != null) continue;
                pluginsToRemove.add(pname);
            }
            for (String pname : pluginsToRemove) {
                this.pluginMap.remove(pname);
            }
        }
        pluginPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        int row = 0;
        for (final PluginInformation plugin : this.availablePlugins.values()) {
            boolean matches;
            String remoteversion;
            boolean enabled;
            boolean bl = enabled = enabledPlugins != null && enabledPlugins.contains(plugin.name);
            if (this.pluginMap.get(plugin.name) == null) {
                this.pluginMap.put(plugin.name, enabled);
            }
            if ((remoteversion = plugin.version) == null || remoteversion.equals("")) {
                remoteversion = I18n.tr("unknown");
            } else if (plugin.oldmode) {
                remoteversion = remoteversion + "*";
            }
            String localversion = "";
            PluginInformation p = this.localPlugins.get(plugin.name);
            if (p != null) {
                localversion = p.version != null && !p.version.equals("") ? p.version : I18n.tr("unknown");
                localversion = " (" + localversion + ")";
            }
            if (this.txtFilter.getText() != null && !(matches = PluginSelection.filterNameAndDescription(this.txtFilter.getText(), plugin.name, plugin.getLinkDescription(), remoteversion, localversion))) continue;
            final JCheckBox pluginCheck = new JCheckBox(I18n.tr("{0}: Version {1}{2}", plugin.name, remoteversion, localversion), (boolean)this.pluginMap.get(plugin.name));
            gbc.gridy = row++;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.weighty = 0.1;
            gbc.fill = 0;
            pluginPanel.add((Component)pluginCheck, gbc);
            pluginCheck.setToolTipText(plugin.downloadlink != null ? "" + plugin.downloadlink : I18n.tr("Plugin bundled with JOSM"));
            JEditorPane description = new JEditorPane();
            description.setContentType("text/html");
            description.setEditable(false);
            description.setText("<html><body bgcolor=\"#" + Integer.toHexString(UIManager.getColor("Panel.background").getRGB() & 0xFFFFFF) + "\"><i>" + plugin.getLinkDescription() + "</i></body></html>");
            description.setBorder(BorderFactory.createEmptyBorder());
            description.setBackground(UIManager.getColor("Panel.background"));
            description.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(e.getURL().toString());
                    }
                }
            });
            gbc.gridy = row++;
            gbc.insets = new Insets(3, 25, 5, 5);
            gbc.weighty = 0.9;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            pluginPanel.add((Component)description, gbc);
            pluginCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PluginSelection.this.pluginMap.put(plugin.name, pluginCheck.isSelected());
                }
            });
        }
        pluginPanel.updateUI();
    }

    private static boolean filterNameAndDescription(String filter, String name, String description, String remoteversion, String localversion) {
        String[] input = filter.split("\\s+");
        String name_lc = name.toLowerCase();
        String description_lc = description.toLowerCase();
        String remoteversion_lc = remoteversion.toLowerCase();
        String localversion_lc = localversion.toLowerCase();
        boolean canHas = true;
        for (String bit : input) {
            String lc_bit = bit.toLowerCase();
            if (name_lc.contains(lc_bit) || description_lc.contains(lc_bit) || remoteversion_lc.contains(lc_bit) || localversion_lc.contains(lc_bit)) continue;
            canHas = false;
        }
        return canHas;
    }

    public void loadPlugins() {
        this.availablePlugins = new TreeMap<String, PluginInformation>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        this.localPlugins = new TreeMap<String, PluginInformation>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (String location : PluginInformation.getPluginLocations()) {
            Object[] pluginFiles = new File(location).listFiles();
            if (pluginFiles == null) continue;
            Arrays.sort(pluginFiles);
            for (Object f : pluginFiles) {
                if (!((File)f).isFile()) continue;
                String fname = ((File)f).getName();
                if (fname.endsWith(".jar")) {
                    try {
                        PluginInformation info = new PluginInformation((File)f, fname.substring(0, fname.length() - 4));
                        if (!this.availablePlugins.containsKey(info.name)) {
                            this.availablePlugins.put(info.name, info);
                        }
                        if (this.localPlugins.containsKey(info.name)) continue;
                        this.localPlugins.put(info.name, info);
                    }
                    catch (PluginException x) {}
                    continue;
                }
                if (fname.endsWith(".jar.new")) {
                    try {
                        PluginInformation info = new PluginInformation((File)f, fname.substring(0, fname.length() - 8));
                        this.availablePlugins.put(info.name, info);
                        this.localPlugins.put(info.name, info);
                    }
                    catch (PluginException x) {}
                    continue;
                }
                if (!fname.matches("^[0-9]+-site.*\\.txt$")) continue;
                int err = 0;
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)f), "utf-8"));
                    String name = null;
                    String url = null;
                    String manifest = null;
                    String line = r.readLine();
                    while (line != null) {
                        if (line.startsWith("\t")) {
                            if ((line = line.substring(1)).length() > 70) {
                                manifest = manifest + line.substring(0, 70) + "\n";
                                line = " " + line.substring(70);
                            }
                            manifest = manifest + line + "\n";
                        } else {
                            if (name != null) {
                                try {
                                    PluginInformation info = new PluginInformation(new ByteArrayInputStream(manifest.getBytes("utf-8")), name.substring(0, name.length() - 4), url);
                                    if (!this.availablePlugins.containsKey(info.name)) {
                                        this.availablePlugins.put(info.name, info);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    ++err;
                                }
                            }
                            String[] x = line.split(";");
                            name = x[0];
                            url = x[1];
                            manifest = null;
                        }
                        line = r.readLine();
                    }
                    if (name != null) {
                        PluginInformation info = new PluginInformation(new ByteArrayInputStream(manifest.getBytes("utf-8")), name.substring(0, name.length() - 4), url);
                        if (!this.availablePlugins.containsKey(info.name)) {
                            this.availablePlugins.put(info.name, info);
                        }
                    }
                    r.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++err;
                }
                if (err <= 0) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error reading plugin information file: {0}", ((File)f).getName()), I18n.tr("Error"), 0);
            }
        }
        for (PluginProxy proxy : PluginHandler.pluginList) {
            if (!this.availablePlugins.containsKey(proxy.info.name)) {
                this.availablePlugins.put(proxy.info.name, proxy.info);
            }
            if (this.localPlugins.containsKey(proxy.info.name)) continue;
            this.localPlugins.put(proxy.info.name, proxy.info);
        }
    }
}

