/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractList;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyList<E>
extends AbstractList<E>
implements RandomAccess,
Cloneable {
    private E[] array;
    private int size;
    private boolean pristine;

    public CopyList(E[] array) {
        this(array, array.length);
    }

    private CopyList(E[] array, int size) {
        this.array = array;
        this.size = size;
        this.pristine = true;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        this.changeCheck();
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        this.array[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        this.changeCheck();
        ++this.modCount;
        E element = this.array[index];
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        } else {
            this.array[index] = null;
        }
        --this.size;
        return element;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.size + 1);
        this.changeCheck();
        this.array[this.size++] = element;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        while (this.size > 0) {
            this.array[--this.size] = null;
        }
    }

    public Object clone() {
        return new CopyList<E>(this.array, this.size);
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void changeCheck() {
        if (this.pristine) {
            this.array = (Object[])this.array.clone();
            this.pristine = false;
        }
    }

    private void ensureCapacity(int target) {
        ++this.modCount;
        if (target > this.array.length) {
            E[] old = this.array;
            int newCapacity = Math.max(target, this.array.length * 3 / 2 + 1);
            this.array = new Object[newCapacity];
            System.arraycopy(old, 0, this.array, 0, this.size);
            this.pristine = false;
        }
    }
}

