/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import org.openstreetmap.josm.gui.MainApplication;
import org.xnap.commons.i18n.I18nFactory;

public class I18n {
    private static final String TR_BASE = "org.openstreetmap.josm.i18n.Translation_";
    public static org.xnap.commons.i18n.I18n i18n;

    public static final String tr(String text, Object ... objects) {
        if (i18n == null) {
            return MessageFormat.format(I18n.filter(text), objects);
        }
        return I18n.filter(i18n.tr(text, objects));
    }

    public static final String tr(String text) {
        if (i18n == null) {
            return I18n.filter(text);
        }
        return I18n.filter(i18n.tr(text));
    }

    public static final String trc(String ctx, String text) {
        if (i18n == null) {
            return text;
        }
        return i18n.trc(ctx, text);
    }

    public static final String marktr(String text) {
        return text;
    }

    public static final String marktrc(String context, String text) {
        return text;
    }

    public static final String trn(String text, String pluralText, long n, Object ... objects) {
        if (i18n == null) {
            return n == 1L ? I18n.tr(text, objects) : I18n.tr(pluralText, objects);
        }
        return I18n.filter(i18n.trn(text, pluralText, n, objects));
    }

    public static final String trn(String text, String pluralText, long n) {
        if (i18n == null) {
            return n == 1L ? I18n.tr(text) : I18n.tr(pluralText);
        }
        return I18n.filter(i18n.trn(text, pluralText, n));
    }

    public static final String trnc(String ctx, String text, String pluralText, long n, Object ... objects) {
        if (i18n == null) {
            return n == 1L ? I18n.tr(text, objects) : I18n.tr(pluralText, objects);
        }
        return i18n.trnc(ctx, text, pluralText, n, objects);
    }

    public static final String trnc(String ctx, String text, String pluralText, long n) {
        if (i18n == null) {
            return n == 1L ? I18n.tr(text) : I18n.tr(pluralText);
        }
        return i18n.trnc(ctx, text, pluralText, n);
    }

    public static final String filter(String text) {
        int i;
        if (text.startsWith("_:") && (i = text.indexOf("\n")) >= 0) {
            return text.substring(i + 1);
        }
        return text;
    }

    public static final Locale[] getAvailableTranslations() {
        Vector<Locale> v = new Vector<Locale>();
        LinkedList<String> str = new LinkedList<String>();
        Locale[] l = Locale.getAvailableLocales();
        for (int i = 0; i < l.length; ++i) {
            String loc = l[i].toString();
            String cn = TR_BASE + loc;
            try {
                Class.forName(cn);
                v.add(l[i]);
                str.add(loc);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            if (!str.contains("nb")) {
                v.add(new Locale("nb"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (!str.contains("gl")) {
                v.add(new Locale("gl"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        l = new Locale[v.size()];
        l = v.toArray(l);
        Arrays.sort(l, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return l;
    }

    public static void init() {
        try {
            i18n = I18nFactory.getI18n(MainApplication.class);
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    public static void set(String localeName) {
        if (localeName != null) {
            int i;
            Locale d = Locale.getDefault();
            if (localeName.equals("he")) {
                localeName = "iw_IL";
            }
            Locale l = (i = localeName.indexOf(95)) > 0 ? new Locale(localeName.substring(0, i), localeName.substring(i + 1)) : new Locale(localeName);
            try {
                Locale.setDefault(l);
                i18n = I18nFactory.getI18n(MainApplication.class);
            }
            catch (MissingResourceException ex) {
                if (!l.getLanguage().equals("en")) {
                    System.out.println(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", l.getDisplayName(), d.getDisplayName()));
                    Locale.setDefault(d);
                }
                i18n = null;
            }
        }
    }
}

