/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProvider {
    private static Map<String, Image> cache = new HashMap<String, Image>();
    public static final List<ClassLoader> sources = new LinkedList<ClassLoader>();
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon get(String subdir, String name) {
        ImageIcon icon = ImageProvider.getIfAvailable(subdir, name);
        if (icon == null) {
            String ext = name.indexOf(46) != -1 ? "" : ".png";
            throw new NullPointerException("/images/" + subdir + "/" + name + ext + " not found");
        }
        return icon;
    }

    public static ImageIcon getIfAvailable(String subdir, String name) {
        return ImageProvider.getIfAvailable((Collection<String>)null, null, subdir, name);
    }

    public static final ImageIcon getIfAvailable(String[] dirs, String id, String subdir, String name) {
        return ImageProvider.getIfAvailable(Arrays.asList(dirs), id, subdir, name);
    }

    public static ImageIcon getIfAvailable(Collection<String> dirs, String id, String subdir, String name) {
        Image img;
        String full_name;
        if (name == null) {
            return null;
        }
        if (name.startsWith("http://")) {
            Image img2 = cache.get(name);
            if (img2 == null) {
                try {
                    MirroredInputStream is = new MirroredInputStream(name, new File(Main.pref.getPreferencesDir(), "images").toString());
                    if (is != null) {
                        img2 = Toolkit.getDefaultToolkit().createImage(is.getFile().toURI().toURL());
                        cache.put(name, img2);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return img2 == null ? null : new ImageIcon(img2);
        }
        if (subdir == null) {
            subdir = "";
        } else if (!subdir.equals("")) {
            subdir = subdir + "/";
        }
        String ext = name.indexOf(46) != -1 ? "" : ".png";
        String cache_name = full_name = subdir + name + ext;
        if (dirs != null && dirs.size() > 0) {
            cache_name = "id:" + id + ":" + full_name;
        }
        if ((img = cache.get(cache_name)) == null) {
            URL path = ImageProvider.getImageUrl(full_name, dirs);
            if (path == null) {
                return null;
            }
            img = Toolkit.getDefaultToolkit().createImage(path);
            cache.put(cache_name, img);
        }
        return new ImageIcon(img);
    }

    private static URL getImageUrl(String path, String name) {
        if (path.startsWith("resource://")) {
            String p = path.substring("resource://".length());
            for (ClassLoader source : sources) {
                URL res = source.getResource(p + name);
                if (res == null) continue;
                return res;
            }
        } else {
            try {
                File f = new File(path, name);
                if (f.exists()) {
                    return f.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL getImageUrl(String imageName, Collection<String> dirs) {
        URL u = null;
        if (dirs != null) {
            for (String name : dirs) {
                try {
                    u = ImageProvider.getImageUrl(name, imageName);
                    if (u == null) continue;
                    return u;
                }
                catch (SecurityException e) {
                    System.out.println(I18n.tr("Warning: failed to acccess directory ''{0}'' for security reasons. Exception was: {1}", name, e.toString()));
                }
            }
        }
        String dir = Main.pref.getPreferencesDir() + "images";
        try {
            u = ImageProvider.getImageUrl(dir, imageName);
            if (u != null) {
                return u;
            }
        }
        catch (SecurityException e) {
            System.out.println(I18n.tr("Warning: failed to acccess directory ''{0}'' for security reasons. Exception was: {1}", dir, e.toString()));
        }
        u = ImageProvider.getImageUrl("resource://images/", imageName);
        if (u != null) {
            return u;
        }
        for (String location : Main.pref.getAllPossiblePreferenceDirs()) {
            u = ImageProvider.getImageUrl(location + "images", imageName);
            if (u != null) {
                return u;
            }
            u = ImageProvider.getImageUrl(location, imageName);
            if (u == null) continue;
            return u;
        }
        System.out.println(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", imageName));
        return null;
    }

    public static ImageIcon get(String name) {
        return ImageProvider.get("", name);
    }

    public static Cursor getCursor(String name, String overlay) {
        ImageIcon img = ImageProvider.get("cursor", name);
        if (overlay != null) {
            img = ImageProvider.overlay(img, "cursor/modifier/" + overlay, OverlayPosition.SOUTHEAST);
        }
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(img.getImage(), name.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return c;
    }

    public static ImageIcon overlay(Icon ground, String overlayImage, OverlayPosition pos) {
        GraphicsConfiguration conf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int w = ground.getIconWidth();
        int h = ground.getIconHeight();
        ImageIcon overlay = ImageProvider.get(overlayImage);
        int wo = overlay.getIconWidth();
        int ho = overlay.getIconHeight();
        BufferedImage img = conf.createCompatibleImage(w, h, 3);
        Graphics2D g = img.createGraphics();
        ground.paintIcon(null, g, 0, 0);
        int x = 0;
        int y = 0;
        switch (pos) {
            case NORTHWEST: {
                x = 0;
                y = 0;
                break;
            }
            case NORTHEAST: {
                x = w - wo;
                y = 0;
                break;
            }
            case SOUTHWEST: {
                x = 0;
                y = h - ho;
                break;
            }
            case SOUTHEAST: {
                x = w - wo;
                y = h - ho;
            }
        }
        overlay.paintIcon(null, g, x, y);
        return new ImageIcon(img);
    }

    public static ImageIcon createRotatedImage(Component c, Icon icon, double rotatedAngle) {
        int h;
        int w;
        double originalAngle = rotatedAngle % 360.0;
        if (rotatedAngle != 0.0 && originalAngle == 0.0) {
            originalAngle = 360.0;
        }
        double angle = originalAngle % 90.0;
        if (originalAngle != 0.0 && angle == 0.0) {
            angle = 90.0;
        }
        double radian = Math.toRadians(angle);
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (originalAngle >= 0.0 && originalAngle <= 90.0 || originalAngle > 180.0 && originalAngle <= 270.0) {
            w = (int)((double)iw * Math.sin(1.5707963267948966 - radian) + (double)ih * Math.sin(radian));
            h = (int)((double)iw * Math.sin(radian) + (double)ih * Math.sin(1.5707963267948966 - radian));
        } else {
            w = (int)((double)ih * Math.sin(1.5707963267948966 - radian) + (double)iw * Math.sin(radian));
            h = (int)((double)ih * Math.sin(radian) + (double)iw * Math.sin(1.5707963267948966 - radian));
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        Graphics2D g2d = (Graphics2D)g.create();
        int cx = iw / 2;
        int cy = ih / 2;
        g2d.translate(w / 2, h / 2);
        g2d.rotate(Math.toRadians(originalAngle));
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(c, g2d, -cx, -cy);
        g2d.dispose();
        return new ImageIcon(image);
    }

    public static ImageIcon get(OsmPrimitiveType type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "type"));
        }
        return ImageProvider.get("data", type.getAPIName());
    }

    static {
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException ex) {
            sources.add(ImageProvider.class.getClassLoader());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

