/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String baseurl) {
        this.baseurl = baseurl;
    }

    public WikiReader() {
        this.baseurl = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
    }

    public String read(String url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "utf-8"));
        if (url.startsWith(this.baseurl) && !url.endsWith("?format=txt")) {
            return this.readFromTrac(in);
        }
        return this.readNormal(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLang(String text) {
        String languageCode = LanguageInfo.getWikiLanguagePrefix();
        String url = this.baseurl + "/wiki/" + languageCode + text;
        String res = "";
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            res = this.readFromTrac(new BufferedReader(new InputStreamReader(in, "utf-8")));
        }
        catch (IOException ioe) {
            System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", url, ioe.toString()));
        }
        catch (SecurityException e) {
            System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}'' for security reasons. Exception was: {1}", url, e.toString()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (res.length() == 0 && languageCode.length() != 0) {
            url = this.baseurl + "/wiki/" + text;
            try {
                in = new URL(url).openStream();
            }
            catch (IOException e) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", url, e.toString()));
                return res;
            }
            catch (SecurityException e) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}'' for security reasons. Exception was: {1}", url, e.toString()));
                return res;
            }
            try {
                res = this.readFromTrac(new BufferedReader(new InputStreamReader(in, "utf-8")));
            }
            catch (IOException ioe) {
                System.out.println(I18n.tr("Warning: failed to read MOTD from ''{0}''. Exception was: {1}", url, ioe.toString()));
                String string = res;
                return string;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return res;
    }

    private String readNormal(BufferedReader in) throws IOException {
        String b = "";
        String line = in.readLine();
        while (line != null) {
            if (!line.contains("[[TranslatedPages]]")) {
                b = b + line.replaceAll(" />", ">") + "\n";
            }
            line = in.readLine();
        }
        return "<html>" + b + "</html>";
    }

    private String readFromTrac(BufferedReader in) throws IOException {
        boolean inside = false;
        boolean transl = false;
        String b = "";
        String line = in.readLine();
        while (line != null) {
            if (line.contains("<div id=\"searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"wiki-toc trac-nav\"")) {
                transl = true;
            } else if (line.contains("<div class=\"wikipage searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"buttons\">")) {
                inside = false;
            } else if (line.contains("<h3>Attachments</h3>")) {
                inside = false;
            }
            if (inside && !transl) {
                b = b + line.replaceAll("<img src=\"/", "<img border=\"0\" src=\"" + this.baseurl + "/").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (transl && line.contains("</div>")) {
                transl = false;
            }
            line = in.readLine();
        }
        if (b.indexOf("      Describe ") >= 0) {
            return "";
        }
        return "<html>" + b + "</html>";
    }
}

