/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetReader
implements RowSetReader,
Serializable {
    private int writerCalls = 0;
    private boolean userCon = false;
    private int startPosition;
    private JdbcRowSetResourceBundle resBundle;

    public CachedRowSetReader() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void readData(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = null;
        try {
            CachedRowSet cachedRowSet = (CachedRowSet)((Object)rowSetInternal);
            if (cachedRowSet.getPageSize() == 0 && cachedRowSet.size() > 0) {
                cachedRowSet.close();
            }
            this.writerCalls = 0;
            this.userCon = false;
            connection = this.connect(rowSetInternal);
            if (connection == null || cachedRowSet.getCommand() == null) {
                throw new SQLException(this.resBundle.handleGetObject("crsreader.connecterr").toString());
            }
            try {
                connection.setTransactionIsolation(cachedRowSet.getTransactionIsolation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            PreparedStatement preparedStatement = connection.prepareStatement(cachedRowSet.getCommand());
            this.decodeParams(rowSetInternal.getParams(), preparedStatement);
            try {
                preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
            if (cachedRowSet.getCommand().toLowerCase().indexOf("select") != -1) {
                ResultSet resultSet = preparedStatement.executeQuery();
                if (cachedRowSet.getPageSize() == 0) {
                    cachedRowSet.populate(resultSet);
                } else {
                    preparedStatement = connection.prepareStatement(cachedRowSet.getCommand(), 1004, 1008);
                    this.decodeParams(rowSetInternal.getParams(), preparedStatement);
                    try {
                        preparedStatement.setMaxRows(cachedRowSet.getMaxRows());
                        preparedStatement.setMaxFieldSize(cachedRowSet.getMaxFieldSize());
                        preparedStatement.setEscapeProcessing(cachedRowSet.getEscapeProcessing());
                        preparedStatement.setQueryTimeout(cachedRowSet.getQueryTimeout());
                    }
                    catch (Exception exception) {
                        throw new SQLException(exception.getMessage());
                    }
                    resultSet = preparedStatement.executeQuery();
                    cachedRowSet.populate(resultSet, this.startPosition);
                }
                resultSet.close();
            } else {
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.getCloseConnection()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            block30: {
                try {
                    if (connection == null || !this.getCloseConnection()) break block30;
                    try {
                        if (!connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (Exception exception) {}
                    connection.close();
                    connection = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public boolean reset() throws SQLException {
        ++this.writerCalls;
        return this.writerCalls == 1;
    }

    public Connection connect(RowSetInternal rowSetInternal) throws SQLException {
        if (rowSetInternal.getConnection() != null) {
            this.userCon = true;
            return rowSetInternal.getConnection();
        }
        if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                if (((RowSet)((Object)rowSetInternal)).getUsername() != null) {
                    return dataSource.getConnection(((RowSet)((Object)rowSetInternal)).getUsername(), ((RowSet)((Object)rowSetInternal)).getPassword());
                }
                return dataSource.getConnection();
            }
            catch (NamingException namingException) {
                SQLException sQLException = new SQLException(this.resBundle.handleGetObject("crsreader.connect").toString());
                sQLException.initCause(namingException);
                throw sQLException;
            }
        }
        if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            return DriverManager.getConnection(((RowSet)((Object)rowSetInternal)).getUrl(), ((RowSet)((Object)rowSetInternal)).getUsername(), ((RowSet)((Object)rowSetInternal)).getPassword());
        }
        return null;
    }

    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        Object[] objectArray2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[i];
                if (objectArray2.length == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i + 1, (Integer)objectArray2[1]);
                        continue;
                    }
                    if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println(this.resBundle.handleGetObject("crsreader.datedetected").toString());
                        if (objectArray2[1] instanceof Calendar) {
                            System.err.println(this.resBundle.handleGetObject("crsreader.caldetected").toString());
                            preparedStatement.setDate(i + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                            continue;
                        }
                        throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                    }
                    if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(i + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        continue;
                    }
                    if (!(objectArray2[1] instanceof Integer)) continue;
                    preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2.length == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                        continue;
                    }
                    if (objectArray2[0] instanceof InputStream) {
                        switch ((Integer)objectArray2[2]) {
                            case 0: {
                                preparedStatement.setUnicodeStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 1: {
                                preparedStatement.setBinaryStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 2: {
                                preparedStatement.setAsciiStream(i + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                        }
                        throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                    }
                    if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                        preparedStatement.setObject(i + 1, objectArray2[0], (Integer)objectArray2[1], (Integer)objectArray2[2]);
                        continue;
                    }
                    throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                }
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            preparedStatement.setObject(i + 1, objectArray[i]);
        }
    }

    protected boolean getCloseConnection() {
        return !this.userCon;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }
}

