/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import sun.awt.FontDescriptor;
import sun.awt.SunToolkit;
import sun.font.CompositeFontDescriptor;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;

public abstract class FontConfiguration {
    protected static String osVersion;
    protected static String osName;
    protected static String encoding;
    protected static Locale startupLocale;
    protected static Hashtable localeMap;
    private static FontConfiguration fontConfig;
    private static Logger logger;
    protected static boolean isProperties;
    protected SunGraphicsEnvironment environment;
    protected boolean preferLocaleFonts;
    protected boolean preferPropFonts;
    private File fontConfigFile;
    private boolean foundOsSpecificFile;
    private boolean inited;
    private String javaLib;
    private static short stringIDNum;
    private static short[] stringIDs;
    private static StringBuilder stringTable;
    public static boolean verbose;
    private short initELC = (short)-1;
    private Locale initLocale;
    private String initEncoding;
    private String alphabeticSuffix;
    private short[][][] compFontNameIDs = new short[5][4][];
    private int[][][] compExclusions = new int[5][][];
    private int[] compCoreNum = new int[5];
    private Set<Short> coreFontNameIDs = new HashSet<Short>();
    private Set<Short> fallbackFontNameIDs = new HashSet<Short>();
    protected static final int NUM_FONTS = 5;
    protected static final int NUM_STYLES = 4;
    protected static final String[] fontNames;
    protected static final String[] publicFontNames;
    protected static final String[] styleNames;
    protected static String[] installedFallbackFontFiles;
    protected HashMap reorderMap = null;
    private Hashtable charsetRegistry = new Hashtable(5);
    private FontDescriptor[][][] fontDescriptors = new FontDescriptor[5][4][];
    HashMap<String, Boolean> existsMap;
    private int numCoreFonts = -1;
    private String[] componentFonts = null;
    HashMap<String, String> filenamesMap = new HashMap();
    HashSet<String> coreFontFileNames = new HashSet();
    private static final int HEAD_LENGTH = 20;
    private static final int INDEX_scriptIDs = 0;
    private static final int INDEX_scriptFonts = 1;
    private static final int INDEX_elcIDs = 2;
    private static final int INDEX_sequences = 3;
    private static final int INDEX_fontfileNameIDs = 4;
    private static final int INDEX_componentFontNameIDs = 5;
    private static final int INDEX_filenames = 6;
    private static final int INDEX_awtfontpaths = 7;
    private static final int INDEX_exclusions = 8;
    private static final int INDEX_proportionals = 9;
    private static final int INDEX_scriptFontsMotif = 10;
    private static final int INDEX_alphabeticSuffix = 11;
    private static final int INDEX_stringIDs = 12;
    private static final int INDEX_stringTable = 13;
    private static final int INDEX_TABLEEND = 14;
    private static final int INDEX_fallbackScripts = 15;
    private static final int INDEX_appendedfontpath = 16;
    private static final int INDEX_version = 17;
    private static short[] head;
    private static short[] table_scriptIDs;
    private static short[] table_scriptFonts;
    private static short[] table_elcIDs;
    private static short[] table_sequences;
    private static short[] table_fontfileNameIDs;
    private static short[] table_componentFontNameIDs;
    private static short[] table_filenames;
    protected static short[] table_awtfontpaths;
    private static short[] table_exclusions;
    private static short[] table_proportionals;
    private static short[] table_scriptFontsMotif;
    private static short[] table_alphabeticSuffix;
    private static short[] table_stringIDs;
    private static char[] table_stringTable;
    private HashMap<String, Short> reorderScripts;
    private static String[] stringCache;
    private static final int[] EMPTY_INT_ARRAY;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final short[] EMPTY_SHORT_ARRAY;
    private static final String UNDEFINED_COMPONENT_FONT = "unknown";

    public FontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment) {
        if (SunGraphicsEnvironment.debugFonts && logger == null) {
            logger = Logger.getLogger("sun.awt.FontConfiguration");
        }
        this.environment = sunGraphicsEnvironment;
        this.setOsNameAndVersion();
        this.setEncoding();
        this.findFontConfigFile();
    }

    public synchronized boolean init() {
        if (!this.inited) {
            this.preferLocaleFonts = false;
            this.preferPropFonts = false;
            this.setFontConfiguration();
            this.readFontConfigFile(this.fontConfigFile);
            this.initFontConfig();
            this.inited = true;
        }
        return true;
    }

    public FontConfiguration(SunGraphicsEnvironment sunGraphicsEnvironment, boolean bl, boolean bl2) {
        this.environment = sunGraphicsEnvironment;
        this.preferLocaleFonts = bl;
        this.preferPropFonts = bl2;
        this.initFontConfig();
    }

    protected void setOsNameAndVersion() {
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
    }

    private void setEncoding() {
        encoding = Charset.defaultCharset().name();
        startupLocale = SunToolkit.getStartupLocale();
    }

    public boolean foundOsSpecificFile() {
        return this.foundOsSpecificFile;
    }

    public boolean fontFilesArePresent() {
        this.init();
        short s = this.compFontNameIDs[0][0][0];
        short s2 = FontConfiguration.getComponentFileID(s);
        final String string = this.mapFileName(FontConfiguration.getComponentFileName(s2));
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File file = new File(string);
                    return file.exists();
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        return bl;
    }

    private void findFontConfigFile() {
        this.foundOsSpecificFile = true;
        String string = System.getProperty("java.home");
        if (string == null) {
            throw new Error("java.home property not set");
        }
        this.javaLib = string + File.separator + "lib";
        String string2 = System.getProperty("sun.awt.fontconfig");
        this.fontConfigFile = string2 != null ? new File(string2) : this.findFontConfigFile(this.javaLib);
    }

    private void readFontConfigFile(File file) {
        Object object;
        block7: {
            this.getInstalledFallbackFonts(this.javaLib);
            if (file != null) {
                try {
                    object = new FileInputStream(file.getPath());
                    if (isProperties) {
                        FontConfiguration.loadProperties((InputStream)object);
                    } else {
                        FontConfiguration.loadBinary((InputStream)object);
                    }
                    ((FileInputStream)object).close();
                    if (SunGraphicsEnvironment.debugFonts) {
                        logger.config("Read logical font configuration from " + file);
                    }
                }
                catch (IOException iOException) {
                    if (!SunGraphicsEnvironment.debugFonts) break block7;
                    logger.config("Failed to read logical font configuration from " + file);
                }
            }
        }
        if (!"1".equals(object = this.getVersion()) && SunGraphicsEnvironment.debugFonts) {
            logger.config("Unsupported fontconfig version: " + (String)object);
        }
    }

    protected void getInstalledFallbackFonts(String string) {
        String string2 = string + File.separator + "fonts" + File.separator + "fallback";
        File file = new File(string2);
        if (file.exists() && file.isDirectory()) {
            int n;
            String[] stringArray = file.list(SunGraphicsEnvironment.ttFilter);
            String[] stringArray2 = file.list(SunGraphicsEnvironment.t1Filter);
            int n2 = stringArray == null ? 0 : stringArray.length;
            int n3 = stringArray2 == null ? 0 : stringArray2.length;
            int n4 = n2 + n3;
            if (n2 + n3 == 0) {
                return;
            }
            installedFallbackFontFiles = new String[n4];
            for (n = 0; n < n2; ++n) {
                FontConfiguration.installedFallbackFontFiles[n] = file + File.separator + stringArray[n];
            }
            for (n = 0; n < n3; ++n) {
                FontConfiguration.installedFallbackFontFiles[n + n2] = file + File.separator + stringArray2[n];
            }
            this.environment.registerFontsInDir(string2);
        }
    }

    private File findImpl(String string) {
        File file = new File(string + ".properties");
        if (file.canRead()) {
            isProperties = true;
            return file;
        }
        file = new File(string + ".bfc");
        if (file.canRead()) {
            isProperties = false;
            return file;
        }
        return null;
    }

    private File findFontConfigFile(String string) {
        File file;
        String string2 = string + File.separator + "fontconfig";
        if (osVersion != null && osName != null && (file = this.findImpl(string2 + "." + osName + "." + osVersion)) != null) {
            return file;
        }
        if (osName != null && (file = this.findImpl(string2 + "." + osName)) != null) {
            return file;
        }
        if (osVersion != null && (file = this.findImpl(string2 + "." + osVersion)) != null) {
            return file;
        }
        this.foundOsSpecificFile = false;
        file = this.findImpl(string2);
        if (file != null) {
            return file;
        }
        return null;
    }

    public static void loadBinary(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        head = FontConfiguration.readShortTable(dataInputStream, 20);
        int[] nArray = new int[14];
        for (n = 0; n < 14; ++n) {
            nArray[n] = head[n + 1] - head[n];
        }
        table_scriptIDs = FontConfiguration.readShortTable(dataInputStream, nArray[0]);
        table_scriptFonts = FontConfiguration.readShortTable(dataInputStream, nArray[1]);
        table_elcIDs = FontConfiguration.readShortTable(dataInputStream, nArray[2]);
        table_sequences = FontConfiguration.readShortTable(dataInputStream, nArray[3]);
        table_fontfileNameIDs = FontConfiguration.readShortTable(dataInputStream, nArray[4]);
        table_componentFontNameIDs = FontConfiguration.readShortTable(dataInputStream, nArray[5]);
        table_filenames = FontConfiguration.readShortTable(dataInputStream, nArray[6]);
        table_awtfontpaths = FontConfiguration.readShortTable(dataInputStream, nArray[7]);
        table_exclusions = FontConfiguration.readShortTable(dataInputStream, nArray[8]);
        table_proportionals = FontConfiguration.readShortTable(dataInputStream, nArray[9]);
        table_scriptFontsMotif = FontConfiguration.readShortTable(dataInputStream, nArray[10]);
        table_alphabeticSuffix = FontConfiguration.readShortTable(dataInputStream, nArray[11]);
        table_stringIDs = FontConfiguration.readShortTable(dataInputStream, nArray[12]);
        stringCache = new String[table_stringIDs.length + 1];
        n = nArray[13];
        byte[] byArray = new byte[n * 2];
        table_stringTable = new char[n];
        dataInputStream.read(byArray);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            FontConfiguration.table_stringTable[n2++] = (char)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
        }
        if (verbose) {
            FontConfiguration.dump();
        }
    }

    public static void saveBinary(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        FontConfiguration.writeShortTable(dataOutputStream, head);
        FontConfiguration.writeShortTable(dataOutputStream, table_scriptIDs);
        FontConfiguration.writeShortTable(dataOutputStream, table_scriptFonts);
        FontConfiguration.writeShortTable(dataOutputStream, table_elcIDs);
        FontConfiguration.writeShortTable(dataOutputStream, table_sequences);
        FontConfiguration.writeShortTable(dataOutputStream, table_fontfileNameIDs);
        FontConfiguration.writeShortTable(dataOutputStream, table_componentFontNameIDs);
        FontConfiguration.writeShortTable(dataOutputStream, table_filenames);
        FontConfiguration.writeShortTable(dataOutputStream, table_awtfontpaths);
        FontConfiguration.writeShortTable(dataOutputStream, table_exclusions);
        FontConfiguration.writeShortTable(dataOutputStream, table_proportionals);
        FontConfiguration.writeShortTable(dataOutputStream, table_scriptFontsMotif);
        FontConfiguration.writeShortTable(dataOutputStream, table_alphabeticSuffix);
        FontConfiguration.writeShortTable(dataOutputStream, table_stringIDs);
        dataOutputStream.writeChars(new String(table_stringTable));
        outputStream.close();
        if (verbose) {
            FontConfiguration.dump();
        }
        FontConfiguration.sanityCheck();
    }

    public static void loadProperties(InputStream inputStream) throws IOException {
        stringIDNum = 1;
        stringIDs = new short[1000];
        stringTable = new StringBuilder(4096);
        if (verbose && logger == null) {
            logger = Logger.getLogger("sun.awt.FontConfiguration");
        }
        new PropertiesHandler().load(inputStream);
        stringIDs = null;
        stringTable = null;
    }

    private void initFontConfig() {
        this.initLocale = startupLocale;
        this.initEncoding = encoding;
        if (this.preferLocaleFonts && !FontConfiguration.willReorderForStartupLocale()) {
            this.preferLocaleFonts = false;
        }
        this.initELC = this.getInitELC();
        this.initAllComponentFonts();
    }

    private short getInitELC() {
        if (this.initELC != -1) {
            return this.initELC;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < table_elcIDs.length; ++i) {
            hashMap.put(FontConfiguration.getString(table_elcIDs[i]), i);
        }
        String string = this.initLocale.getLanguage();
        String string2 = this.initLocale.getCountry();
        String string3 = this.initEncoding + "." + string + "." + string2;
        this.initELC = hashMap.containsKey(string3) || hashMap.containsKey(string3 = this.initEncoding + "." + string) || hashMap.containsKey(string3 = this.initEncoding) ? ((Integer)hashMap.get(string3)).shortValue() : ((Integer)hashMap.get("NULL.NULL.NULL")).shortValue();
        for (int i = 0; i < table_alphabeticSuffix.length; i += 2) {
            if (this.initELC != table_alphabeticSuffix[i]) continue;
            this.alphabeticSuffix = FontConfiguration.getString(table_alphabeticSuffix[i + 1]);
            return this.initELC;
        }
        return this.initELC;
    }

    private void initAllComponentFonts() {
        short[] sArray = FontConfiguration.getFallbackScripts();
        for (int i = 0; i < 5; ++i) {
            int n;
            short[] sArray2 = this.getCoreScripts(i);
            this.compCoreNum[i] = sArray2.length;
            int[][] nArrayArray = new int[sArray2.length][];
            for (n = 0; n < sArray2.length; ++n) {
                nArrayArray[n] = FontConfiguration.getExclusionRanges(sArray2[n]);
            }
            this.compExclusions[i] = nArrayArray;
            for (n = 0; n < 4; ++n) {
                int n2;
                short[] sArray3 = new short[sArray2.length + sArray.length];
                for (n2 = 0; n2 < sArray2.length; ++n2) {
                    sArray3[n2] = FontConfiguration.getComponentFontID(sArray2[n2], i, n);
                    if (this.preferLocaleFonts && localeMap != null && FontManager.usingAlternateFontforJALocales()) {
                        sArray3[n2] = this.remapLocaleMap(i, n, sArray2[n2], sArray3[n2]);
                    }
                    if (this.preferPropFonts) {
                        sArray3[n2] = this.remapProportional(i, sArray3[n2]);
                    }
                    this.coreFontNameIDs.add(sArray3[n2]);
                }
                for (int j = 0; j < sArray.length; ++j) {
                    short s = FontConfiguration.getComponentFontID(sArray[j], i, n);
                    if (this.preferLocaleFonts && localeMap != null && FontManager.usingAlternateFontforJALocales()) {
                        s = this.remapLocaleMap(i, n, sArray[j], s);
                    }
                    if (this.preferPropFonts) {
                        s = this.remapProportional(i, s);
                    }
                    if (FontConfiguration.contains(sArray3, s, n2)) continue;
                    this.fallbackFontNameIDs.add(s);
                    sArray3[n2++] = s;
                }
                if (n2 < sArray3.length) {
                    short[] sArray4 = new short[n2];
                    System.arraycopy(sArray3, 0, sArray4, 0, n2);
                    sArray3 = sArray4;
                }
                this.compFontNameIDs[i][n] = sArray3;
            }
        }
    }

    private short remapLocaleMap(int n, int n2, short s, short s2) {
        String string;
        String string2 = FontConfiguration.getString(table_scriptIDs[s]);
        String string3 = (String)localeMap.get(string2);
        if (string3 == null) {
            String string4 = fontNames[n];
            string = styleNames[n2];
            string3 = (String)localeMap.get(string4 + "." + string + "." + string2);
        }
        if (string3 == null) {
            return s2;
        }
        for (int i = 0; i < table_componentFontNameIDs.length; ++i) {
            string = FontConfiguration.getString(table_componentFontNameIDs[i]);
            if (!string3.equalsIgnoreCase(string)) continue;
            s2 = (short)i;
            break;
        }
        return s2;
    }

    public static boolean hasMonoToPropMap() {
        return table_proportionals != null && table_proportionals.length != 0;
    }

    private short remapProportional(int n, short s) {
        if (this.preferPropFonts && table_proportionals.length != 0 && n != 2 && n != 4) {
            for (int i = 0; i < table_proportionals.length; i += 2) {
                if (table_proportionals[i] != s) continue;
                return table_proportionals[i + 1];
            }
        }
        return s;
    }

    public static boolean isLogicalFontFamilyName(String string) {
        return FontConfiguration.isLogicalFontFamilyNameLC(string.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isLogicalFontFamilyNameLC(String string) {
        for (int i = 0; i < fontNames.length; ++i) {
            if (!string.equals(fontNames[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isLogicalFontStyleName(String string) {
        for (int i = 0; i < styleNames.length; ++i) {
            if (!string.equals(styleNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isLogicalFontFaceName(String string) {
        return FontConfiguration.isLogicalFontFaceNameLC(string.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isLogicalFontFaceNameLC(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return FontConfiguration.isLogicalFontFamilyName(string2) && FontConfiguration.isLogicalFontStyleName(string3);
        }
        return FontConfiguration.isLogicalFontFamilyName(string);
    }

    protected static int getFontIndex(String string) {
        return FontConfiguration.getArrayIndex(fontNames, string);
    }

    protected static int getStyleIndex(String string) {
        return FontConfiguration.getArrayIndex(styleNames, string);
    }

    private static int getArrayIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        assert (false);
        return 0;
    }

    protected static int getStyleIndex(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    protected static String getFontName(int n) {
        return fontNames[n];
    }

    protected static String getStyleName(int n) {
        return styleNames[n];
    }

    public static String getLogicalFontFaceName(String string, int n) {
        assert (FontConfiguration.isLogicalFontFamilyName(string));
        return string.toLowerCase(Locale.ENGLISH) + "." + FontConfiguration.getStyleString(n);
    }

    public static String getStyleString(int n) {
        return FontConfiguration.getStyleName(FontConfiguration.getStyleIndex(n));
    }

    public abstract String getFallbackFamilyName(String var1, String var2);

    protected String getCompatibilityFamilyName(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("timesroman")) {
            return "serif";
        }
        if (string.equals("helvetica")) {
            return "sansserif";
        }
        if (string.equals("courier")) {
            return "monospaced";
        }
        return null;
    }

    protected String mapFileName(String string) {
        return string;
    }

    protected abstract void initReorderMap();

    private void shuffle(String[] stringArray, int n, int n2) {
        if (n2 >= n) {
            return;
        }
        String string = stringArray[n];
        for (int i = n; i > n2; --i) {
            stringArray[i] = stringArray[i - 1];
        }
        stringArray[n2] = string;
    }

    public static boolean willReorderForStartupLocale() {
        return FontConfiguration.getReorderSequence() != null;
    }

    private static Object getReorderSequence() {
        if (FontConfiguration.fontConfig.reorderMap == null) {
            fontConfig.initReorderMap();
        }
        HashMap hashMap = FontConfiguration.fontConfig.reorderMap;
        String string = startupLocale.getLanguage();
        String string2 = startupLocale.getCountry();
        Object v = hashMap.get(encoding + "." + string + "." + string2);
        if (v == null) {
            v = hashMap.get(encoding + "." + string);
        }
        if (v == null) {
            v = hashMap.get(encoding);
        }
        return v;
    }

    private void reorderSequenceForLocale(String[] stringArray) {
        block4: {
            Object object;
            block3: {
                object = FontConfiguration.getReorderSequence();
                if (!(object instanceof String)) break block3;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(object)) continue;
                    this.shuffle(stringArray, i, 0);
                    return;
                }
                break block4;
            }
            if (!(object instanceof String[])) break block4;
            String[] stringArray2 = (String[])object;
            for (int i = 0; i < stringArray2.length; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(stringArray2[i])) continue;
                    this.shuffle(stringArray, j, i);
                }
            }
        }
    }

    private static Vector splitSequence(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) >= 0) {
            vector.add(string.substring(n2, n));
            n2 = n + 1;
        }
        if (string.length() > n2) {
            vector.add(string.substring(n2, string.length()));
        }
        return vector;
    }

    protected String[] split(String string) {
        Vector vector = FontConfiguration.splitSequence(string);
        return vector.toArray(new String[0]);
    }

    public FontDescriptor[] getFontDescriptors(String string, int n) {
        assert (FontConfiguration.isLogicalFontFamilyName(string));
        string = string.toLowerCase(Locale.ENGLISH);
        int n2 = FontConfiguration.getFontIndex(string);
        int n3 = FontConfiguration.getStyleIndex(n);
        return this.getFontDescriptors(n2, n3);
    }

    private FontDescriptor[] getFontDescriptors(int n, int n2) {
        FontDescriptor[] fontDescriptorArray = this.fontDescriptors[n][n2];
        if (fontDescriptorArray == null) {
            fontDescriptorArray = this.buildFontDescriptors(n, n2);
            this.fontDescriptors[n][n2] = fontDescriptorArray;
        }
        return fontDescriptorArray;
    }

    private FontDescriptor[] buildFontDescriptors(int n, int n2) {
        String string = fontNames[n];
        String string2 = styleNames[n2];
        short[] sArray = this.getCoreScripts(n);
        short[] sArray2 = this.compFontNameIDs[n][n2];
        String[] stringArray = new String[sArray.length];
        String[] stringArray2 = new String[sArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = FontConfiguration.getComponentFontName(sArray2[i]);
            stringArray[i] = FontConfiguration.getScriptName(sArray[i]);
            if (this.alphabeticSuffix == null || !"alphabetic".equals(stringArray[i])) continue;
            stringArray[i] = stringArray[i] + "/" + this.alphabeticSuffix;
        }
        int[][] nArray = this.compExclusions[n];
        FontDescriptor[] fontDescriptorArray = new FontDescriptor[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string3 = this.makeAWTFontName(stringArray2[i], stringArray[i]);
            String string4 = this.getEncoding(stringArray2[i], stringArray[i]);
            if (string4 == null) {
                string4 = "default";
            }
            CharsetEncoder charsetEncoder = this.getFontCharsetEncoder(string4.trim(), string3);
            int[] nArray2 = nArray[i];
            fontDescriptorArray[i] = new FontDescriptor(string3, charsetEncoder, nArray2);
        }
        return fontDescriptorArray;
    }

    protected String makeAWTFontName(String string, String string2) {
        return string;
    }

    protected abstract String getEncoding(String var1, String var2);

    private CharsetEncoder getFontCharsetEncoder(final String string, String string2) {
        Charset charset = null;
        charset = string.equals("default") ? (Charset)this.charsetRegistry.get(string2) : (Charset)this.charsetRegistry.get(string);
        if (charset != null) {
            return charset.newEncoder();
        }
        if (!string.startsWith("sun.awt.") && !string.equals("default")) {
            charset = Charset.forName(string);
        } else {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return null;
                    }
                }
            });
            if (clazz != null) {
                try {
                    charset = (Charset)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (charset == null) {
            charset = this.getDefaultFontCharset(string2);
        }
        if (string.equals("default")) {
            this.charsetRegistry.put(string2, charset);
        } else {
            this.charsetRegistry.put(string, charset);
        }
        return charset.newEncoder();
    }

    protected abstract Charset getDefaultFontCharset(String var1);

    public HashSet<String> getAWTFontPathSet() {
        return null;
    }

    public CompositeFontDescriptor[] get2DCompositeFontInfo() {
        CompositeFontDescriptor[] compositeFontDescriptorArray = new CompositeFontDescriptor[20];
        String string = this.environment.getDefaultFontFile();
        String string2 = this.environment.getDefaultFontFaceName();
        for (int i = 0; i < 5; ++i) {
            int n;
            int n2;
            String string3 = publicFontNames[i];
            int[][] nArray = this.compExclusions[i];
            int n3 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                n3 += nArray[j].length;
            }
            int[] nArray2 = new int[n3];
            int[] nArray3 = new int[nArray.length];
            int n4 = 0;
            boolean bl = false;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int[] nArray4 = nArray[n2];
                n = 0;
                while (n < nArray4.length) {
                    int n5 = nArray4[n];
                    nArray2[n4++] = nArray4[n++];
                    nArray2[n4++] = nArray4[n++];
                }
                nArray3[n2] = n4;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                int[] nArray5;
                short s;
                int n6;
                int n7 = this.compFontNameIDs[i][n2].length;
                n = 0;
                if (installedFallbackFontFiles != null) {
                    n7 += installedFallbackFontFiles.length;
                }
                String string4 = string3 + "." + styleNames[n2];
                String[] stringArray = new String[n7];
                String[] stringArray2 = new String[n7];
                for (n6 = 0; n6 < this.compFontNameIDs[i][n2].length; ++n6) {
                    s = this.compFontNameIDs[i][n2][n6];
                    short s2 = FontConfiguration.getComponentFileID(s);
                    stringArray[n6] = this.getFaceNameFromComponentFontName(FontConfiguration.getComponentFontName(s));
                    stringArray2[n6] = this.mapFileName(FontConfiguration.getComponentFileName(s2));
                    if (stringArray2[n6] == null || this.needToSearchForFile(stringArray2[n6])) {
                        stringArray2[n6] = this.getFileNameFromComponentFontName(FontConfiguration.getComponentFontName(s));
                    }
                    if (n != 0 || !string.equals(stringArray2[n6])) continue;
                    n = 1;
                }
                if (n == 0) {
                    s = 0;
                    if (installedFallbackFontFiles != null) {
                        s = installedFallbackFontFiles.length;
                    }
                    if (n6 + s == n7) {
                        String[] stringArray3 = new String[n7 + 1];
                        System.arraycopy(stringArray, 0, stringArray3, 0, n6);
                        stringArray = stringArray3;
                        String[] stringArray4 = new String[n7 + 1];
                        System.arraycopy(stringArray2, 0, stringArray4, 0, n6);
                        stringArray2 = stringArray4;
                    }
                    stringArray[n6] = string2;
                    stringArray2[n6] = string;
                    ++n6;
                }
                if (installedFallbackFontFiles != null) {
                    for (s = 0; s < installedFallbackFontFiles.length; ++s) {
                        stringArray[n6] = null;
                        stringArray2[n6] = installedFallbackFontFiles[s];
                        ++n6;
                    }
                }
                if (n6 < n7) {
                    String[] stringArray5 = new String[n6];
                    System.arraycopy(stringArray, 0, stringArray5, 0, n6);
                    stringArray = stringArray5;
                    String[] stringArray6 = new String[n6];
                    System.arraycopy(stringArray2, 0, stringArray6, 0, n6);
                    stringArray2 = stringArray6;
                }
                if (n6 != (nArray5 = nArray3).length) {
                    int n8 = nArray3.length;
                    nArray5 = new int[n6];
                    System.arraycopy(nArray3, 0, nArray5, 0, n8);
                    for (int j = n8; j < n6; ++j) {
                        nArray5[j] = nArray2.length;
                    }
                }
                compositeFontDescriptorArray[i * 4 + n2] = new CompositeFontDescriptor(string4, this.compCoreNum[i], stringArray, stringArray2, nArray2, nArray5);
            }
        }
        return compositeFontDescriptorArray;
    }

    protected abstract String getFaceNameFromComponentFontName(String var1);

    protected abstract String getFileNameFromComponentFontName(String var1);

    public boolean needToSearchForFile(String string) {
        Boolean bl;
        if (!SunGraphicsEnvironment.isLinuxOrBSD) {
            return false;
        }
        if (this.existsMap == null) {
            this.existsMap = new HashMap();
        }
        if ((bl = this.existsMap.get(string)) == null) {
            this.getNumberCoreFonts();
            if (!this.coreFontFileNames.contains(string)) {
                bl = Boolean.TRUE;
            } else {
                bl = new File(string).exists();
                this.existsMap.put(string, bl);
                if (SunGraphicsEnvironment.debugFonts && bl == Boolean.FALSE) {
                    logger.warning("Couldn't locate font file " + string);
                }
            }
        }
        return bl == Boolean.FALSE;
    }

    public int getNumberCoreFonts() {
        if (this.numCoreFonts == -1) {
            short s;
            short s2;
            int n;
            this.numCoreFonts = this.coreFontNameIDs.size();
            Short[] shortArray = new Short[]{};
            Short[] shortArray2 = this.coreFontNameIDs.toArray(shortArray);
            Short[] shortArray3 = this.fallbackFontNameIDs.toArray(shortArray);
            int n2 = 0;
            for (n = 0; n < shortArray3.length; ++n) {
                if (this.coreFontNameIDs.contains(shortArray3[n])) {
                    shortArray3[n] = null;
                    continue;
                }
                ++n2;
            }
            this.componentFonts = new String[this.numCoreFonts + n2];
            Object var6_6 = null;
            for (n = 0; n < shortArray2.length; ++n) {
                s2 = shortArray2[n];
                s = FontConfiguration.getComponentFileID(s2);
                this.componentFonts[n] = FontConfiguration.getComponentFontName(s2);
                String string = FontConfiguration.getComponentFileName(s);
                if (string != null) {
                    this.coreFontFileNames.add(string);
                }
                this.filenamesMap.put(this.componentFonts[n], this.mapFileName(string));
            }
            for (s2 = 0; s2 < shortArray3.length; ++s2) {
                if (shortArray3[s2] == null) continue;
                s = shortArray3[s2];
                short s3 = FontConfiguration.getComponentFileID(s);
                this.componentFonts[n] = FontConfiguration.getComponentFontName(s);
                this.filenamesMap.put(this.componentFonts[n], this.mapFileName(FontConfiguration.getComponentFileName(s3)));
                ++n;
            }
        }
        return this.numCoreFonts;
    }

    public String[] getPlatformFontNames() {
        if (this.numCoreFonts == -1) {
            this.getNumberCoreFonts();
        }
        return this.componentFonts;
    }

    public String getFileNameFromPlatformName(String string) {
        return this.filenamesMap.get(string);
    }

    public String getExtraFontPath() {
        return FontConfiguration.getString(head[16]);
    }

    public String getVersion() {
        return FontConfiguration.getString(head[17]);
    }

    protected static FontConfiguration getFontConfiguration() {
        return fontConfig;
    }

    protected void setFontConfiguration() {
        fontConfig = this;
    }

    private static void sanityCheck() {
        int n;
        int n2 = 0;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        });
        for (n = 1; n < table_filenames.length; ++n) {
            if (table_filenames[n] != -1) continue;
            System.out.println("\n Warning: <filename." + FontConfiguration.getString(table_componentFontNameIDs[n]) + "> entry is missing!!!");
            if (string.contains("Linux") || string.contains("BSD") || string.contains("Darwin")) continue;
            ++n2;
        }
        for (n = 0; n < table_scriptIDs.length; ++n) {
            short s = table_scriptFonts[n];
            if (s == 0) {
                System.out.println("\n Error: <allfonts." + FontConfiguration.getString(table_scriptIDs[n]) + "> entry is missing!!!");
                ++n2;
                continue;
            }
            if (s >= 0) continue;
            s = -s;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int n3 = i * 4 + j;
                    short s2 = table_scriptFonts[s + n3];
                    if (s2 != 0) continue;
                    System.out.println("\n Error: <" + FontConfiguration.getFontName(i) + "." + FontConfiguration.getStyleName(j) + "." + FontConfiguration.getString(table_scriptIDs[n]) + "> entry is missing!!!");
                    ++n2;
                }
            }
        }
        if ("SunOS".equals(string)) {
            for (n = 0; n < table_awtfontpaths.length; ++n) {
                String string2;
                if (table_awtfontpaths[n] != 0 || (string2 = FontConfiguration.getString(table_scriptIDs[n])).contains("lucida") || string2.contains("dingbats") || string2.contains("symbol")) continue;
                System.out.println("\nError: <awtfontpath." + string2 + "> entry is missing!!!");
                ++n2;
            }
        }
        if (n2 != 0) {
            System.out.println("!!THERE ARE " + n2 + " ERROR(S) IN " + "THE FONTCONFIG FILE, PLEASE CHECK ITS CONTENT!!\n");
            System.exit(1);
        }
    }

    private static void dump() {
        int n;
        short s;
        int n2;
        System.out.println("\n----Head Table------------");
        for (n2 = 0; n2 < 20; ++n2) {
            System.out.println("  " + n2 + " : " + head[n2]);
        }
        System.out.println("\n----scriptIDs-------------");
        FontConfiguration.printTable(table_scriptIDs, 0);
        System.out.println("\n----scriptFonts----------------");
        for (n2 = 0; n2 < table_scriptIDs.length; ++n2) {
            s = table_scriptFonts[n2];
            if (s < 0) continue;
            System.out.println("  allfonts." + FontConfiguration.getString(table_scriptIDs[n2]) + "=" + FontConfiguration.getString(table_componentFontNameIDs[s]));
        }
        for (n2 = 0; n2 < table_scriptIDs.length; ++n2) {
            s = table_scriptFonts[n2];
            if (s >= 0) continue;
            s = -s;
            for (n = 0; n < 5; ++n) {
                for (int i = 0; i < 4; ++i) {
                    int n3 = n * 4 + i;
                    short s2 = table_scriptFonts[s + n3];
                    System.out.println("  " + FontConfiguration.getFontName(n) + "." + FontConfiguration.getStyleName(i) + "." + FontConfiguration.getString(table_scriptIDs[n2]) + "=" + FontConfiguration.getString(table_componentFontNameIDs[s2]));
                }
            }
        }
        System.out.println("\n----elcIDs----------------");
        FontConfiguration.printTable(table_elcIDs, 0);
        System.out.println("\n----sequences-------------");
        for (n2 = 0; n2 < table_elcIDs.length; ++n2) {
            System.out.println("  " + n2 + "/" + FontConfiguration.getString(table_elcIDs[n2]));
            short[] sArray = FontConfiguration.getShortArray(table_sequences[n2 * 5 + 0]);
            for (n = 0; n < sArray.length; ++n) {
                System.out.println("     " + FontConfiguration.getString(table_scriptIDs[sArray[n]]));
            }
        }
        System.out.println("\n----fontfileNameIDs-------");
        FontConfiguration.printTable(table_fontfileNameIDs, 0);
        System.out.println("\n----componentFontNameIDs--");
        FontConfiguration.printTable(table_componentFontNameIDs, 1);
        System.out.println("\n----filenames-------------");
        for (n2 = 0; n2 < table_filenames.length; ++n2) {
            if (table_filenames[n2] == -1) {
                System.out.println("  " + n2 + " : null");
                continue;
            }
            System.out.println("  " + n2 + " : " + FontConfiguration.getString(table_fontfileNameIDs[table_filenames[n2]]));
        }
        System.out.println("\n----awtfontpaths---------");
        for (n2 = 0; n2 < table_awtfontpaths.length; ++n2) {
            System.out.println("  " + FontConfiguration.getString(table_scriptIDs[n2]) + " : " + FontConfiguration.getString(table_awtfontpaths[n2]));
        }
        System.out.println("\n----proportionals--------");
        for (n2 = 0; n2 < table_proportionals.length; ++n2) {
            System.out.println("  " + FontConfiguration.getString(table_componentFontNameIDs[table_proportionals[n2++]]) + " -> " + FontConfiguration.getString(table_componentFontNameIDs[table_proportionals[n2]]));
        }
        n2 = 0;
        System.out.println("\n----alphabeticSuffix----");
        while (n2 < table_alphabeticSuffix.length) {
            System.out.println("    " + FontConfiguration.getString(table_elcIDs[table_alphabeticSuffix[n2++]]) + " -> " + FontConfiguration.getString(table_alphabeticSuffix[n2++]));
        }
        System.out.println("\n----String Table---------");
        System.out.println("    stringID:    Num =" + table_stringIDs.length);
        System.out.println("    stringTable: Size=" + table_stringTable.length * 2);
        System.out.println("\n----fallbackScriptIDs---");
        short[] sArray = FontConfiguration.getShortArray(head[15]);
        for (n = 0; n < sArray.length; ++n) {
            System.out.println("  " + FontConfiguration.getString(table_scriptIDs[sArray[n]]));
        }
        System.out.println("\n----appendedfontpath-----");
        System.out.println("  " + FontConfiguration.getString(head[16]));
        System.out.println("\n----Version--------------");
        System.out.println("  " + FontConfiguration.getString(head[17]));
    }

    protected static short getComponentFontID(short s, int n, int n2) {
        short s2 = table_scriptFonts[s];
        if (s2 >= 0) {
            return s2;
        }
        return table_scriptFonts[-s2 + n * 4 + n2];
    }

    protected static short getComponentFontIDMotif(short s, int n, int n2) {
        if (table_scriptFontsMotif.length == 0) {
            return 0;
        }
        short s2 = table_scriptFontsMotif[s];
        if (s2 >= 0) {
            return s2;
        }
        return table_scriptFontsMotif[-s2 + n * 4 + n2];
    }

    private static int[] getExclusionRanges(short s) {
        short s2 = table_exclusions[s];
        if (s2 == 0) {
            return EMPTY_INT_ARRAY;
        }
        char[] cArray = FontConfiguration.getString(s2).toCharArray();
        int[] nArray = new int[cArray.length / 2];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (cArray[n++] << 16) + (cArray[n++] & 0xFFFF);
        }
        return nArray;
    }

    private static boolean contains(short[] sArray, short s, int n) {
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != s) continue;
            return true;
        }
        return false;
    }

    protected static String getComponentFontName(short s) {
        if (s < 0) {
            return null;
        }
        return FontConfiguration.getString(table_componentFontNameIDs[s]);
    }

    private static String getComponentFileName(short s) {
        if (s < 0) {
            return null;
        }
        return FontConfiguration.getString(table_fontfileNameIDs[s]);
    }

    private static short getComponentFileID(short s) {
        return table_filenames[s];
    }

    private static String getScriptName(short s) {
        return FontConfiguration.getString(table_scriptIDs[s]);
    }

    protected short[] getCoreScripts(int n) {
        short s = this.getInitELC();
        short[] sArray = FontConfiguration.getShortArray(table_sequences[s * 5 + n]);
        if (this.preferLocaleFonts) {
            int n2;
            if (this.reorderScripts == null) {
                this.reorderScripts = new HashMap();
            }
            String[] stringArray = new String[sArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray[n2] = FontConfiguration.getScriptName(sArray[n2]);
                this.reorderScripts.put(stringArray[n2], sArray[n2]);
            }
            this.reorderSequenceForLocale(stringArray);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                sArray[n2] = this.reorderScripts.get(stringArray[n2]);
            }
        }
        return sArray;
    }

    private static short[] getFallbackScripts() {
        return FontConfiguration.getShortArray(head[15]);
    }

    private static void printTable(short[] sArray, int n) {
        for (int i = n; i < sArray.length; ++i) {
            System.out.println("  " + i + " : " + FontConfiguration.getString(sArray[i]));
        }
    }

    private static short[] readShortTable(DataInputStream dataInputStream, int n) throws IOException {
        if (n == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[n];
        byte[] byArray = new byte[n * 2];
        dataInputStream.read(byArray);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            sArray[n2++] = (short)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
        }
        return sArray;
    }

    private static void writeShortTable(DataOutputStream dataOutputStream, short[] sArray) throws IOException {
        for (int i = 0; i < sArray.length; ++i) {
            dataOutputStream.writeShort(sArray[i]);
        }
    }

    private static short[] toList(HashMap hashMap) {
        short[] sArray = new short[hashMap.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = -1;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            sArray[((Short)entry.getValue()).shortValue()] = FontConfiguration.getStringID((String)entry.getKey());
        }
        return sArray;
    }

    protected static String getString(short s) {
        if (s == 0) {
            return null;
        }
        if (stringCache[s] == null) {
            FontConfiguration.stringCache[s] = new String(table_stringTable, (int)table_stringIDs[s], table_stringIDs[s + 1] - table_stringIDs[s]);
        }
        return stringCache[s];
    }

    private static short[] getShortArray(short s) {
        String string = FontConfiguration.getString(s);
        char[] cArray = string.toCharArray();
        short[] sArray = new short[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            sArray[i] = (short)(cArray[i] & 0xFFFF);
        }
        return sArray;
    }

    private static short getStringID(String string) {
        if (string == null) {
            return 0;
        }
        short s = (short)stringTable.length();
        stringTable.append(string);
        short s2 = (short)stringTable.length();
        FontConfiguration.stringIDs[FontConfiguration.stringIDNum] = s;
        FontConfiguration.stringIDs[FontConfiguration.stringIDNum + 1] = s2;
        stringIDNum = (short)(stringIDNum + 1);
        if (stringIDNum + 1 >= stringIDs.length) {
            short[] sArray = new short[stringIDNum + 1000];
            System.arraycopy(stringIDs, 0, sArray, 0, stringIDNum);
            stringIDs = sArray;
        }
        return (short)(stringIDNum - 1);
    }

    private static short getShortArrayID(short[] sArray) {
        char[] cArray = new char[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            cArray[i] = (char)sArray[i];
        }
        String string = new String(cArray);
        return FontConfiguration.getStringID(string);
    }

    static /* synthetic */ short[] access$002(short[] sArray) {
        head = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$102(short[] sArray) {
        table_scriptIDs = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$302(short[] sArray) {
        table_scriptFonts = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$402(short[] sArray) {
        table_elcIDs = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$502(short[] sArray) {
        table_sequences = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$602(short[] sArray) {
        table_fontfileNameIDs = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$702(short[] sArray) {
        table_componentFontNameIDs = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$802(short[] sArray) {
        table_filenames = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$902(short[] sArray) {
        table_exclusions = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$1102(short[] sArray) {
        table_proportionals = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$1202(short[] sArray) {
        table_scriptFontsMotif = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$1402(short[] sArray) {
        table_alphabeticSuffix = sArray;
        return sArray;
    }

    static /* synthetic */ short[] access$1602(short[] sArray) {
        table_stringIDs = sArray;
        return sArray;
    }

    static /* synthetic */ char[] access$1902(char[] cArray) {
        table_stringTable = cArray;
        return cArray;
    }

    static /* synthetic */ String[] access$2102(String[] stringArray) {
        stringCache = stringArray;
        return stringArray;
    }

    static {
        startupLocale = null;
        localeMap = null;
        isProperties = true;
        fontNames = new String[]{"serif", "sansserif", "monospaced", "dialog", "dialoginput"};
        publicFontNames = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
        styleNames = new String[]{"plain", "bold", "italic", "bolditalic"};
        installedFallbackFontFiles = null;
        EMPTY_INT_ARRAY = new int[0];
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_SHORT_ARRAY = new short[0];
    }

    static class PropertiesHandler {
        private HashMap<String, Short> scriptIDs;
        private HashMap<String, Short> elcIDs;
        private HashMap<String, Short> componentFontNameIDs;
        private HashMap<String, Short> fontfileNameIDs;
        private HashMap<String, Integer> logicalFontIDs;
        private HashMap<String, Integer> fontStyleIDs;
        private HashMap<Short, Short> filenames;
        private HashMap<Short, short[]> sequences;
        private HashMap<Short, Short[]> scriptFonts;
        private HashMap<Short, Short> scriptAllfonts;
        private HashMap<Short, int[]> exclusions;
        private HashMap<Short, Short> awtfontpaths;
        private HashMap<Short, Short> proportionals;
        private HashMap<Short, Short> scriptAllfontsMotif;
        private HashMap<Short, Short[]> scriptFontsMotif;
        private HashMap<Short, Short> alphabeticSuffix;
        private short[] fallbackScriptIDs;
        private String version;
        private String appendedfontpath;

        PropertiesHandler() {
        }

        public void load(InputStream inputStream) throws IOException {
            this.initLogicalNameStyle();
            this.initHashMaps();
            FontProperties fontProperties = new FontProperties();
            fontProperties.load(inputStream);
            this.initBinaryTable();
        }

        private void initBinaryTable() {
            int n;
            FontConfiguration.access$002(new short[20]);
            head[0] = 20;
            FontConfiguration.access$102(FontConfiguration.toList(this.scriptIDs));
            head[1] = (short)(head[0] + table_scriptIDs.length);
            int n2 = table_scriptIDs.length + this.scriptFonts.size() * 20;
            FontConfiguration.access$302(new short[n2]);
            for (Map.Entry<Short, Short> entry : this.scriptAllfonts.entrySet()) {
                table_scriptFonts[entry.getKey().intValue()] = entry.getValue();
            }
            int n3 = table_scriptIDs.length;
            for (Map.Entry<Short, Short> entry : this.scriptFonts.entrySet()) {
                table_scriptFonts[entry.getKey().intValue()] = (short)(-n3);
                Short[] entry2 = (Short[])entry.getValue();
                for (int i = 0; i < 20; ++i) {
                    table_scriptFonts[n3++] = entry2[i] != null ? entry2[i] : (short)0;
                }
            }
            head[2] = (short)(head[1] + table_scriptFonts.length);
            FontConfiguration.access$402(FontConfiguration.toList(this.elcIDs));
            head[3] = (short)(head[2] + table_elcIDs.length);
            FontConfiguration.access$502(new short[this.elcIDs.size() * 5]);
            for (Map.Entry<Short, Short> entry : this.sequences.entrySet()) {
                int n4 = entry.getKey().intValue();
                short[] sArray = (short[])entry.getValue();
                if (sArray.length == 1) {
                    for (n = 0; n < 5; ++n) {
                        table_sequences[n4 * 5 + n] = sArray[0];
                    }
                    continue;
                }
                for (n = 0; n < 5; ++n) {
                    table_sequences[n4 * 5 + n] = sArray[n];
                }
            }
            head[4] = (short)(head[3] + table_sequences.length);
            FontConfiguration.access$602(FontConfiguration.toList(this.fontfileNameIDs));
            head[5] = (short)(head[4] + table_fontfileNameIDs.length);
            FontConfiguration.access$702(FontConfiguration.toList(this.componentFontNameIDs));
            head[6] = (short)(head[5] + table_componentFontNameIDs.length);
            FontConfiguration.access$802(new short[table_componentFontNameIDs.length]);
            boolean entry = false;
            while (entry < table_filenames.length) {
                table_filenames[entry] = -1;
                ++entry;
            }
            for (Map.Entry<Short, Short> n5 : this.filenames.entrySet()) {
                table_filenames[n5.getKey().shortValue()] = n5.getValue();
            }
            head[7] = (short)(head[6] + table_filenames.length);
            table_awtfontpaths = new short[table_scriptIDs.length];
            for (Map.Entry<Short, Short> entry3 : this.awtfontpaths.entrySet()) {
                FontConfiguration.table_awtfontpaths[entry3.getKey().shortValue()] = entry3.getValue();
            }
            head[8] = (short)(head[7] + table_awtfontpaths.length);
            FontConfiguration.access$902(new short[this.scriptIDs.size()]);
            for (Map.Entry<Short, Short> entry4 : this.exclusions.entrySet()) {
                int[] nArray = (int[])entry4.getValue();
                char[] cArray = new char[nArray.length * 2];
                n = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    cArray[n++] = (char)(nArray[i] >> 16);
                    cArray[n++] = (char)(nArray[i] & 0xFFFF);
                }
                table_exclusions[entry4.getKey().shortValue()] = FontConfiguration.getStringID(new String(cArray));
            }
            head[9] = (short)(head[8] + table_exclusions.length);
            FontConfiguration.access$1102(new short[this.proportionals.size() * 2]);
            Iterator<Map.Entry<Short, Short>> iterator = this.proportionals.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry<Short, Short> entry5 = iterator.next();
                table_proportionals[var4_14++] = entry5.getKey();
                table_proportionals[var4_14++] = entry5.getValue();
            }
            head[10] = (short)(head[9] + table_proportionals.length);
            if (this.scriptAllfontsMotif.size() != 0 || this.scriptFontsMotif.size() != 0) {
                n2 = table_scriptIDs.length + this.scriptFontsMotif.size() * 20;
                FontConfiguration.access$1202(new short[n2]);
                for (Map.Entry<Short, Short> entry6 : this.scriptAllfontsMotif.entrySet()) {
                    table_scriptFontsMotif[entry6.getKey().intValue()] = entry6.getValue();
                }
                n3 = table_scriptIDs.length;
                for (Map.Entry<Short, Short> entry7 : this.scriptFontsMotif.entrySet()) {
                    table_scriptFontsMotif[entry7.getKey().intValue()] = (short)(-n3);
                    Short[] shortArray = (Short[])entry7.getValue();
                    for (n = 0; n < 20; ++n) {
                        table_scriptFontsMotif[n3++] = shortArray[n] != null ? shortArray[n] : (short)0;
                    }
                }
            } else {
                FontConfiguration.access$1202(EMPTY_SHORT_ARRAY);
            }
            head[11] = (short)(head[10] + table_scriptFontsMotif.length);
            FontConfiguration.access$1402(new short[this.alphabeticSuffix.size() * 2]);
            iterator = this.alphabeticSuffix.entrySet().iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                Map.Entry<Short, Short> entry8 = iterator.next();
                table_alphabeticSuffix[var4_16++] = entry8.getKey();
                table_alphabeticSuffix[var4_16++] = entry8.getValue();
            }
            head[15] = FontConfiguration.getShortArrayID(this.fallbackScriptIDs);
            head[16] = FontConfiguration.getStringID(this.appendedfontpath);
            head[17] = FontConfiguration.getStringID(this.version);
            head[12] = (short)(head[11] + table_alphabeticSuffix.length);
            FontConfiguration.access$1602(new short[stringIDNum + 1]);
            System.arraycopy(stringIDs, 0, table_stringIDs, 0, stringIDNum + 1);
            head[13] = (short)(head[12] + stringIDNum + 1);
            FontConfiguration.access$1902(stringTable.toString().toCharArray());
            head[14] = (short)(head[13] + stringTable.length());
            FontConfiguration.access$2102(new String[table_stringIDs.length]);
        }

        private void initLogicalNameStyle() {
            this.logicalFontIDs = new HashMap();
            this.fontStyleIDs = new HashMap();
            this.logicalFontIDs.put("serif", 0);
            this.logicalFontIDs.put("sansserif", 1);
            this.logicalFontIDs.put("monospaced", 2);
            this.logicalFontIDs.put("dialog", 3);
            this.logicalFontIDs.put("dialoginput", 4);
            this.fontStyleIDs.put("plain", 0);
            this.fontStyleIDs.put("bold", 1);
            this.fontStyleIDs.put("italic", 2);
            this.fontStyleIDs.put("bolditalic", 3);
        }

        private void initHashMaps() {
            this.scriptIDs = new HashMap();
            this.elcIDs = new HashMap();
            this.componentFontNameIDs = new HashMap();
            this.componentFontNameIDs.put("", (short)0);
            this.fontfileNameIDs = new HashMap();
            this.filenames = new HashMap();
            this.sequences = new HashMap();
            this.scriptFonts = new HashMap();
            this.scriptAllfonts = new HashMap();
            this.exclusions = new HashMap();
            this.awtfontpaths = new HashMap();
            this.proportionals = new HashMap();
            this.scriptFontsMotif = new HashMap();
            this.scriptAllfontsMotif = new HashMap();
            this.alphabeticSuffix = new HashMap();
            this.fallbackScriptIDs = EMPTY_SHORT_ARRAY;
        }

        private int[] parseExclusions(String string, String string2) {
            if (string2 == null) {
                return EMPTY_INT_ARRAY;
            }
            int n = 1;
            int n2 = 0;
            while ((n2 = string2.indexOf(44, n2)) != -1) {
                ++n;
                ++n2;
            }
            int[] nArray = new int[n * 2];
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n * 2) {
                int n5 = 0;
                int n6 = 0;
                try {
                    n3 = string2.indexOf(45, n2);
                    String string3 = string2.substring(n2, n3);
                    n2 = n3 + 1;
                    n3 = string2.indexOf(44, n2);
                    if (n3 == -1) {
                        n3 = string2.length();
                    }
                    String string4 = string2.substring(n2, n3);
                    n2 = n3 + 1;
                    int n7 = string3.length();
                    int n8 = string4.length();
                    if (n7 != 4 && n7 != 6 || n8 != 4 && n8 != 6) {
                        throw new Exception();
                    }
                    n5 = Integer.parseInt(string3, 16);
                    if (n5 > (n6 = Integer.parseInt(string4, 16))) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    if (SunGraphicsEnvironment.debugFonts && logger != null) {
                        logger.config("Failed parsing " + string + " property of font configuration.");
                    }
                    return EMPTY_INT_ARRAY;
                }
                nArray[n4++] = n5;
                nArray[n4++] = n6;
            }
            return nArray;
        }

        private Short getID(HashMap<String, Short> hashMap, String string) {
            Short s = hashMap.get(string);
            if (s == null) {
                hashMap.put(string, (short)hashMap.size());
                return hashMap.get(string);
            }
            return s;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseProperty(String string, String string2) {
            short s;
            short[] sArray;
            String[] stringArray;
            boolean bl;
            boolean bl2;
            if (string.startsWith("filename.")) {
                if (!"MingLiU_HKSCS".equals(string = string.substring(9))) {
                    string = string.replace('_', ' ');
                }
                Short s2 = this.getID(this.componentFontNameIDs, string);
                Short s3 = this.getID(this.fontfileNameIDs, string2);
                this.filenames.put(s2, s3);
                return;
            }
            if (string.startsWith("exclusion.")) {
                string = string.substring(10);
                this.exclusions.put(this.getID(this.scriptIDs, string), this.parseExclusions(string, string2));
                return;
            }
            if (string.startsWith("sequence.")) {
                string = string.substring(9);
                bl2 = false;
                bl = false;
                stringArray = FontConfiguration.splitSequence(string2).toArray(EMPTY_STRING_ARRAY);
                sArray = new short[stringArray.length];
            } else {
                if (string.startsWith("allfonts.")) {
                    if ((string = string.substring(9)).endsWith(".motif")) {
                        string = string.substring(0, string.length() - 6);
                        this.scriptAllfontsMotif.put(this.getID(this.scriptIDs, string), this.getID(this.componentFontNameIDs, string2));
                        return;
                    }
                    this.scriptAllfonts.put(this.getID(this.scriptIDs, string), this.getID(this.componentFontNameIDs, string2));
                    return;
                }
                if (string.startsWith("awtfontpath.")) {
                    string = string.substring(12);
                    this.awtfontpaths.put(this.getID(this.scriptIDs, string), FontConfiguration.getStringID(string2));
                    return;
                }
                if ("version".equals(string)) {
                    this.version = string2;
                    return;
                }
                if ("appendedfontpath".equals(string)) {
                    this.appendedfontpath = string2;
                    return;
                }
                if (string.startsWith("proportional.")) {
                    string = string.substring(13).replace('_', ' ');
                    this.proportionals.put(this.getID(this.componentFontNameIDs, string), this.getID(this.componentFontNameIDs, string2));
                    return;
                }
                boolean bl3 = false;
                int n = string.indexOf(46);
                if (n == -1) {
                    if (logger == null) return;
                    logger.config("Failed parsing " + string + " property of font configuration.");
                    return;
                }
                int n2 = string.indexOf(46, n + 1);
                if (n2 == -1) {
                    if (logger == null) return;
                    logger.config("Failed parsing " + string + " property of font configuration.");
                    return;
                }
                if (string.endsWith(".motif")) {
                    string = string.substring(0, string.length() - 6);
                    bl3 = true;
                }
                Integer n3 = this.logicalFontIDs.get(string.substring(0, n));
                Integer n4 = this.fontStyleIDs.get(string.substring(n + 1, n2));
                Short s4 = this.getID(this.scriptIDs, string.substring(n2 + 1));
                if (n3 == null || n4 == null) {
                    if (logger == null) return;
                    logger.config("unrecognizable logicfont name/style at " + string);
                    return;
                }
                Short[] shortArray = bl3 ? this.scriptFontsMotif.get(s4) : this.scriptFonts.get(s4);
                if (shortArray == null) {
                    shortArray = new Short[20];
                }
                shortArray[n3.intValue() * 4 + n4.intValue()] = this.getID(this.componentFontNameIDs, string2);
                if (bl3) {
                    this.scriptFontsMotif.put(s4, shortArray);
                    return;
                }
                this.scriptFonts.put(s4, shortArray);
                return;
            }
            for (s = 0; s < stringArray.length; ++s) {
                if ("alphabetic/default".equals(stringArray[s])) {
                    stringArray[s] = "alphabetic";
                    bl2 = true;
                } else if ("alphabetic/1252".equals(stringArray[s])) {
                    stringArray[s] = "alphabetic";
                    bl = true;
                }
                sArray[s] = this.getID(this.scriptIDs, stringArray[s]);
            }
            s = FontConfiguration.getShortArrayID(sArray);
            Short s5 = null;
            int n = string.indexOf(46);
            if (n == -1) {
                if ("fallback".equals(string)) {
                    this.fallbackScriptIDs = sArray;
                    return;
                }
                if (!"allfonts".equals(string)) {
                    if (logger == null) return;
                    logger.config("Error sequence def: <sequence." + string + ">");
                    return;
                }
                s5 = this.getID(this.elcIDs, "NULL.NULL.NULL");
            } else {
                s5 = this.getID(this.elcIDs, string.substring(n + 1));
                string = string.substring(0, n);
            }
            short[] sArray2 = null;
            if ("allfonts".equals(string)) {
                sArray2 = new short[]{s};
            } else {
                Integer n5;
                sArray2 = this.sequences.get(s5);
                if (sArray2 == null) {
                    sArray2 = new short[5];
                }
                if ((n5 = this.logicalFontIDs.get(string)) == null) {
                    if (logger == null) return;
                    logger.config("Unrecognizable logicfont name " + string);
                    return;
                }
                sArray2[n5.intValue()] = s;
            }
            this.sequences.put(s5, sArray2);
            if (bl2) {
                this.alphabeticSuffix.put(s5, FontConfiguration.getStringID("default"));
                return;
            }
            if (!bl) return;
            this.alphabeticSuffix.put(s5, FontConfiguration.getStringID("1252"));
        }

        class FontProperties
        extends Properties {
            FontProperties() {
            }

            @Override
            public synchronized Object put(Object object, Object object2) {
                PropertiesHandler.this.parseProperty((String)object, (String)object2);
                return null;
            }
        }
    }
}

