/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class StandardInvocationCompiler
implements InvocationCompiler {
    protected BaseBodyCompiler methodCompiler;
    protected SkinnyMethodAdapter method;

    public StandardInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        this.methodCompiler = methodCompiler;
        this.method = method2;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    public void invokeAttrAssignMasgn(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        int temp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(temp);
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.VARIABLE);
        this.methodCompiler.invokeUtilityMethod("selectAttrAsgnCallSite", CodegenUtils.sig(CallSite.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class));
        String signature = null;
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
        } else {
            switch (argsCallback.getArity()) {
                case 1: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                default: {
                    argsCallback.call(this.methodCompiler);
                    signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject[].class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                }
            }
        }
        this.methodCompiler.getVariableCompiler().getTempLocal(temp);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.invokeUtilityMethod("doAttrAsgn", signature);
    }

    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.VARIABLE);
        this.methodCompiler.invokeUtilityMethod("selectAttrAsgnCallSite", CodegenUtils.sig(CallSite.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class));
        String signature = null;
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class);
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, IRubyObject.class, CallSite.class, IRubyObject[].class, ThreadContext.class, IRubyObject.class);
            }
        }
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.invokeUtilityMethod("doAttrAsgn", signature);
    }

    public void opElementAsgnWithOr(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifne(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithAnd(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifeq(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithMethod(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback, String operator) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operator, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
            }
        }
    }

    public void invokeBinaryFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.ldc(fixnum);
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Long.TYPE));
        String callSiteMethod = "call";
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        if (RubyInstanceConfig.INLINE_DYNCALL_ENABLED && closureArg == null && (callType == CallType.FUNCTIONAL || callType == CallType.VARIABLE)) {
            if (argsCallback == null) {
                this.invokeDynamicSelfNoBlockZero(name2);
                return;
            }
            if (argsCallback.getArity() >= 1 && argsCallback.getArity() <= 3) {
                this.invokeDynamicSelfNoBlockSpecificArity(name2, argsCallback);
                return;
            }
        }
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, callType);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (callType == CallType.SUPER && closureArg == null) {
            closureArg = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.methodCompiler.loadBlock();
                }
            };
        }
        String callSiteMethod = "call";
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeDynamicSelfNoBlockZero(String name2) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    }

    public void invokeDynamicSelfNoBlockSpecificArity(String name2, ArgumentsCallback argsCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        argsCallback.call(this.methodCompiler);
        switch (argsCallback.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
            }
        }
    }

    public void invokeDynamicNoBlockZero(String name2, CompilerCallback receiverCallback) {
        receiverCallback.call(this.methodCompiler);
        int recv2 = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(recv2);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2, recv2);
        this.methodCompiler.loadThreadContext();
        this.method.aload(recv2);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    }

    public void invokeDynamicNoBlockSpecificArity(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        int recv2 = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(recv2);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2, recv2);
        this.methodCompiler.loadThreadContext();
        this.method.aload(recv2);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        argsCallback.call(this.methodCompiler);
        switch (argsCallback.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
            }
        }
    }

    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne(isTrue);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isTrue);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isFalse = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifeq(isFalse);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isFalse);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithMethod(String operatorName, String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void invokeOpElementAsgnWithMethod(String operatorName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void yield(CompilerCallback argsCallback, boolean unwrap) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Boolean.TYPE);
        } else {
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Boolean.TYPE);
        }
        this.method.ldc(unwrap);
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yield", signature);
    }

    public void yieldSpecific(ArgumentsCallback argsCallback) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class);
        } else {
            argsCallback.call(this.methodCompiler);
            switch (argsCallback.getArity()) {
                case 1: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                default: {
                    throw new NotCompilableException("Can't do specific-arity call for > 3 args yet");
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldSpecific", signature);
    }

    public void invokeEqq(ArgumentsCallback receivers, CompilerCallback argument) {
        if (argument == null) {
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject[].class));
                    break;
                }
            }
        } else {
            this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "===", CallType.NORMAL);
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.loadSelf();
            argument.call(this.methodCompiler);
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                }
            }
        }
    }
}

