/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.load.Library;

public class LateLoadingLibrary
implements Library {
    private final String libraryName;
    private final String className;
    private ClassLoader classLoader;

    public LateLoadingLibrary(String libraryName, String className, ClassLoader classLoader) {
        this.libraryName = libraryName;
        this.className = className;
        this.classLoader = classLoader;
    }

    public synchronized void load(Ruby runtime2, boolean wrap2) throws IOException {
        try {
            if (this.classLoader == null && Ruby.isSecurityRestricted()) {
                this.classLoader = runtime2.getInstanceConfig().getLoader();
            }
            Library library2 = (Library)this.classLoader.loadClass(this.className).newInstance();
            library2.load(runtime2, wrap2);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Throwable e) {
            if (runtime2.getDebug().isTrue()) {
                e.printStackTrace();
            }
            throw runtime2.newLoadError("library `" + this.libraryName + "' could not be loaded: " + e);
        }
    }
}

