/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.dyn.CallSite;
import org.jruby.RubyClass;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.objectweb.asm.MethodVisitor;

public class InvokeDynamicSupport {
    public static Object bootstrap(CallSite site, Object ... args2) {
        throw new RuntimeException("Unsupported method signature for dynamic call: " + site.type());
    }

    public static void installBytecode(MethodVisitor method2, String classname) {
    }

    private static boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || InvokeDynamicSupport.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    private static boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, self.getMetaClass(), name2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, arg2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, arg2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2) {
        IRubyObject self = (IRubyObject)selfObj;
        return method2.call(context, self, (RubyModule)self.getMetaClass(), name2, args2);
    }

    public static IRubyObject invokeDynamic(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            return method2.call(context, self, (RubyModule)selfType, name2, args2, block);
        }
        catch (JumpException.BreakJump bj) {
            return InvokeDynamicSupport.handleBreakJump(context, bj);
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
    }

    public static IRubyObject invokeDynamicIter(DynamicMethod method2, Object selfObj, ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        IRubyObject self = (IRubyObject)selfObj;
        RubyClass selfType = InvokeDynamicSupport.pollAndGetClass(context, self);
        try {
            IRubyObject iRubyObject = method2.call(context, self, (RubyModule)selfType, name2, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw InvokeDynamicSupport.retryJumpError(context);
        }
        finally {
            block.escape();
        }
    }

    private static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = self.getMetaClass();
        return selfType;
    }

    private static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    private static RaiseException retryJumpError(ThreadContext context) {
        return context.getRuntime().newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.getRuntime().getNil(), "retry outside of rescue not supported");
    }
}

