/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.extensions;

import junit.extensions.RepeatedTest;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class RepeatedTestTest
extends TestCase {
    private TestSuite fSuite = new TestSuite();

    public RepeatedTestTest(String name) {
        super(name);
        this.fSuite.addTest(new SuccessTest());
        this.fSuite.addTest(new SuccessTest());
    }

    public void testRepeatedOnce() {
        RepeatedTest test = new RepeatedTest(this.fSuite, 1);
        RepeatedTestTest.assertEquals(2, test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        RepeatedTestTest.assertEquals(2, result.runCount());
    }

    public void testRepeatedMoreThanOnce() {
        RepeatedTest test = new RepeatedTest(this.fSuite, 3);
        RepeatedTestTest.assertEquals(6, test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        RepeatedTestTest.assertEquals(6, result.runCount());
    }

    public void testRepeatedZero() {
        RepeatedTest test = new RepeatedTest(this.fSuite, 0);
        RepeatedTestTest.assertEquals(0, test.countTestCases());
        TestResult result = new TestResult();
        test.run(result);
        RepeatedTestTest.assertEquals(0, result.runCount());
    }

    public void testRepeatedNegative() {
        try {
            new RepeatedTest(this.fSuite, -1);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        RepeatedTestTest.fail("Should throw an IllegalArgumentException");
    }

    public static class SuccessTest
    extends TestCase {
        public void runTest() {
        }
    }
}

