/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.VMDirectByteBuffer;

final class DoubleViewBufferImpl
extends DoubleBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    public final double get() {
        int n = this.position();
        double d = ByteBufferHelper.getDouble(this.bb, (n << 3) + this.offset, this.endian);
        this.position(n + 1);
        return d;
    }

    public final double get(int n) {
        return ByteBufferHelper.getDouble(this.bb, (n << 3) + this.offset, this.endian);
    }

    public final DoubleBuffer put(double d) {
        int n = this.position();
        ByteBufferHelper.putDouble(this.bb, (n << 3) + this.offset, d, this.endian);
        this.position(n + 1);
        return this;
    }

    public final DoubleBuffer put(int n, double d) {
        ByteBufferHelper.putDouble(this.bb, (n << 3) + this.offset, d, this.endian);
        return this;
    }

    public final DoubleBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 8 * this.position(), 8 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final DoubleBuffer slice() {
        return new DoubleViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    final DoubleBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new DoubleViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public final DoubleBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public final DoubleBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isDirect() {
        return this.bb.isDirect();
    }

    public final ByteOrder order() {
        return this.endian;
    }

    DoubleViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, this.offset);
        }
    }

    public DoubleViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, n);
        }
    }
}

