/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class MappingTableElementImpl
extends MappingMemberElementImpl
implements MappingTableElement {
    private ArrayList _key;
    private transient ArrayList _keyObjects;
    private ArrayList _referencingKeys;
    private String _table;
    private transient TableElement _tableObject;

    public MappingTableElementImpl() {
        this((String)null, null);
    }

    public MappingTableElementImpl(String name, MappingClassElement declaringClass) {
        super(name, declaringClass);
    }

    public MappingTableElementImpl(TableElement table, MappingClassElement declaringClass) throws ModelException {
        this(table.toString(), declaringClass);
        this._table = this.getName();
    }

    public String getTable() {
        return this._table;
    }

    public void setTable(TableElement table) throws ModelException {
        String old = this.getTable();
        String newName = table.toString();
        try {
            this.fireVetoableChange("table", old, newName);
            this._table = newName;
            this.firePropertyChange("table", old, newName);
            this.setName(this._table);
            this._tableObject = null;
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public void setName(String name) throws ModelException {
        super.setName(name);
        if (this.getTable() == null) {
            this._table = name;
        }
    }

    public boolean isEqual(TableElement table) {
        return table != null ? this.getTable().equals(table.toString()) : false;
    }

    public ArrayList getKey() {
        if (this._key == null) {
            this._key = new ArrayList();
        }
        return this._key;
    }

    public void addKeyColumn(ColumnElement column) throws ModelException {
        if (column != null) {
            String columnName = NameUtil.getRelativeMemberName((String)column.getName().getFullName());
            if (!this.getKey().contains(columnName)) {
                this.addKeyColumnInternal(column);
            }
        } else {
            throw new ModelException(I18NHelper.getMessage(MappingTableElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    protected void addKeyColumnInternal(ColumnElement column) throws ModelException {
        ArrayList key = this.getKey();
        String columnName = NameUtil.getRelativeMemberName((String)column.getName().getFullName());
        try {
            this.fireVetoableChange("keyColumns", null, null);
            key.add(columnName);
            this.firePropertyChange("keyColumns", null, null);
            this._keyObjects = null;
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public void removeKeyColumn(String columnName) throws ModelException {
        if (columnName != null) {
            try {
                this.fireVetoableChange("keyColumns", null, null);
                if (!this.getKey().remove(columnName)) {
                    throw new ModelException(I18NHelper.getMessage(MappingTableElementImpl.getMessages(), "mapping.element.element_not_removed", columnName));
                }
                this.firePropertyChange("keyColumns", null, null);
                this._keyObjects = null;
            }
            catch (PropertyVetoException e) {
                throw new ModelVetoException(e);
            }
        }
    }

    public ArrayList getReferencingKeys() {
        if (this._referencingKeys == null) {
            this._referencingKeys = new ArrayList();
        }
        return this._referencingKeys;
    }

    public void addReferencingKey(MappingReferenceKeyElement referencingKey) throws ModelException {
        try {
            this.fireVetoableChange("referencingKeys", null, null);
            this.getReferencingKeys().add(referencingKey);
            this.firePropertyChange("referencingKeys", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public void removeReference(MappingTableElement table) throws ModelException {
        if (table != null) {
            Iterator keyIterator = this.getReferencingKeys().iterator();
            while (keyIterator.hasNext()) {
                MappingReferenceKeyElement nextKey = (MappingReferenceKeyElement)keyIterator.next();
                if (!nextKey.getTable().equals(table)) continue;
                try {
                    this.fireVetoableChange("referencingKeys", null, null);
                    keyIterator.remove();
                    this.firePropertyChange("referencingKeys", null, null);
                }
                catch (PropertyVetoException e) {
                    throw new ModelVetoException(e);
                }
            }
        } else {
            throw new ModelException(I18NHelper.getMessage(MappingTableElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    public TableElement getTableObject() {
        if (this._tableObject == null) {
            String absoluteTableName = NameUtil.getAbsoluteTableName((String)this.getDeclaringClass().getDatabaseRoot(), (String)this._table);
            this._tableObject = TableElement.forName((String)absoluteTableName);
        }
        return this._tableObject;
    }

    public ArrayList getKeyObjects() {
        if (this._keyObjects == null) {
            this._keyObjects = MappingClassElementImpl.toColumnObjects(this.getDeclaringClass().getDatabaseRoot(), this.getKey());
        }
        return this._keyObjects;
    }

    public void setTable(String table) {
        this._table = table;
    }

    public void setKey(ArrayList key) {
        this._key = key;
    }

    public void setReferencingKeys(ArrayList referencingKeys) {
        this._referencingKeys = referencingKeys;
    }

    protected void stripSchemaName() {
        Iterator<String> i;
        this._name = NameUtil.getRelativeTableName((String)this._name);
        this._table = NameUtil.getRelativeTableName((String)this._table);
        if (this._referencingKeys != null) {
            i = this._referencingKeys.iterator();
            while (i.hasNext()) {
                MappingReferenceKeyElementImpl refKey = (MappingReferenceKeyElementImpl)i.next();
                refKey.stripSchemaName();
            }
        }
        if (this._key != null) {
            i = this._key.listIterator();
            while (i.hasNext()) {
                i.set(NameUtil.getRelativeMemberName((String)((String)i.next())));
            }
        }
    }
}

