/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship;

import com.sun.jdo.api.persistence.mapping.core.FieldHolderState;
import com.sun.jdo.api.persistence.mapping.core.MappingStrategy;
import com.sun.jdo.api.persistence.mapping.core.RelationshipState;
import com.sun.jdo.api.persistence.mapping.core.TableState;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.modules.persistence.mapping.core.ui.IFieldMappingEditor;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.MappingContextWizard;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.MapJoinToForeignKeyStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.MapLocalToForeignKeyStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.MapLocalToJoinKeyStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelatedClassStep;
import com.sun.jdo.modules.persistence.mapping.core.ui.wizard.relationship.RelationshipMappingStep;
import com.sun.jdo.modules.persistence.mapping.core.util.MappingContext;
import com.sun.jdo.modules.persistence.mapping.core.util.Util;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.awt.Component;
import java.text.MessageFormat;
import org.netbeans.modules.dbschema.TableElement;
import org.openide.WizardDescriptor;
import org.openide.util.UserCancelException;

public class RelationshipMappingWizard
extends MappingContextWizard
implements IFieldMappingEditor {
    private RelatedClassStep relatedClassPanel;
    private MapLocalToForeignKeyStep mapToKeyPanel;
    private MapLocalToJoinKeyStep mapToKeyLocalToJoinPanel;
    private MapJoinToForeignKeyStep mapToKeyJoinToForeignPanel;
    private WizardDescriptor.Panel[] linkDirectlyWizardPanels;
    private WizardDescriptor.Panel[] linkWithJoinWizardPanels;
    private String[] linkDirectlySteps;
    private String[] linkWithJoinSteps;
    private FieldHolderState fieldHolderState;
    private RelationshipState relationshipState;
    private RelationshipElement relationshipElement;
    private String wizardTitle = null;

    public RelationshipMappingWizard(MappingContext mappingContext) {
        super(null, new Object(), mappingContext);
        this.linkDirectlySteps = new String[]{mappingContext.getString("RMW_Initial_Setup_Step"), mappingContext.getString("RMW_Map_To_Key_Step")};
        this.linkWithJoinSteps = new String[]{this.linkDirectlySteps[0], mappingContext.getString("RMW_Map_To_Key_Local_To_Join_Step"), mappingContext.getString("RMW_Map_To_Key_Join_To_Foreign_Step")};
        this.createPanels();
    }

    private void createPanels() {
        this.relatedClassPanel = new RelatedClassStep(this);
        this.mapToKeyPanel = new MapLocalToForeignKeyStep(this);
        this.mapToKeyLocalToJoinPanel = new MapLocalToJoinKeyStep(this);
        this.mapToKeyJoinToForeignPanel = new MapJoinToForeignKeyStep(this);
        this.linkDirectlyWizardPanels = new WizardDescriptor.Panel[2];
        this.linkWithJoinWizardPanels = new WizardDescriptor.Panel[3];
        this.linkDirectlyWizardPanels[0] = this.relatedClassPanel;
        this.linkDirectlyWizardPanels[1] = this.mapToKeyPanel;
        this.linkWithJoinWizardPanels[0] = this.relatedClassPanel;
        this.linkWithJoinWizardPanels[1] = this.mapToKeyLocalToJoinPanel;
        this.linkWithJoinWizardPanels[2] = this.mapToKeyJoinToForeignPanel;
        this.updateSteps();
    }

    public void setStateObject(FieldHolderState state, PersistenceFieldElement field) {
        RelationshipState fieldState;
        if (field == null || field instanceof RelationshipElement) {
            this.fieldHolderState = state;
            this.relationshipElement = (RelationshipElement)field;
            this.setTitle();
            String relatedClass = this.fieldHolderState.getCurrentRelatedClass(this.relationshipElement);
            this.clearTables();
            fieldState = this.fieldHolderState.getCurrentStateForField(this.relationshipElement);
            if (fieldState != null && !fieldState.getColumnPairState().hasCompleteRows()) {
                this.replaceStateObject(false);
                this.populateFirst();
                return;
            }
            if (fieldState == null && (fieldState = RelationshipState.getDefaultStateForField(this.fieldHolderState, this.relationshipElement)) == null && relatedClass != null) {
                this.fieldHolderState.addFieldMapping(this.relationshipElement, relatedClass);
                fieldState = this.fieldHolderState.getCurrentStateForField(this.relationshipElement);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.replaceDataObject(fieldState);
        this.populateFirst();
    }

    private void populateFirst() {
        RelationshipMappingStep thisPanel = (RelationshipMappingStep)this.current();
        thisPanel.fireChange();
        thisPanel.setNeedsPopulate(true);
        thisPanel.readSettings(null);
    }

    protected void replaceStateObject(boolean useCheckbox) {
        this.replaceStateObject(true, useCheckbox);
    }

    protected void replaceStateObject(boolean search, boolean useCheckbox) {
        boolean useJoin = this.relatedClassPanel.isLinkWithJoin();
        TableElement joinTable = this.mapToKeyLocalToJoinPanel.getJoinTable();
        RelationshipState state = null;
        this.clearTables();
        if (search) {
            state = this.fieldHolderState.addDefaultStateForField(this.relationshipElement, joinTable, useJoin, useCheckbox);
        }
        if (state == null || state != null && !state.getColumnPairState().hasCompleteRows()) {
            if (this.getRelatedPrimaryTable() != null) {
                String relatedClass = this.fieldHolderState.getCurrentRelatedClass(this.relationshipElement);
                this.fieldHolderState.addFieldMapping(this.relationshipElement, relatedClass);
                state = this.fieldHolderState.getCurrentStateForField(this.relationshipElement);
                state.setJoinRelationship(useJoin);
                if (useJoin) {
                    state.setJoinTable(joinTable);
                }
            } else {
                state = null;
            }
        }
        this.replaceDataObject(state);
    }

    private void clearTables() {
        if (this.mapToKeyPanel != null) {
            this.mapToKeyPanel.clearTable();
        }
        if (this.mapToKeyLocalToJoinPanel != null) {
            this.mapToKeyLocalToJoinPanel.clearTable();
        }
        if (this.mapToKeyJoinToForeignPanel != null) {
            this.mapToKeyJoinToForeignPanel.clearTable();
        }
    }

    protected TableElement getRelatedPrimaryTable() {
        if (this.fieldHolderState == null) {
            return null;
        }
        String relatedClass = this.fieldHolderState.getCurrentRelatedClass(this.relationshipElement);
        if (relatedClass == null) {
            return null;
        }
        TableState relatedState = this.fieldHolderState.getTableState(relatedClass);
        return relatedState != null ? relatedState.getCurrentPrimaryTable() : null;
    }

    public void setLinkDirectly() {
        if (this.getPanels() != this.linkDirectlyWizardPanels) {
            this.updatePanels(this.linkDirectlyWizardPanels);
            this.replaceStateObject(true);
        }
    }

    public void setLinkWithJoin() {
        if (this.getPanels() != this.linkWithJoinWizardPanels) {
            this.updatePanels(this.linkWithJoinWizardPanels);
            this.replaceStateObject(true);
        }
    }

    private void setPanelsToPopulate() {
        WizardDescriptor.Panel current = this.current();
        WizardDescriptor.Panel[] myPanels = this.getPanels();
        int count = this.getNumberOfPanels();
        for (int i = 0; i < count; ++i) {
            WizardDescriptor.Panel thisPanel = myPanels[i];
            if (thisPanel.equals(current)) continue;
            ((RelationshipMappingStep)thisPanel).setNeedsPopulate(true);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        RelationshipElement inverse = this.fieldHolderState.getCurrentRelatedField(this.relationshipElement);
        if (this.fieldHolderState.getCurrentStateForField(this.relationshipElement) == null) {
            this.fieldHolderState.replaceFieldState(this.relationshipElement, this.relationshipState);
        }
        if (inverse != null) {
            FieldHolderState relatedFieldState = this.fieldHolderState.getRelatedState(this.relationshipElement, false);
            if (relatedFieldState != null && relatedFieldState.getCurrentStateForField(inverse) == null) {
                relatedFieldState.addFieldMapping(inverse, this.fieldHolderState.getMappingClassElement().getName());
            }
            this.fieldHolderState.setupInverseMapping(this.relationshipElement);
        }
        return this.fieldHolderState;
    }

    public static FieldHolderState launchWindow(FieldHolderState lState, RelationshipElement lRelationshipField, MappingContext mappingContext) throws UserCancelException {
        if (lState != null && lRelationshipField != null) {
            RelationshipMappingWizard lRelationshipPanel = new RelationshipMappingWizard(mappingContext);
            Logger logger = mappingContext.getLogger();
            Object ret = null;
            logger.finest("mapping.module.state.before_state", lState != null ? lState.getDebugInfo() : "null");
            lRelationshipPanel.setStateObject((FieldHolderState)lState.clone(), lRelationshipField);
            ret = lRelationshipPanel.executeWizard();
            if (ret == WizardDescriptor.FINISH_OPTION) {
                try {
                    FieldHolderState lNewState = (FieldHolderState)lRelationshipPanel.getPropertyValue();
                    MappingStrategy strategy = new MappingStrategy(mappingContext.getBrandedBundle("com.sun.jdo.api.persistence.mapping.core.Bundle"));
                    logger.finest("mapping.module.state.after_state", lNewState != null ? lNewState.getDebugInfo() : "null");
                    if (Util.checkForWarning(strategy.prepareAttach(lState, lNewState))) {
                        RelationshipState relationshipState = lRelationshipPanel.getRelationshipState();
                        if (relationshipState != null) {
                            relationshipState.getColumnPairState().removeDuplicatePairs();
                            relationshipState.getAssociatedColumnPairState().removeDuplicatePairs();
                        }
                        return lNewState;
                    }
                }
                catch (IllegalStateException lError) {
                    lError.printStackTrace();
                }
            } else if (ret == WizardDescriptor.CANCEL_OPTION || ret == WizardDescriptor.CLOSED_OPTION) {
                throw new UserCancelException();
            }
        }
        return lState;
    }

    protected void addListenersToDescriptor(WizardDescriptor descriptor) {
        super.addListenersToDescriptor(this.getDescriptor());
        this.getDescriptor().setHelpCtx(this.getHelpCtx());
    }

    public FieldHolderState getFieldHolderState() {
        return this.fieldHolderState;
    }

    public void setFieldHolderState(FieldHolderState relFieldState) {
        this.fieldHolderState = relFieldState;
    }

    public RelationshipState getRelationshipState() {
        return this.relationshipState;
    }

    public void setRelationshipState(RelationshipState relFlMapSt) {
        this.relationshipState = relFlMapSt;
    }

    public RelationshipElement getRelationshipElement() {
        return this.relationshipElement;
    }

    public void setRelationshipElement(RelationshipElement relElement) {
        this.relationshipElement = relElement;
    }

    protected String getShortClassName() {
        return JavaTypeHelper.getShortClassName(this.relationshipElement.getDeclaringClass().getName());
    }

    protected String getShortRelatedClassName() {
        String relatedClass = this.fieldHolderState.getCurrentRelatedClass(this.relationshipElement);
        if (relatedClass != null) {
            return JavaTypeHelper.getShortClassName(relatedClass);
        }
        return this.getMappingContext().getString("VALUE_related_class");
    }

    protected String getRelatedFieldName() {
        String relatedField = this.fieldHolderState.getCurrentRelatedFieldName(this.relationshipElement);
        return relatedField != null ? relatedField : this.getMappingContext().getString("VALUE_none");
    }

    private void setTitle() {
        this.wizardTitle = this.getShortClassName() + '.' + this.relationshipElement.toString();
        this.getDescriptor().setTitle(MessageFormat.format(this.getMappingContext().getString("RMW_Title"), this.wizardTitle));
    }

    protected void fillDescriptor(WizardDescriptor descriptor) {
        WizardDescriptor wizardDescriptor = this.getDescriptor();
        if (wizardDescriptor != null) {
            wizardDescriptor.setOptions(this.getOptions());
            wizardDescriptor.setAdditionalOptions(this.getAdditionalOptions());
            wizardDescriptor.setClosingOptions(this.getClosingOptions());
            wizardDescriptor.setTitleFormat(new MessageFormat("{1}"));
            wizardDescriptor.setTitle(MessageFormat.format(this.getMappingContext().getString("RMW_Title"), this.wizardTitle));
        }
    }

    protected void fillStaticProperties(WizardDescriptor descriptor) {
        WizardDescriptor wizardDescriptor = this.getDescriptor();
        if (wizardDescriptor != null) {
            wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        }
    }

    public boolean isLinkWithJoin() {
        return this.relatedClassPanel.isLinkWithJoin();
    }

    protected void updateSteps() {
        WizardDescriptor.Panel[] newPanels = this.linkDirectlyWizardPanels;
        if (this.relationshipState != null && this.relationshipState.isJoinRelationship()) {
            newPanels = this.linkWithJoinWizardPanels;
        }
        this.updatePanels(newPanels);
    }

    protected void updatePanels(WizardDescriptor.Panel[] panels) {
        WizardDescriptor.Panel[] currentPanels = this.getPanels();
        if (panels != null && panels != currentPanels) {
            WizardDescriptor myDescriptor = this.getDescriptor();
            this.setPanels(panels);
            if (myDescriptor != null) {
                myDescriptor.putProperty("WizardPanel_contentData", (Object)(panels == this.linkDirectlyWizardPanels ? this.linkDirectlySteps : this.linkWithJoinSteps));
            }
        }
    }

    public Component getComponent() {
        return this.getDialog();
    }

    public TableElement getJoinTable() {
        return this.mapToKeyLocalToJoinPanel.getJoinTable();
    }

    protected void replaceDataObject(RelationshipState relFieldMapSt) {
        boolean changed = this.relationshipState != relFieldMapSt;
        this.relationshipState = relFieldMapSt;
        if (changed) {
            this.updateSteps();
        }
        this.setPanelsToPopulate();
    }
}

