/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SwingUtils {
    public static final void selectNearestRow(JList list, int row) {
        if (row >= list.getModel().getSize()) {
            row = list.getModel().getSize() - 1;
        }
        if (row >= 0) {
            list.setSelectedIndex(row);
        }
    }

    public static final void scrollSelectedToVisible(JList list) {
        int idx = list.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        if (idx > 0 && list.getVisibleRowCount() > 1) {
            --idx;
        }
        Point pt = list.indexToLocation(idx);
        list.scrollRectToVisible(new Rectangle(0, pt.y, 1, list.getPreferredScrollableViewportSize().height));
    }

    public static final void autosizeList(JList list, JScrollPane scrollPane) {
        Border b;
        ListModel model = list.getModel();
        int rowCount = model.getSize();
        int totalHeight = 0;
        int maxWidth = 0;
        ListCellRenderer renderer = list.getCellRenderer();
        for (int i = 0; i < rowCount; ++i) {
            Component c = renderer.getListCellRendererComponent(list, model.getElementAt(i), i, false, false);
            totalHeight += c.getPreferredSize().height;
            maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
        }
        Border border = b = scrollPane != null ? scrollPane.getViewportBorder() : null;
        if (b != null) {
            Insets ins = b.getBorderInsets(scrollPane);
            totalHeight += ins.top + ins.bottom;
            maxWidth += ins.right + ins.left;
        }
        list.setPreferredSize(new Dimension(maxWidth, totalHeight));
    }

    public static final void selectNearestRow(JTable table, int row) {
        if (row >= table.getRowCount()) {
            row = table.getRowCount() - 1;
        }
        if (row >= 0) {
            table.setRowSelectionInterval(row, row);
        }
    }

    public static final void scrollSelectedToVisible(JTable table) {
        int idx = table.getSelectedRow();
        if (idx < 0) {
            return;
        }
        Rectangle rec = table.getCellRect(idx, 0, true);
        table.scrollRectToVisible(new Rectangle(0, Math.max(rec.y - table.getRowHeight() - table.getRowMargin(), 0), 1, table.getPreferredScrollableViewportSize().height));
    }

    public static final void autosizeTable(JTable table) {
        Dimension dim = table.getPreferredSize();
        int rc = table.getRowCount();
        int rh = table.getRowHeight();
        int rm = Math.max(table.getRowMargin() - 1, 0);
        int h = rc * (rh + rm);
        table.setPreferredSize(new Dimension((int)dim.getWidth(), h));
    }

    public static final void autosizeTableColumnWidths(JTable table) {
        TableColumnModel model = table.getColumnModel();
        JLabel label = null;
        for (int i = 0; i < model.getColumnCount(); ++i) {
            Component comp;
            int columnWidth;
            TableColumn column = model.getColumn(i);
            Object header = column.getHeaderValue();
            TableCellRenderer renderer = column.getHeaderRenderer();
            int computedWidth = columnWidth = column.getPreferredWidth();
            if (renderer == null) {
                if (label == null) {
                    label = new JLabel();
                }
                label.setText(header != null ? header.toString() : "");
                comp = label;
            } else {
                comp = renderer.getTableCellRendererComponent(table, header, true, false, -1, i);
            }
            computedWidth = label.getPreferredSize().width;
            if (computedWidth <= columnWidth) continue;
            column.setPreferredWidth(computedWidth);
        }
    }

    public static final int getCurrentColumnIndex(JTable table, Object identifier) {
        return table.getColumnModel().getColumnIndex(table.getColumn(identifier));
    }

    public static final int getOriginalColumnIndex(JTable table, Object identifier) {
        return table.getColumn(identifier).getModelIndex();
    }

    public static void makeLightWeight(final JComboBox heavyComboBox) {
        heavyComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        heavyComboBox.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public final void run() {
                        heavyComboBox.setPopupVisible(false);
                    }
                });
            }
        });
    }

    public static void replaceItems(DefaultComboBoxModel comboModel, List items) {
        Iterator iterator = items.iterator();
        comboModel.removeAllElements();
        while (iterator.hasNext()) {
            comboModel.addElement(iterator.next());
        }
    }
}

