/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DummyModuleInfo;
import org.openide.modules.ModuleInfo;

class PatchChecker {
    private static final String JAR_EXTENSION = ".JAR";
    private static final String ZIP_EXTENSION = ".ZIP";
    private static ModuleInfo[] patchArray = null;

    private PatchChecker() {
    }

    static ModuleInfo[] getPatches() {
        if (patchArray == null) {
            List patchDirectories = Autoupdater.Support.getPatchDirectories();
            ArrayList patches = new ArrayList();
            if (!patchDirectories.isEmpty()) {
                Iterator it = patchDirectories.iterator();
                while (it.hasNext()) {
                    PatchChecker.addPatches((File)it.next(), patches);
                }
            }
            patchArray = new ModuleInfo[patches.size()];
            patches.toArray(patchArray);
        }
        return patchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPatches(File directory, Collection result) {
        File[] dirList = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(PatchChecker.JAR_EXTENSION) || name.toUpperCase().endsWith(PatchChecker.ZIP_EXTENSION);
            }
        });
        if (dirList == null) {
            return;
        }
        for (int i = 0; i < dirList.length; ++i) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(dirList[i]);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) continue;
                DummyModuleInfo md = new DummyModuleInfo(manifest.getMainAttributes());
                Iterator it = result.iterator();
                boolean found = false;
                while (it.hasNext()) {
                    ModuleInfo td = (ModuleInfo)it.next();
                    if (!md.getCodeNameBase().equals(td.getCodeNameBase())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(md);
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException ie) {}
            }
        }
    }
}

