/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tasklist.core.FilterTaskNode;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;

final class FilteredTaskChildren
extends FilterNode.Children {
    private static final Logger LOGGER = TLUtils.getLogger(FilteredTaskChildren.class);
    private Filter filter;
    private TaskListView view;

    public FilteredTaskChildren(TaskListView view, Node n, Filter filter) {
        super(n);
        this.filter = filter;
        this.view = view;
    }

    protected Node[] createNodes(Object key) {
        if (!(key instanceof Node)) {
            return new Node[0];
        }
        Node n = (Node)key;
        Task task = TaskNode.getTask(n);
        if (this.filter.accept(task)) {
            Object children = n.getChildren() == Children.LEAF ? Children.LEAF : new FilteredTaskChildren(this.view, n, this.filter);
            return new Node[]{new FilterTaskNode(n, (Children)children, false)};
        }
        if (this.hasMatch(task)) {
            Object children = n.getChildren() == Children.LEAF ? Children.LEAF : new FilteredTaskChildren(this.view, n, this.filter);
            return new Node[]{new FilterTaskNode(n, (Children)children, true)};
        }
        return new Node[0];
    }

    private boolean hasMatch(Task n) {
        if (this.filter.accept(n)) {
            return true;
        }
        Iterator it = n.subtasksIterator();
        while (it.hasNext()) {
            if (!this.hasMatch((Task)it.next())) continue;
            return true;
        }
        return false;
    }

    public void filterChildrenAdded(NodeMemberEvent ev) {
        super.filterChildrenAdded(ev);
        if (this.view != null) {
            this.view.updateFilterCount();
        }
    }

    public void filterChildrenRemoved(NodeMemberEvent ev) {
        super.filterChildrenRemoved(ev);
        if (this.view != null) {
            this.view.updateFilterCount();
        }
    }

    static {
        LOGGER.setLevel(Level.OFF);
    }
}

