/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.beaninfo.editors.ExtensionListEditor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;

public class ExtensionListCustomEditor
extends JPanel {
    ExtensionList value;
    ExtensionListEditor editor;
    static final long serialVersionUID = -4347656479280614636L;
    private JButton addButton;
    private JButton changeButton;
    private JTextField itemField;
    private JLabel itemLabel;
    private JList itemList;
    private JLabel itemListLabel;
    private JScrollPane itemListScroll;
    private JButton removeButton;

    private String[] getStrings() {
        ArrayList l = new ArrayList();
        if (this.value == null) {
            return new String[0];
        }
        Enumeration e = this.value.extensions();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        e = this.value.mimeTypes();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l.toArray(new String[l.size()]);
    }

    public ExtensionListCustomEditor(ExtensionListEditor ed) {
        this.editor = ed;
        this.value = (ExtensionList)((ExtensionList)this.editor.getValue()).clone();
        this.initComponents();
        this.itemList.setCellRenderer(new EmptyStringListCellRenderer());
        this.itemList.setSelectionMode(0);
        this.itemList.setListData(this.getStrings());
        ResourceBundle bundle = NbBundle.getBundle((Class)ExtensionListCustomEditor.class);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE"));
        this.itemField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Item"));
        this.itemList.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_ItemList"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Add"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Change"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ELCE_Remove"));
        if (!this.editor.isEditable()) {
            this.itemField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.updateButtons();
        this.itemField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                boolean containsCurrent = ExtensionListCustomEditor.this.containsCurrent();
                String txt = ExtensionListCustomEditor.this.itemField.getText().trim();
                boolean en = ExtensionListCustomEditor.this.itemField.isEnabled() && txt.length() > 0 && !containsCurrent;
                ExtensionListCustomEditor.this.addButton.setEnabled(en);
                ExtensionListCustomEditor.this.changeButton.setEnabled(en && ExtensionListCustomEditor.this.itemList.getSelectedIndex() != -1);
                if (containsCurrent) {
                    ExtensionListCustomEditor.this.itemList.setSelectedIndex(ExtensionListCustomEditor.this.idxOfCurrent());
                }
            }
        });
        this.itemField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ExtensionListCustomEditor.this.addButton.isEnabled()) {
                    ExtensionListCustomEditor.this.doAdd();
                }
            }
        });
        this.addButton.setEnabled(false);
        this.changeButton.setEnabled(false);
    }

    private boolean containsCurrent() {
        return this.idxOfCurrent() != -1;
    }

    private int idxOfCurrent() {
        String txt = this.itemField.getText().trim();
        if (txt.length() > 0) {
            int max = this.itemList.getModel().getSize();
            for (int i = 0; i < max; ++i) {
                if (!txt.equals(this.itemList.getModel().getElementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.removeButton = new JButton();
        this.itemListScroll = new JScrollPane();
        this.itemList = new JList();
        this.itemLabel = new JLabel();
        this.itemField = new JTextField();
        this.itemListLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage((Class)ExtensionListCustomEditor.class, (String)"CTL_ELCE_Add", (Object[])new Object[0]));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage((Class)ExtensionListCustomEditor.class, (String)"CTL_ELCE_Change", (Object[])new Object[0]));
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.changeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage((Class)ExtensionListCustomEditor.class, (String)"CTL_ELCE_Remove", (Object[])new Object[0]));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtensionListCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ExtensionListCustomEditor.this.itemListValueChanged(evt);
            }
        });
        this.itemListScroll.setViewportView(this.itemList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.itemListScroll, gridBagConstraints);
        this.itemLabel.setLabelFor(this.itemField);
        Mnemonics.setLocalizedText((JLabel)this.itemLabel, (String)NbBundle.getMessage((Class)ExtensionListCustomEditor.class, (String)"CTL_ELCE_Item", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 0, 8);
        this.add((Component)this.itemLabel, gridBagConstraints);
        this.itemField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.itemField, gridBagConstraints);
        this.itemListLabel.setLabelFor(this.itemList);
        Mnemonics.setLocalizedText((JLabel)this.itemListLabel, (String)NbBundle.getMessage((Class)ExtensionListCustomEditor.class, (String)"CTL_ItemList", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.itemListLabel, gridBagConstraints);
    }

    private String addTexts() {
        StringTokenizer st = new StringTokenizer(this.itemField.getText(), ",. \n\t");
        String last = null;
        while (st.hasMoreTokens()) {
            last = st.nextToken();
            if (last.indexOf(47) >= 0) {
                this.value.addMimeType(last);
                continue;
            }
            this.value.addExtension(last);
        }
        return last;
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        int sel = this.itemList.getSelectedIndex();
        String s = (String)this.itemList.getModel().getElementAt(sel);
        if (s.indexOf(47) >= 0) {
            this.value.removeMimeType(s);
        } else {
            this.value.removeExtension(s);
        }
        this.doAdd();
    }

    private int indexOf(String[] array, String item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int sel = this.itemList.getSelectedIndex();
        String s = (String)this.itemList.getModel().getElementAt(sel);
        if (s.indexOf(47) >= 0) {
            this.value.removeMimeType(s);
        } else {
            this.value.removeExtension(s);
        }
        this.itemList.setListData(this.getStrings());
        int count = this.itemList.getModel().getSize();
        if (count != 0) {
            if (sel >= count) {
                sel = count - 1;
            }
            this.itemList.setSelectedIndex(sel);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void itemListValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
        int sel = this.itemList.getSelectedIndex();
        if (sel != -1) {
            this.itemField.setText((String)this.itemList.getModel().getElementAt(sel));
            this.changeButton.setEnabled(false);
            this.addButton.setEnabled(false);
        }
    }

    private void doAdd() {
        String last = this.addTexts();
        String[] values = this.getStrings();
        int index = this.indexOf(values, last);
        this.itemList.setListData(values);
        if (index >= 0) {
            this.itemList.setSelectedIndex(index);
        }
        this.itemList.repaint();
        this.updateValue();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.doAdd();
    }

    private void updateButtons() {
        int sel = this.itemList.getSelectedIndex();
        if (sel == -1 || !this.editor.isEditable()) {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        }
    }

    private void updateValue() {
        this.editor.setValue(this.value);
    }

    static class EmptyStringListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected static Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        static final long serialVersionUID = 487512296465844339L;

        public EmptyStringListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof String)) {
                return this;
            }
            String text = (String)value;
            if ("".equals(text)) {
                text = NbBundle.getMessage((Class)(class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor == null ? (class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor = ExtensionListCustomEditor.class$("org.netbeans.beaninfo.editors.ExtensionListCustomEditor")) : class$org$netbeans$beaninfo$editors$ExtensionListCustomEditor), (String)"CTL_ELCE_Empty");
            }
            this.setText(text);
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

