/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.ui.ProductInformationPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public class AboutAction
extends CallableSystemAction {
    public AboutAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        Splash.showSplashDialog((Frame)WindowManager.getDefault().getMainWindow(), (JComponent)new ProductInformationPanel(), (JComponent)AboutAction.getLicenseComp());
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AboutAction.class);
    }

    public String getName() {
        return NbBundle.getMessage((Class)AboutAction.class, (String)"About");
    }

    static JComponent getLicenseComp() {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject licenseFolder = fs.findResource("About/Licenses");
        if (licenseFolder == null) {
            return null;
        }
        FileObject[] foArray = licenseFolder.getChildren();
        if (foArray.length <= 0) {
            return null;
        }
        boolean isSomeLicense = false;
        StringWriter sw = new StringWriter();
        for (int i = 0; i < foArray.length; ++i) {
            String curLicense = AboutAction.loadLicenseText(foArray[i]);
            if (curLicense != null) {
                sw.write(curLicense);
                isSomeLicense = true;
            }
            if (i >= foArray.length - 1) continue;
            sw.write("\n");
        }
        if (!isSomeLicense) {
            return null;
        }
        JTextArea ta = new JTextArea(sw.toString(), 4, 0);
        ta.setBorder(new EmptyBorder(5, 12, 0, 12));
        ta.setEditable(false);
        ta.setBackground(new Color(0, 27, 51));
        ta.setForeground(Color.WHITE);
        ta.setFont(ta.getFont().deriveFont(9.0f));
        ta.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(ta);
        sp.setBorder(null);
        return sp;
    }

    private static String loadLicenseText(FileObject fo) {
        InputStream is = null;
        try {
            is = fo.getInputStream();
        }
        catch (FileNotFoundException ex) {
            String msg = MessageFormat.format(NbBundle.getBundle((Class)AboutAction.class).getString("EXC_LicenseFileNotFound"), fo.getPath());
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)ex, msg);
            em.notify(1, (Throwable)ex);
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringWriter result = new StringWriter();
        try {
            int curChar;
            while ((curChar = in.read()) != -1) {
                result.write(curChar);
            }
        }
        catch (IOException ex) {
            String msg = MessageFormat.format(NbBundle.getBundle((Class)AboutAction.class).getString("EXC_LicenseReadBroken"), fo.getPath());
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)ex, msg);
            em.notify(1, (Throwable)ex);
            return null;
        }
        return result.toString();
    }
}

