/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.ui;

import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.registry.ui.TypeNodeData;
import org.netbeans.swing.outline.NodeRowModel;
import org.netbeans.swing.outline.OutlineModel;

public class TypeCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    Component lastComponent;
    JavaType type;

    public TypeCellEditor() {
        super(new JTextField());
        this.setClickCountToStart(1);
    }

    public void cancelCellEditing() {
    }

    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    public Object getCellEditorValue() {
        if (null == this.type) {
            return ((JTextField)this.lastComponent).getText();
        }
        if (this.lastComponent instanceof JTextField) {
            String valueString = ((JTextField)this.lastComponent).getText();
            Object value = this.createValue(valueString);
            return value;
        }
        if (this.lastComponent instanceof JComboBox) {
            return ((JComboBox)this.lastComponent).getSelectedItem();
        }
        return null;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        NodeRowModel rowModel = ((OutlineModel)table.getModel()).getRowNodeModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)rowModel.getNodeForRow(row);
        if (null == node.getUserObject()) {
            JTextField txtField = new JTextField();
            txtField.setText((String)value);
            this.lastComponent = txtField;
        } else {
            TypeNodeData data = (TypeNodeData)node.getUserObject();
            this.type = data.getParameterType();
            if (this.type instanceof JavaSimpleType) {
                if (this.type.getRealName().equalsIgnoreCase("boolean") || this.type.getRealName().equalsIgnoreCase("java.lang.Boolean")) {
                    JComboBox<Boolean> combo;
                    this.lastComponent = combo = new JComboBox<Boolean>();
                    combo.addItem(new Boolean(true));
                    combo.addItem(new Boolean(false));
                    Object parameterValue = data.getParameterValue();
                    combo.setSelectedItem(parameterValue);
                    combo.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            TypeCellEditor.this.comboActionPerformed(evt);
                        }
                    });
                } else {
                    JTextField txtField = new JTextField();
                    txtField.setText(value != null ? value.toString() : "");
                    this.lastComponent = txtField;
                }
            } else if (this.type instanceof JavaEnumerationType) {
                JComboBox<String> combo;
                this.lastComponent = combo = new JComboBox<String>();
                JavaEnumerationType enumType = (JavaEnumerationType)this.type;
                Iterator iterator = enumType.getEntries();
                while (iterator.hasNext()) {
                    JavaEnumerationEntry entry = (JavaEnumerationEntry)iterator.next();
                    combo.addItem(entry.getLiteralValue());
                }
                Object parameterValue = data.getParameterValue();
                combo.setSelectedItem(parameterValue);
            }
        }
        return this.lastComponent;
    }

    private void comboActionPerformed(ActionEvent evt) {
        JComboBox combo = (JComboBox)evt.getSource();
        this.fireEditingStopped();
    }

    private Object createValue(String inValue) {
        Object returnValue = null;
        String currentType = this.type.getRealName();
        if (currentType.equalsIgnoreCase("int") || currentType.equalsIgnoreCase("java.lang.Integer")) {
            try {
                returnValue = new Integer(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Integer(0);
            }
        } else if (currentType.equalsIgnoreCase("byte") || currentType.equalsIgnoreCase("java.lang.Byte")) {
            try {
                returnValue = new Byte(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Byte(" ");
            }
        } else if (currentType.equalsIgnoreCase("boolean") || currentType.equalsIgnoreCase("java.lang.Boolean")) {
            try {
                returnValue = new Boolean(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Boolean(false);
            }
        } else if (currentType.equalsIgnoreCase("float") || currentType.equalsIgnoreCase("java.lang.Float")) {
            try {
                returnValue = new Float(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Float(0.0f);
            }
        } else if (currentType.equalsIgnoreCase("double") || currentType.equalsIgnoreCase("java.lang.Double")) {
            try {
                returnValue = new Double(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Double(0.0);
            }
        } else if (currentType.equalsIgnoreCase("long") || currentType.equalsIgnoreCase("java.lang.Long")) {
            try {
                returnValue = new Long(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Long(0L);
            }
        } else if (currentType.equalsIgnoreCase("short") || currentType.equalsIgnoreCase("java.lang.Short")) {
            try {
                returnValue = new Short(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new Short(" ");
            }
        } else if (currentType.equalsIgnoreCase("java.lang.String")) {
            returnValue = inValue;
        } else if (currentType.equalsIgnoreCase("java.math.BigDecimal")) {
            try {
                returnValue = new BigDecimal(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new BigDecimal(0);
            }
        } else if (currentType.equalsIgnoreCase("java.math.BigInteger")) {
            try {
                returnValue = new BigInteger(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new BigInteger("0");
            }
        } else if (currentType.equalsIgnoreCase("java.net.URI")) {
            try {
                returnValue = new URI(inValue);
            }
            catch (URISyntaxException uri) {
                try {
                    returnValue = new URI("http://java.sun.com");
                }
                catch (URISyntaxException uri2) {}
            }
        } else if (currentType.equalsIgnoreCase("java.util.Calendar")) {
            try {
                Date date = DateFormat.getDateTimeInstance().parse(inValue);
                returnValue = Calendar.getInstance();
                ((Calendar)returnValue).setTime(date);
            }
            catch (ParseException ex) {
                returnValue = Calendar.getInstance();
            }
        } else if (currentType.equalsIgnoreCase("java.util.Date")) {
            try {
                returnValue = DateFormat.getInstance().parse(inValue);
            }
            catch (ParseException pe) {
                returnValue = new Date();
            }
        }
        return returnValue;
    }
}

