/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.navigation.InheritanceTreePanelUI;
import org.netbeans.modules.java.navigation.spi.DisplayProvider;
import org.netbeans.modules.java.navigation.spi.NavigatorTreeModel;
import org.openide.util.Utilities;

final class InheritanceTreeController
extends MouseAdapter
implements TreeExpansionListener {
    private InheritanceTreePanelUI panelUI;
    private JTree tree;

    public InheritanceTreeController(InheritanceTreePanelUI panelUI) {
        this.panelUI = panelUI;
        this.tree = panelUI.getContent();
        this.initActions();
        this.initListeners();
    }

    private void initActions() {
        OpenByKeyboardAction keyAction = new OpenByKeyboardAction();
        this.tree.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "open");
        this.tree.getActionMap().put("open", keyAction);
        ShowPopupAction showPopupAction = new ShowPopupAction();
        this.tree.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64, true), "popup");
        this.tree.getActionMap().put("popup", showPopupAction);
    }

    private void initListeners() {
        this.tree.addMouseListener(this);
        this.tree.addTreeExpansionListener(this);
    }

    private static void showPopup(JTree tree, Point p) {
        JPopupMenu m;
        DisplayProvider dp = (DisplayProvider)((Object)tree.getModel());
        TreePath path = tree.getPathForLocation(p.x, p.y);
        Object elem = null;
        if (path != null) {
            elem = path.getLastPathComponent();
            tree.scrollRectToVisible(tree.getPathBounds(path));
        }
        if ((m = InheritanceTreeController.createPopupMenuForItem(tree, dp, elem)) != null) {
            m.show(tree, p.x, p.y);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Action act;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Point p = e.getPoint();
        Object clicked = null;
        TreePath path = this.tree.getPathForLocation(p.x, p.y);
        if (path == null) {
            return;
        }
        clicked = path.getLastPathComponent();
        DisplayProvider dp = (DisplayProvider)((Object)this.tree.getModel());
        if ((dp.isDefaultActionInstant() || e.getClickCount() > 1) && (act = dp.getDefaultAction(clicked)) != null && act.isEnabled()) {
            ActionEvent ae = new ActionEvent(this, 1001, "click");
            act.actionPerformed(ae);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            InheritanceTreeController.showPopup((JTree)e.getSource(), e.getPoint());
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            InheritanceTreeController.showPopup((JTree)e.getSource(), e.getPoint());
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        NavigatorTreeModel tr = (NavigatorTreeModel)this.tree.getModel();
        tr.notifyExpandedState(e.getPath(), false);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        NavigatorTreeModel tr = (NavigatorTreeModel)this.tree.getModel();
        tr.notifyExpandedState(e.getPath(), true);
    }

    static JPopupMenu createPopupMenuForItem(Component comp, DisplayProvider dp, Object elem) {
        Action[] allActions;
        Action def = dp.getDefaultAction(elem);
        Action[] other = dp.getActions(elem);
        int actionCount = (other == null ? 0 : other.length) + (def == null ? 0 : 1);
        if (actionCount == 0) {
            return null;
        }
        if (def != null) {
            allActions = new Action[actionCount];
            allActions[0] = def;
            if (other != null) {
                System.arraycopy(other, 0, allActions, 1, other.length);
            }
        } else {
            allActions = other;
        }
        return Utilities.actionsToPopup((Action[])allActions, (Component)comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runWithWaitCursor(JComponent curComp, Action a, ActionEvent evt) {
        Cursor old = curComp.getCursor();
        curComp.setCursor(Cursor.getPredefinedCursor(3));
        try {
            a.actionPerformed(evt);
        }
        finally {
            curComp.setCursor(old);
        }
    }

    private final class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            TreePath path = InheritanceTreeController.this.tree.getSelectionPath();
            if (path != null) {
                Rectangle r = InheritanceTreeController.this.tree.getPathBounds(path);
                Point p = new Point(r.x + 10, r.y + r.height - 3);
                InheritanceTreeController.showPopup(InheritanceTreeController.this.tree, p);
            }
        }
    }

    private class OpenByKeyboardAction
    extends AbstractAction {
        private OpenByKeyboardAction() {
        }

        public boolean isEnabled() {
            return this.findDefaultAction() != null;
        }

        private Action findDefaultAction() {
            Action a;
            Object sel;
            JTree tree = InheritanceTreeController.this.tree;
            TreePath path = tree.getSelectionPath();
            Object object = sel = path == null ? null : path.getLastPathComponent();
            if (sel != null && (a = ((DisplayProvider)((Object)tree.getModel())).getDefaultAction(sel)) != null && a.isEnabled()) {
                return a;
            }
            return null;
        }

        public void actionPerformed(ActionEvent evt) {
            Action a = this.findDefaultAction();
            if (a != null) {
                InheritanceTreeController.runWithWaitCursor(InheritanceTreeController.this.tree, a, evt);
            }
        }
    }
}

