/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ServerFileDistributor
extends ServerProgress {
    ServerInstance instance;
    DeploymentTarget dtarget;
    IncrementalDeployment incremental;
    Iterator rootModuleFiles;
    Map childModuleFiles;
    Map childModuleMap;
    static Map j2eeTypeMap = null;

    public ServerFileDistributor(ServerInstance instance, DeploymentTarget dtarget) {
        super(instance);
        this.instance = instance;
        this.dtarget = dtarget;
        this.incremental = instance.getIncrementalDeployment();
        try {
            J2eeModule source = dtarget.getModule();
            this.rootModuleFiles = source.getArchiveContents();
            if (source instanceof J2eeModuleContainer) {
                this.childModuleFiles = new HashMap();
                this.childModuleMap = new HashMap();
                J2eeModule[] childModules = ((J2eeModuleContainer)source).getModules(null);
                for (int i = 0; i < childModules.length; ++i) {
                    Iterator contents = childModules[i].getArchiveContents();
                    if (contents != null) {
                        this.childModuleFiles.put(childModules[i].getUrl(), contents);
                    }
                    this.childModuleMap.put(childModules[i].getUrl(), childModules[i]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static List getDescriptorPath(J2eeModule module) {
        if (j2eeTypeMap == null) {
            j2eeTypeMap = new HashMap();
            j2eeTypeMap.put(J2eeModule.EJB, Arrays.asList("META-INF/ejb-jar.xml", "META-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.WAR, Arrays.asList("WEB-INF/web.xml", "WEB-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.CLIENT, Arrays.asList("META-INF/application-client.xml"));
            j2eeTypeMap.put(J2eeModule.CONN, Arrays.asList("META-INF/ra.xml"));
            j2eeTypeMap.put(J2eeModule.EAR, Arrays.asList("META-INF/application.xml"));
        }
        return (List)j2eeTypeMap.get(module.getModuleType());
    }

    private J2eeModule getJ2eeModule(TargetModuleID target) {
        if (target.getParentTargetModuleID() == null) {
            return this.dtarget.getModule();
        }
        String moduleUrl = this.incremental.getModuleUrl(target);
        return (J2eeModule)this.childModuleMap.get(moduleUrl);
    }

    private AppChanges createModuleChangeDescriptor(TargetModuleID target) {
        J2eeModule module = this.getJ2eeModule(target);
        List descriptorRelativePaths = ServerFileDistributor.getDescriptorPath(module);
        ModuleType moduleType = (ModuleType)module.getModuleType();
        List<String> serverDescriptorRelativePaths = Arrays.asList(this.instance.getServer().getDeploymentPlanFiles(moduleType));
        return new AppChanges(descriptorRelativePaths, serverDescriptorRelativePaths, (ModuleType)this.dtarget.getModule().getModuleType());
    }

    public AppChangeDescriptor distribute(TargetModule targetModule, ModuleChangeReporter mcr) throws IOException {
        long lastDeployTime = targetModule.getTimestamp();
        TargetModuleID[] childModules = targetModule.getChildTargetModuleID();
        AppChanges changes = new AppChanges();
        File destDir = null;
        for (int i = 0; childModules != null && i < childModules.length; ++i) {
            String url = this.incremental.getModuleUrl(targetModule.delegate());
            destDir = this.incremental.getDirectoryForModule(childModules[i]);
            Iterator source = (Iterator)this.childModuleFiles.get(url);
            if (destDir == null) {
                changes.record(this._distribute(childModules[i], lastDeployTime));
                continue;
            }
            changes.record(this._distribute(source, destDir, targetModule.delegate(), url, lastDeployTime));
        }
        destDir = this.incremental.getDirectoryForModule(targetModule.delegate());
        if (destDir == null) {
            changes.record(this._distribute(targetModule.delegate(), lastDeployTime));
        } else {
            changes.record(this._distribute(this.rootModuleFiles, destDir, targetModule.delegate(), null, lastDeployTime));
        }
        if (mcr != null) {
            changes.record(mcr, lastDeployTime);
        }
        this.setStatusDistributeCompleted(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_DoneIncrementalDeploy", (Object)targetModule.getModuleID()));
        return changes;
    }

    public AppChanges _test_distribute(Iterator source, File destDir, TargetModuleID target, long lastDeployTime) throws IOException {
        return this._distribute(source, destDir, target, null, lastDeployTime);
    }

    private AppChanges _distribute(TargetModuleID target, long lastDeployTime) throws IOException {
        AppChanges mc = this.createModuleChangeDescriptor(target);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        Iterator content = this.getJ2eeModule(target).getArchiveContents();
        Date lastDeployed = new Date(lastDeployTime);
        while (content.hasNext()) {
            J2eeModule.RootedEntry re = (J2eeModule.RootedEntry)content.next();
            FileObject file = re.getFileObject();
            if (file.isFolder()) continue;
            file.refresh();
            if (!file.lastModified().after(lastDeployed)) continue;
            String relativePath = re.getRelativePath();
            mc.record(relativePath);
        }
        return mc;
    }

    private AppChanges _distribute(Iterator source, File destDir, TargetModuleID target, String moduleUrl, long lastDeployTime) throws IOException {
        AppChanges appChanges;
        AppChanges mc = this.createModuleChangeDescriptor(target);
        if (source == null) {
            ErrorManager.getDefault().log(65536, "There is no contents for " + target);
            throw new IOException(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_NoContents", (Object)target));
        }
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        Object lock = null;
        try {
            Object sourceFO;
            File dir = this.incremental.getDirectoryForModule(target);
            destDir.mkdirs();
            File parent = destDir.getParentFile();
            FileObject destRoot = FileUtil.toFileObject((File)destDir);
            Enumeration destFiles = destRoot.getChildren(true);
            HashMap<String, FileObject> destMap = new HashMap<String, FileObject>();
            int rootPathLen = destRoot.getPath().length();
            while (destFiles.hasMoreElements()) {
                FileObject destFO = (FileObject)destFiles.nextElement();
                destMap.put(destFO.getPath().substring(rootPathLen + 1), destFO);
            }
            Iterator j = source;
            while (j.hasNext()) {
                FileObject destFolder;
                J2eeModule.RootedEntry entry = (J2eeModule.RootedEntry)j.next();
                String relativePath = entry.getRelativePath();
                sourceFO = entry.getFileObject();
                FileObject targetFO = (FileObject)destMap.get(relativePath);
                if (sourceFO.isFolder()) {
                    destMap.remove(relativePath);
                    continue;
                }
                if (targetFO == null) {
                    destFolder = ServerFileDistributor.findOrCreateParentFolder(destRoot, relativePath);
                } else {
                    destMap.remove(relativePath);
                    if (!sourceFO.lastModified().after(targetFO.lastModified())) continue;
                    destFolder = targetFO.getParent();
                    targetFO.delete();
                }
                mc.record(relativePath);
                FileUtil.copyFile((FileObject)sourceFO, (FileObject)destFolder, (String)sourceFO.getName());
            }
            ModuleType moduleType = (ModuleType)this.dtarget.getModule().getModuleType();
            String[] rPaths = this.instance.getServer().getDeploymentPlanFiles(moduleType);
            File configFile = this.dtarget.getConfigurationFile();
            if (rPaths == null || rPaths.length == 0) {
                sourceFO = mc;
                return sourceFO;
            }
            File[] paths = new File[rPaths.length];
            for (int n = 0; n < rPaths.length; ++n) {
                paths[n] = new File(FileUtil.toFile((FileObject)destRoot), rPaths[n]);
                if (paths[n].exists() && paths[n].lastModified() >= configFile.lastModified()) continue;
                mc.record(rPaths[n]);
            }
            appChanges = mc;
        }
        catch (Exception e) {
            String msg = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
            this.setStatusDistributeFailed(msg);
            throw new RuntimeException(e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.releaseLock();
                }
                catch (Exception ex) {}
            }
        }
        return appChanges;
    }

    public static FileObject findOrCreateParentFolder(FileObject dest, String relativePath) throws IOException {
        File parentRelativePath = new File(relativePath).getParentFile();
        if (parentRelativePath == null) {
            return dest;
        }
        FileObject folder = dest.getFileSystem().findResource(parentRelativePath.getPath());
        if (folder == null) {
            folder = FileUtil.createFolder((FileObject)dest, (String)parentRelativePath.getPath());
        }
        return folder;
    }

    private void setStatusDistributeRunning(String message) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeFailed(String message) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    static class AppChanges
    implements AppChangeDescriptor {
        boolean descriptorChanged = false;
        boolean serverDescriptorChanged = false;
        boolean classesChanged = false;
        boolean manifestChanged = false;
        boolean ejbsChanged = false;
        List changedEjbs = Collections.EMPTY_LIST;
        ModuleType moduleType = null;
        List changedFiles = new ArrayList();
        List descriptorRelativePaths;
        List serverDescriptorRelativePaths;

        AppChanges() {
        }

        AppChanges(List descriptorRelativePaths, List serverDescriptorRelativePaths, ModuleType moduleType) {
            this.descriptorRelativePaths = descriptorRelativePaths;
            this.serverDescriptorRelativePaths = serverDescriptorRelativePaths;
            this.moduleType = moduleType;
        }

        private void record(AppChanges changes) {
            List<String> ejbs;
            if (!this.descriptorChanged) {
                this.descriptorChanged = changes.descriptorChanged();
            }
            if (!this.serverDescriptorChanged) {
                this.serverDescriptorChanged = changes.serverDescriptorChanged();
            }
            if (!this.classesChanged) {
                this.classesChanged = changes.classesChanged();
            }
            if (!this.manifestChanged) {
                this.manifestChanged = changes.manifestChanged();
            }
            if (!this.ejbsChanged) {
                this.ejbsChanged = changes.ejbsChanged();
            }
            if ((ejbs = Arrays.asList(changes.getChangedEjbs())).size() > 0) {
                this.changedEjbs.addAll(ejbs);
            }
            this.changedFiles.addAll(changes.changedFiles);
        }

        private void record(String relativePath) {
            if (!this.classesChanged) {
                boolean libs;
                boolean classes = !this.moduleType.equals(ModuleType.WAR) || relativePath.startsWith("WEB-INF/classes/");
                boolean importantLib = !this.moduleType.equals(ModuleType.WAR) || relativePath.startsWith("WEB-INF/lib/");
                boolean bl = libs = importantLib && (relativePath.endsWith(".jar") || relativePath.endsWith(".zip"));
                if (classes || libs) {
                    this.classesChanged = true;
                    return;
                }
            }
            if (!this.descriptorChanged && (this.descriptorRelativePaths != null && this.descriptorRelativePaths.contains(relativePath) || relativePath.startsWith("WEB-INF") && (relativePath.endsWith(".tld") || relativePath.endsWith(".xml") || relativePath.endsWith(".dtd")))) {
                this.descriptorChanged = true;
                return;
            }
            if (!this.serverDescriptorChanged && this.serverDescriptorRelativePaths != null && this.serverDescriptorRelativePaths.contains(relativePath)) {
                this.serverDescriptorChanged = true;
                return;
            }
            this.changedFiles.add(new File(relativePath));
        }

        private void record(ModuleChangeReporter mcr, long since) {
            EjbChangeDescriptor ecd = mcr.getEjbChanges(since);
            this.ejbsChanged = ecd.ejbsChanged();
            String[] ejbs = ecd.getChangedEjbs();
            if (ejbs != null && ejbs.length > 0) {
                this.changedEjbs.addAll(Arrays.asList(ejbs));
            }
            if (!this.manifestChanged) {
                this.manifestChanged = mcr.isManifestChanged(since);
            }
        }

        public boolean classesChanged() {
            return this.classesChanged;
        }

        public boolean descriptorChanged() {
            return this.descriptorChanged;
        }

        public boolean manifestChanged() {
            return this.manifestChanged;
        }

        public boolean serverDescriptorChanged() {
            return this.serverDescriptorChanged;
        }

        public boolean ejbsChanged() {
            return this.ejbsChanged;
        }

        public String[] getChangedEjbs() {
            return this.changedEjbs.toArray(new String[0]);
        }

        public File[] getChangedFiles() {
            return this.changedFiles.toArray(new File[this.changedFiles.size()]);
        }
    }
}

