/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class J2eePlatformSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final Map cache = new HashMap();
    private final Map normalizedURLCache = new HashMap();

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = (SourceForBinaryQuery.Result)this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        boolean isNormalizedURL = J2eePlatformSourceForBinaryQuery.isNormalizedURL(binaryRoot);
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        ServerRegistry servReg = ServerRegistry.getInstance();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            ServerInstance serInst = servReg.getServerInstance(serverInstanceIDs[i]);
            J2eePlatformImpl platformImpl = serInst.getJ2eePlatformImpl();
            if (platformImpl == null) continue;
            LibraryImplementation[] libs = platformImpl.getLibraries();
            for (int j = 0; j < libs.length; ++j) {
                String type = libs[j].getType();
                List classes = libs[j].getContent("classpath");
                for (URL entry : classes) {
                    URL normalizedEntry = isNormalizedURL ? this.getNormalizedURL(entry) : entry;
                    if (normalizedEntry == null || !normalizedEntry.equals(binaryRoot)) continue;
                    res = new Result(entry, libs[j]);
                    this.cache.put(binaryRoot, res);
                    return res;
                }
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (J2eePlatformSourceForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = (URL)this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private LibraryImplementation lib;
        private URL entry;
        private ArrayList listeners;
        private FileObject[] cache;

        public Result(URL queryFor, LibraryImplementation aLib) {
            this.entry = queryFor;
            this.lib = aLib;
            this.lib.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    List src = this.lib.getContent("src");
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    Iterator sit = src.iterator();
                    while (sit.hasNext()) {
                        FileObject sourceRootURL = URLMapper.findFileObject((URL)((URL)sit.next()));
                        if (sourceRootURL == null) continue;
                        result.add(sourceRootURL);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator it = null;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }
}

