/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;
import org.netbeans.modules.project.uiapi.CategoryModel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CategoryView
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private ExplorerManager manager;
    private BeanTreeView btv;
    private CategoryModel categoryModel;

    public CategoryView(CategoryModel categoryModel) {
        this.categoryModel = categoryModel;
        this.manager = new ExplorerManager();
        this.setLayout(new BorderLayout());
        Dimension size = new Dimension(220, 4);
        this.btv = new BeanTreeView();
        this.btv.setSelectionMode(1);
        this.btv.setPopupAllowed(false);
        this.btv.setRootVisible(false);
        this.btv.setDefaultActionAllowed(false);
        this.btv.setMinimumSize(size);
        this.btv.setPreferredSize(size);
        this.btv.setMaximumSize(size);
        this.btv.setDragSource(false);
        this.add((Component)this.btv, "Center");
        this.manager.setRootContext(this.createRootNode(categoryModel));
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        categoryModel.addPropertyChangeListener(this);
        this.btv.expandAll();
        this.selectNode(categoryModel.getCurrentCategory());
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)CategoryView.class, (String)"AN_CatgoryView"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)CategoryView.class, (String)"AD_CategoryView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.btv.expandAll();
    }

    private void selectNode(ProjectCustomizer.Category category) {
        Node node = this.findNode(category, this.manager.getRootContext());
        if (node != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private Node findNode(ProjectCustomizer.Category category, Node node) {
        Node[] nodes;
        Children ch = node.getChildren();
        if (ch != null && ch != Children.LEAF && (nodes = ch.getNodes(true)) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                ProjectCustomizer.Category cc = (ProjectCustomizer.Category)nodes[i].getLookup().lookup(class$org$netbeans$spi$project$ui$support$ProjectCustomizer$Category == null ? CategoryView.class$("org.netbeans.spi.project.ui.support.ProjectCustomizer$Category") : class$org$netbeans$spi$project$ui$support$ProjectCustomizer$Category);
                if (cc == category) {
                    return nodes[i];
                }
                Node n = this.findNode(category, nodes[i]);
                if (n == null) continue;
                return n;
            }
        }
        return null;
    }

    private Node createRootNode(CategoryModel categoryModel) {
        ProjectCustomizer.Category rootCategory = ProjectCustomizer.Category.create("root", "root", null, categoryModel.getCategories());
        return new CategoryNode(rootCategory);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (source == this.manager && "selectedNodes".equals(propertyName)) {
            Node[] nodes = this.manager.getSelectedNodes();
            if (nodes == null || nodes.length <= 0) {
                return;
            }
            Node node = nodes[0];
            ProjectCustomizer.Category category = (ProjectCustomizer.Category)node.getLookup().lookup(ProjectCustomizer.Category.class);
            if (category != this.categoryModel.getCurrentCategory()) {
                this.categoryModel.setCurrentCategory(category);
            }
        }
        if (source == this.categoryModel && "propCurrentCategory".equals(propertyName)) {
            this.selectNode((ProjectCustomizer.Category)evt.getNewValue());
        }
    }

    private static class CategoryChildren
    extends Children.Keys {
        private Collection descriptions;

        public CategoryChildren(ProjectCustomizer.Category[] descriptions) {
            this.descriptions = Arrays.asList(descriptions);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new CategoryNode((ProjectCustomizer.Category)key)};
        }
    }

    private static class CategoryNode
    extends AbstractNode
    implements PropertyChangeListener {
        private Image icon = org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/project/uiapi/defaultCategory.gif");
        private ProjectCustomizer.Category category;

        public CategoryNode(ProjectCustomizer.Category category) {
            super((Children)(category.getSubcategories() == null || category.getSubcategories().length == 0 ? Children.LEAF : new CategoryChildren(category.getSubcategories())), Lookups.fixed((Object[])new Object[]{category}));
            this.setName(category.getName());
            this.category = category;
            this.setDisplayName(category.getDisplayName());
            if (category.getIcon() != null) {
                this.icon = category.getIcon();
            }
            Utilities.getCategoryChangeSupport(category).addPropertyChangeListener(this);
        }

        public String getHtmlDisplayName() {
            return this.category.isValid() ? null : "<html><font color=\"!nb.errorForeground\">" + this.category.getDisplayName() + "</font></html>";
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "isCategoryValid") {
                this.fireDisplayNameChange(null, null);
            }
        }
    }
}

