/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.xml.cookies.CheckXMLCookie;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataNode;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationSaver;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.SecondaryConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.Utils;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanTopComponent;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.xml.sax.InputSource;

public class ConfigDataObject
extends XMLDataObject
implements ConfigurationSaver,
FileChangeListener {
    public static final String SERVER_ID = "J2EE";
    private final File configKey;
    private HashSet secondaries = null;
    private boolean isEdited = false;
    private boolean isEditedChecked = false;
    private ValidateXMLCookie validateCookie = null;
    private CheckXMLCookie checkCookie = null;
    private XMLEditorSupport xmlEditorSupport = null;
    private XMLOpenSupport xmlOpenSupport = null;
    private boolean reloadDialogOpened;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport;

    public ConfigDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.configKey = FileUtil.toFile((FileObject)pf);
        pf.addFileChangeListener((FileChangeListener)WeakListeners.create((Class)FileChangeListener.class, (EventListener)((Object)this), (Object)pf));
        this.initCookies();
    }

    private void initCookies() {
        CookieSet.Factory factory = new CookieSet.Factory(){

            public Node.Cookie createCookie(Class klass) {
                return null;
            }
        };
        CookieSet cookies = this.getCookieSet();
        cookies.add(EditorCookie.class, factory);
        cookies.add(OpenCookie.class, factory);
        cookies.add(CloseCookie.class, factory);
        cookies.add(PrintCookie.class, factory);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getPrimaryFile().getName() + "_help");
    }

    public boolean isRenameAllowed() {
        return false;
    }

    protected Node createNodeDelegate() {
        return new ConfigDataNode(this);
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject newDo = super.handleCopy(f);
        try {
            FileObject primary = newDo.getPrimaryFile();
            newDo.setValid(false);
            newDo = DataObject.find((FileObject)primary);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return newDo;
    }

    public SunONEDeploymentConfiguration getDeploymentConfiguration() throws ConfigurationException {
        SunONEDeploymentConfiguration config = SunONEDeploymentConfiguration.getConfiguration(this.configKey);
        if (config == null) {
            FileObject configFO = FileUtil.toFileObject((File)this.configKey);
            ConfigurationSupport.requestCreateConfiguration((FileObject)configFO, (String)SERVER_ID);
            config = SunONEDeploymentConfiguration.getConfiguration(this.configKey);
            if (config == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unable to initialize DeploymentConfiguration for " + this.configKey.getPath() + " on server " + SERVER_ID));
            }
        }
        return config;
    }

    public boolean hasSecondaries() {
        return this.getSecondaries().size() > 0;
    }

    protected void addSecondary(SecondaryConfigDataObject secondary) {
        this.getSecondaries().add(secondary);
    }

    protected void removeSecondary(SecondaryConfigDataObject secondary) {
        this.getSecondaries().remove(secondary);
    }

    protected Set getSecondaries() {
        if (this.secondaries != null) {
            return this.secondaries;
        }
        this.secondaries = new HashSet();
        String[] paths = this.getProvider().getConfigSupport().getDeploymentConfigurationFileNames();
        for (int i = 0; i < paths.length; ++i) {
            File path = new File(paths[i]);
            FileObject fo = this.getProvider().findDeploymentConfigurationFile(path.getName());
            if (fo == null) continue;
            try {
                SecondaryConfigDataObject second = (SecondaryConfigDataObject)DataObject.find((FileObject)fo);
                this.secondaries.add(second);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return this.secondaries;
    }

    protected boolean isConfigEditorOpened() {
        Boolean result = (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                ConfigBeanTopComponent configEditor = ConfigDataObject.this.findOpenedConfigEditor();
                boolean isOpen = configEditor != null ? configEditor.isOpened() : false;
                return isOpen ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return result;
    }

    private OpenCookie _getOpenCookie() {
        OpenCookie myOpen = this.getOpenCookie();
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject secondary = (SecondaryConfigDataObject)i.next();
            if (secondary.getOpenCookie() != null) continue;
            return null;
        }
        return myOpen;
    }

    protected OpenCookie getOpenCookie() {
        if (!Utils.isSunServer(this.getProvider().getServerID())) {
            return null;
        }
        if (!this.isEditedChecked) {
            this.isEdited = this.checkIsEdited();
        }
        if (!this.isEdited) {
            if (this.xmlOpenSupport == null) {
                this.xmlOpenSupport = new XMLOpenSupport(this);
            }
            return this.xmlOpenSupport;
        }
        return null;
    }

    private EditCookie _getEditCookie() {
        EditCookie myEdit = this.getEditCookie();
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject secondary = (SecondaryConfigDataObject)i.next();
            if (secondary.getEditCookie() != null) continue;
            return null;
        }
        return myEdit;
    }

    protected EditCookie getEditCookie() {
        if (!this.isConfigEditorOpened()) {
            if (this.xmlEditorSupport == null) {
                this.xmlEditorSupport = new XMLEditorSupport(this);
            }
            return this.xmlEditorSupport;
        }
        return null;
    }

    public Node.Cookie getCookie(Class c) {
        ConfigurationStorage retValue = null;
        if (OpenCookie.class.isAssignableFrom(c)) {
            return this._getOpenCookie();
        }
        if (EditCookie.class.isAssignableFrom(c) || EditorCookie.class.isAssignableFrom(c) || CloseCookie.class.isAssignableFrom(c) || PrintCookie.class.isAssignableFrom(c)) {
            return this._getEditCookie();
        }
        if (ConfigurationStorage.class.isAssignableFrom(c)) {
            retValue = this.getStorage();
        } else {
            if (ValidateXMLCookie.class.isAssignableFrom(c)) {
                if (this.validateCookie == null) {
                    InputSource in = DataObjectAdapters.inputSource((DataObject)this);
                    this.validateCookie = new ValidateXMLSupport(in);
                }
                return this.validateCookie;
            }
            if (CheckXMLCookie.class.isAssignableFrom(c)) {
                if (this.checkCookie == null) {
                    InputSource in = DataObjectAdapters.inputSource((DataObject)this);
                    this.checkCookie = new CheckXMLSupport(in);
                }
                return this.checkCookie;
            }
        }
        if (retValue == null) {
            retValue = super.getCookie(c);
        }
        return retValue;
    }

    private boolean checkIsEdited() {
        if (this.xmlEditorSupport != null) {
            this.isEditedChecked = true;
            return this.xmlEditorSupport.getOpenedPanes() != null;
        }
        return false;
    }

    public void editorClosed(ConfigBeanTopComponent tc) {
        if (this.xmlOpenSupport != null) {
            this.xmlOpenSupport.reset();
        }
        tc.reset();
        this.fireCookieChange();
    }

    protected J2eeModuleProvider getProvider() {
        FileObject f = this.getPrimaryFile();
        J2eeModuleProvider provider = null;
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        if (p != null) {
            provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        }
        if (provider == null) {
            throw new RuntimeException("Project " + p + " does not provide J2eeModuleProvider in its lookup");
        }
        return provider;
    }

    protected ConfigurationStorage getStorage() {
        ConfigurationStorage storage = null;
        try {
            SunONEDeploymentConfiguration config = this.getDeploymentConfiguration();
            storage = config.getStorage();
        }
        catch (ConfigurationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return storage;
    }

    public static FileObject getRelative(FileObject from, String path) throws IOException {
        FileObject step = from;
        while (path.startsWith("..")) {
            step = step.getParent();
            if (!(path = path.substring(2)).startsWith("/")) continue;
            path = path.substring(1);
        }
        if (path.length() > 0) {
            step = step.getFileObject(path);
        }
        return step;
    }

    public static String getRelativePath(FileObject from, FileObject to) {
        String path = "";
        while (!(FileUtil.isParentOf((FileObject)from, (FileObject)to) && !from.equals(to) || from.equals(to))) {
            path = path + "../";
            from = from.getParent();
        }
        if (!from.equals(to)) {
            path = path + FileUtil.getRelativePath((FileObject)from, (FileObject)to);
        }
        return path;
    }

    public void resetChanged() {
        this.removeSaveCookie();
    }

    public void removeEditorChanges() {
        if (this.xmlEditorSupport != null) {
            this.xmlEditorSupport.notifyUnmodified();
        }
    }

    public void removeAllEditorChanges() {
        this.removeEditorChanges();
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject second = (SecondaryConfigDataObject)i.next();
            second.removeEditorChanges();
        }
    }

    public boolean areModified() {
        if (this.isModified()) {
            return true;
        }
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject second = (SecondaryConfigDataObject)i.next();
            if (!second.isModified()) continue;
            return true;
        }
        return false;
    }

    public void resetAllChanged() {
        this.resetChanged();
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject second = (SecondaryConfigDataObject)i.next();
            second.resetChanged();
        }
    }

    public void setChanged() {
        this.addSaveCookie(new S());
    }

    public boolean isModified() {
        return super.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReload(FileObject fo) throws IOException, InvalidModuleException, ConfigurationException {
        ConfigurationStorage cs = this.getStorage();
        if (cs != null && !cs.saveInProgress()) {
            boolean doReload = true;
            boolean doReopen = false;
            if (this.isConfigEditorOpened()) {
                if (this.isModified()) {
                    doReload = false;
                    if (!this.reloadDialogOpened) {
                        String message = NbBundle.getMessage((Class)ConfigDataObject.class, (String)"MSG_ExternalChange", (Object)fo.getName());
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0);
                        this.reloadDialogOpened = true;
                        try {
                            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            if (NotifyDescriptor.YES_OPTION.equals(ret)) {
                                this.resetChanged();
                                this.closeConfigEditors();
                                doReload = true;
                                doReopen = true;
                            }
                            doReload = false;
                        }
                        finally {
                            this.reloadDialogOpened = false;
                        }
                    }
                } else {
                    this.closeConfigEditors();
                    doReopen = true;
                }
            }
            if (doReload) {
                cs.load();
            }
            if (doReopen) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        OpenCookie opener = (OpenCookie)ConfigDataObject.this.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ConfigDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                        if (opener != null) {
                            opener.open();
                        }
                    }
                });
            }
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        try {
            if (this.isValid() && fe.getFile().equals(this.getPrimaryFile())) {
                this.handleReload(fe.getFile());
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    protected void fireCookieChange() {
        this.fireLimitedCookieChange();
        Iterator i = this.getSecondaries().iterator();
        while (i.hasNext()) {
            SecondaryConfigDataObject secondary = (SecondaryConfigDataObject)i.next();
            secondary.fireLimitedCookieChange();
        }
    }

    protected void fireLimitedCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    protected final void addSaveCookie(SaveCookie save) {
        this.getCookieSet().add((Node.Cookie)save);
        this.setModified(true);
    }

    protected final void removeSaveCookie() {
        SaveCookie sc = null;
        while ((sc = (SaveCookie)this.getCookie(class$org$openide$cookies$SaveCookie == null ? ConfigDataObject.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie)) != null) {
            this.getCookieSet().remove((Node.Cookie)sc);
        }
        this.setModified(false);
    }

    protected void openConfigEditor() {
        ConfigurationStorage storage = this.getStorage();
        ConfigBeanTopComponent tc = ConfigDataObject.findOpenedConfigEditor(storage);
        if (tc == null) {
            tc = new ConfigBeanTopComponent(storage);
        }
        tc.open();
        tc.requestActive();
        this.fireCookieChange();
    }

    protected ConfigBeanTopComponent findOpenedConfigEditor() {
        return ConfigDataObject.findOpenedConfigEditor(this.getStorage());
    }

    public static ConfigBeanTopComponent findOpenedConfigEditor(final ConfigurationStorage storage) {
        ConfigBeanTopComponent result = (ConfigBeanTopComponent)((Object)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                Iterator it = TopComponent.getRegistry().getOpened().iterator();
                while (it.hasNext()) {
                    ConfigBeanTopComponent beanTC;
                    TopComponent tc = (TopComponent)it.next();
                    if (!(tc instanceof ConfigBeanTopComponent) || !(beanTC = (ConfigBeanTopComponent)tc).isFor(storage)) continue;
                    return beanTC;
                }
                return null;
            }
        }));
        return result;
    }

    public boolean closeConfigEditors() {
        final ArrayList editorList = new ArrayList();
        ConfigurationStorage storage = this.getStorage();
        Iterator iter = TopComponent.getRegistry().getOpened().iterator();
        while (iter.hasNext()) {
            Object tc = iter.next();
            if (!(tc instanceof ConfigBeanTopComponent) || !((ConfigBeanTopComponent)((Object)tc)).isFor(storage)) continue;
            editorList.add(tc);
        }
        Boolean result = (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                Boolean result = Boolean.TRUE;
                Iterator iter = editorList.iterator();
                while (iter.hasNext()) {
                    ConfigBeanTopComponent configTC = (ConfigBeanTopComponent)((Object)iter.next());
                    result = configTC.close() && result != false ? Boolean.TRUE : Boolean.FALSE;
                }
                return result;
            }
        });
        return result;
    }

    private static class XMLEditorEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 6593415381104273008L;
        private final Class openSupportCookieClass;

        public XMLEditorEnv(ConfigDataObject dobj, Class cookieClass) {
            super((DataObject)dobj);
            this.openSupportCookieClass = cookieClass;
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((ConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(this.openSupportCookieClass);
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements EditCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(ConfigDataObject obj) {
            super((DataObject)obj, (CloneableEditorSupport.Env)new XMLEditorEnv(obj, class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = ConfigDataObject.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie));
            this.setMIMEType("text/xml");
        }

        protected boolean canClose() {
            boolean result = super.canClose();
            return result;
        }

        public void saveDocument() throws IOException {
            block4: {
                String defaultEncoding = "UTF8";
                StyledDocument doc = this.getDocument();
                String enc = EncodingUtil.detectEncoding((Document)doc);
                if (enc == null) {
                    enc = "UTF8";
                }
                try {
                    new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), enc);
                    if (this.queryCanEncode(doc, enc)) {
                        super.saveDocument();
                        this.getDataObject().setModified(false);
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    if (!this.queryUpdateProlog(doc, enc, "UTF8")) break block4;
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                }
            }
        }

        private boolean queryCanEncode(StyledDocument doc, String enc) {
            boolean result = true;
            try {
                CharsetEncoder coder = Charset.forName(enc).newEncoder();
                if (!coder.canEncode(doc.getText(0, doc.getLength()))) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport = ConfigDataObject.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject$XMLEditorSupport")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport), (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc}), 0, 2);
                    nd.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                        result = false;
                    }
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return result;
        }

        private boolean queryUpdateProlog(final StyledDocument doc, String enc, final String defaultEncoding) {
            boolean needsSave = false;
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport = ConfigDataObject.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject$XMLEditorSupport")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigDataObject$XMLEditorSupport), (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), enc, defaultEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() == NotifyDescriptor.YES_OPTION) {
                try {
                    int MAX_PROLOG = 1000;
                    int maxPrologLen = Math.min(1000, doc.getLength());
                    final char[] prolog = doc.getText(0, maxPrologLen).toCharArray();
                    int prologLen = 0;
                    if (prolog[0] == '<' && prolog[1] == '?' && prolog[2] == 'x') {
                        for (int i = 3; i < maxPrologLen; ++i) {
                            if (prolog[i] != '?' || prolog[i + 1] != '>') continue;
                            prologLen = i + 1;
                            break;
                        }
                    }
                    final int passPrologLen = prologLen;
                    Runnable edit = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    doc.remove(0, passPrologLen + 1);
                                    doc.insertString(0, "<?xml version='1.0' encoding='" + defaultEncoding + "' ?> \n<!-- was: " + new String(prolog, 0, passPrologLen + 1) + " -->", null);
                                }
                                catch (BadLocationException e) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)doc, (Runnable)edit);
                    needsSave = true;
                }
                catch (BadLocationException lex) {
                    ErrorManager.getDefault().notify((Throwable)lex);
                }
            }
            return needsSave;
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            ((ConfigDataObject)this.getDataObject()).addSaveCookie(new Save());
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            ((ConfigDataObject)this.getDataObject()).resetChanged();
        }

        public void edit() {
            ConfigDataObject cdo = (ConfigDataObject)this.getDataObject();
            cdo.isEdited = true;
            this.open();
            cdo.fireCookieChange();
        }

        protected void notifyClosed() {
            super.notifyClosed();
            ConfigDataObject cdo = (ConfigDataObject)this.getDataObject();
            cdo.isEdited = false;
            cdo.fireCookieChange();
        }

        public void refreshDocument() {
            super.reloadDocument();
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
            }
        }
    }

    private static class XMLOpenSupport
    extends DataEditorSupport
    implements OpenCookie,
    PropertyChangeListener {
        public XMLOpenSupport(ConfigDataObject obj) {
            super((DataObject)obj, (CloneableEditorSupport.Env)new XMLEditorEnv(obj, class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = ConfigDataObject.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie));
            this.setMIMEType("text/xml");
        }

        public void open() {
            ConfigDataObject cdo = (ConfigDataObject)this.getDataObject();
            cdo.addPropertyChangeListener(this);
            cdo.getPrimaryFile().refresh();
            ConfigurationStorage configStorage = (ConfigurationStorage)cdo.getCookie(class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage = ConfigDataObject.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage);
            if (configStorage == null) {
                EditCookie editor = (EditCookie)cdo.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = ConfigDataObject.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                if (editor != null) {
                    editor.edit();
                }
                return;
            }
            cdo.openConfigEditor();
        }

        protected CloneableTopComponent createCloneableTopComponent() {
            ConfigDataObject cdo = (ConfigDataObject)this.getDataObject();
            ConfigurationStorage storage = (ConfigurationStorage)cdo.getCookie(class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage == null ? (class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage = ConfigDataObject.class$("org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage")) : class$org$netbeans$modules$j2ee$sun$share$config$ConfigurationStorage);
            return new ConfigBeanTopComponent(storage);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ConfigDataObject cdo;
            if ("modified".equals(evt.getPropertyName()) && (cdo = (ConfigDataObject)this.getDataObject()).isValid()) {
                final ConfigurationStorage storage = cdo.getStorage();
                final String newDisplayName = this.messageName();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        Iterator it = TopComponent.getRegistry().getOpened().iterator();
                        while (it.hasNext()) {
                            ConfigBeanTopComponent configEditor;
                            TopComponent tc = (TopComponent)it.next();
                            if (!(tc instanceof ConfigBeanTopComponent) || !(configEditor = (ConfigBeanTopComponent)tc).isFor(storage)) continue;
                            configEditor.setDisplayName(newDisplayName);
                        }
                    }
                });
            }
        }

        public void reset() {
            ((ConfigDataObject)this.getDataObject()).removePropertyChangeListener(this);
        }
    }

    private class S
    implements SaveCookie {
        private S() {
        }

        public void save() throws IOException {
            ConfigurationStorage cs = ConfigDataObject.this.getStorage();
            if (cs != null) {
                cs.save();
            }
        }
    }
}

