/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.view.GapDocumentView;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class JavaEditorWarmUpTask
implements Runnable {
    private static final int ARTIFICIAL_DOCUMENT_LINE_COUNT = 1510;
    private static final int VIEW_HIERARCHY_CREATION_COUNT = 1;
    private static final int IMAGE_WIDTH = 600;
    private static final int IMAGE_HEIGHT = 400;
    private static final int PAINT_COUNT = 1;
    private static final boolean debug;
    private static final int STATUS_INIT = 0;
    private static final int STATUS_CREATE_PANE = 1;
    private static final int STATUS_CREATE_DOCUMENTS = 2;
    private static final int STATUS_SWITCH_DOCUMENTS = 3;
    private static final int STATUS_TRAVERSE_VIEWS = 4;
    private static final int STATUS_RENDER_FRAME = 5;
    private int status = 0;
    private JEditorPane pane;
    private JFrame frame;
    private Document emptyDoc;
    private Document longDoc;
    private Graphics bGraphics;
    private BaseKit javaKit;
    private long startTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        switch (this.status) {
            case 0: {
                Iterator componentIterator;
                if (debug) {
                    this.startTime = System.currentTimeMillis();
                }
                this.javaKit = BaseKit.getKit((Class)JavaKit.class);
                this.javaKit.getActions();
                if (debug) {
                    System.out.println("Kit instances initialized: " + (System.currentTimeMillis() - this.startTime));
                    this.startTime = System.currentTimeMillis();
                }
                if ((componentIterator = Registry.getComponentIterator()).hasNext()) break;
                this.status = 1;
                SwingUtilities.invokeLater(this);
                break;
            }
            case 1: {
                if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError();
                }
                this.pane = new JEditorPane();
                this.pane.setEditorKit((EditorKit)this.javaKit);
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.pane);
                if (editorUI != null) {
                    editorUI.getExtComponent();
                }
                Registry.removeComponent((JTextComponent)this.pane);
                this.status = 2;
                RequestProcessor.getDefault().post((Runnable)this);
                break;
            }
            case 2: {
                this.emptyDoc = this.javaKit.createDefaultDocument();
                this.longDoc = this.pane.getDocument();
                try {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 1510; i > 0; --i) {
                        sb.append("int ident = 1; // comment\n");
                    }
                    this.longDoc.insertString(0, sb.toString(), null);
                    this.status = 3;
                    SwingUtilities.invokeLater(this);
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 1; ++i) {
                    this.pane.setDocument(this.emptyDoc);
                    this.pane.setDocument(this.longDoc);
                }
                this.status = 4;
                RequestProcessor.getDefault().post((Runnable)this);
                break;
            }
            case 4: {
                try {
                    BufferedImage bImage = new BufferedImage(600, 400, 1);
                    this.bGraphics = bImage.getGraphics();
                    this.bGraphics.setClip(0, 0, 600, 400);
                    AbstractDocument doc = (AbstractDocument)this.pane.getDocument();
                    doc.readLock();
                    try {
                        final View rootView = Utilities.getDocumentView((JTextComponent)this.pane);
                        LockView lockView = LockView.get((View)rootView);
                        lockView.lock();
                        try {
                            int viewCount = rootView.getViewCount();
                            Runnable resetChildrenEstimatedSpans = new Runnable(){

                                public void run() {
                                    int cnt = rootView.getViewCount();
                                    for (int j = 0; j < cnt; ++j) {
                                        View v = rootView.getView(j);
                                        if (!(v instanceof EstimatedSpanView)) continue;
                                        ((EstimatedSpanView)v).setEstimatedSpan(false);
                                    }
                                }
                            };
                            if (rootView instanceof GapDocumentView) {
                                ((GapDocumentView)rootView).renderWithUpdateLayout(resetChildrenEstimatedSpans);
                            } else {
                                resetChildrenEstimatedSpans.run();
                            }
                            for (int j = 0; j < viewCount; ++j) {
                                Rectangle alloc = new Rectangle(0, 0, (int)rootView.getPreferredSpan(0), (int)rootView.getPreferredSpan(1));
                                rootView.getChildAllocation(j, alloc);
                            }
                            int rootViewWidth = (int)rootView.getPreferredSpan(0);
                            int rootViewHeight = (int)rootView.getPreferredSpan(1);
                            Rectangle alloc = new Rectangle(0, 0, rootViewWidth, rootViewHeight);
                            for (int i = 0; i >= 0; --i) {
                                rootView.paint(this.bGraphics, alloc);
                            }
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                this.status = 5;
                SwingUtilities.invokeLater(this);
                break;
            }
            case 5: {
                this.frame = new JFrame();
                EditorUI ui = Utilities.getEditorUI((JTextComponent)this.pane);
                JComponent mainComp = null;
                if (ui != null) {
                    mainComp = ui.getExtComponent();
                }
                if (mainComp == null) {
                    mainComp = new JScrollPane(this.pane);
                }
                this.frame.getContentPane().add(mainComp);
                this.frame.pack();
                this.frame.paint(this.bGraphics);
                this.frame.getContentPane().removeAll();
                this.frame.dispose();
                this.pane.setEditorKit(null);
                if (!debug) break;
                System.out.println("View hierarchy initialized: " + (System.currentTimeMillis() - this.startTime));
                this.startTime = System.currentTimeMillis();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    static {
        $assertionsDisabled = !JavaEditorWarmUpTask.class.desiredAssertionStatus();
        debug = Boolean.getBoolean("netbeans.debug.editor.warmup");
    }
}

