/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.progress;

import java.util.ArrayList;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;

public class MultiProgressObjectWrapper
implements ProgressObject,
ProgressListener {
    private ProgressEventSupport pes;
    private ProgressObject[] progObjs;
    private String message = "";
    private int completedCounter;
    private StateType state = StateType.RUNNING;

    public MultiProgressObjectWrapper(ProgressObject[] progObjs) {
        if (progObjs == null) {
            throw new NullPointerException("The progObjs argument must not be null.");
        }
        if (progObjs.length == 0) {
            throw new IllegalArgumentException("At least one progress object must be passed.");
        }
        this.pes = new ProgressEventSupport(this);
        this.progObjs = progObjs;
        for (int i = 0; i < progObjs.length; ++i) {
            ProgressObject po = progObjs[i];
            po.addProgressListener((ProgressListener)this);
        }
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        DeploymentStatus ds = this.progObjs[0].getDeploymentStatus();
        return new Status(ds.getAction(), ds.getCommand(), this.message, this.state);
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        ArrayList<TargetModuleID> returnVal = new ArrayList<TargetModuleID>();
        for (int i = 0; i < this.progObjs.length; ++i) {
            ProgressObject po = this.progObjs[i];
            if (!po.getDeploymentStatus().isCompleted()) continue;
            returnVal.add(po.getResultTargetModuleIDs()[0]);
        }
        return returnVal.toArray(new TargetModuleID[returnVal.size()]);
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported in Tomcat deployment");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported in Tomcat deployment");
    }

    public void addProgressListener(ProgressListener l) {
        this.pes.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.pes.removeProgressListener(l);
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        this.message = progressEvent.getDeploymentStatus().getMessage();
        StateType stateType = progressEvent.getDeploymentStatus().getState();
        if (stateType == StateType.FAILED) {
            this.state = StateType.FAILED;
        } else if (stateType == StateType.RELEASED) {
            this.state = StateType.RELEASED;
        } else if (stateType == StateType.COMPLETED && ++this.completedCounter == this.progObjs.length) {
            this.state = StateType.COMPLETED;
        }
        this.pes.fireHandleProgressEvent(progressEvent.getTargetModuleID(), progressEvent.getDeploymentStatus());
    }
}

