/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.modules.project.ant.UserQuestionHandler;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class ProjectProperties {
    private final AntProjectHelper helper;
    private final Map properties = new HashMap();
    private PropertyProvider stockPropertyPreprovider = null;
    private PropertyEvaluator standardPropertyEvaluator = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectProperties(AntProjectHelper helper) {
        this.helper = helper;
    }

    public EditableProperties getProperties(String path) {
        EditableProperties ep = this.getPP(path).getEditablePropertiesOrNull();
        if (ep != null) {
            return ep.cloneProperties();
        }
        return new EditableProperties(true);
    }

    public boolean putProperties(String path, EditableProperties props) {
        return this.getPP(path).put(props);
    }

    public FileLock write(String path) throws IOException {
        if (!$assertionsDisabled && !this.properties.containsKey(path)) {
            throw new AssertionError();
        }
        return this.getPP(path).write();
    }

    public PropertyProvider getPropertyProvider(String path) {
        return this.getPP(path);
    }

    private PP getPP(String path) {
        PP pp = (PP)this.properties.get(path);
        if (pp == null) {
            pp = new PP(path, this.helper);
            this.properties.put(path, pp);
        }
        return pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyProvider getStockPropertyPreprovider() {
        if (this.stockPropertyPreprovider == null) {
            Properties p;
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            Properties properties = p = System.getProperties();
            synchronized (properties) {
                Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    if (entry.getValue() instanceof String && entry.getKey() instanceof String) continue;
                    ErrorManager.getDefault().log(16, "WARNING: removing non-String-valued system property " + entry.getKey() + "=" + entry.getValue() + " (cf. #45788)");
                    it.remove();
                }
                m.putAll(p);
            }
            m.put("basedir", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()).getAbsolutePath());
            File antJar = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (antJar != null) {
                File antHome = antJar.getParentFile().getParentFile();
                m.put("ant.home", antHome.getAbsolutePath());
            }
            this.stockPropertyPreprovider = PropertyUtils.fixedPropertyProvider(m);
        }
        return this.stockPropertyPreprovider;
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        if (this.standardPropertyEvaluator == null) {
            PropertyEvaluator findUserPropertiesFile = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), new PropertyProvider[]{this.getPropertyProvider("nbproject/private/private.properties")});
            UserPropertiesProvider globalProperties = new UserPropertiesProvider(findUserPropertiesFile);
            this.standardPropertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), new PropertyProvider[]{this.getPropertyProvider("nbproject/private/private.properties"), globalProperties, this.getPropertyProvider("nbproject/project.properties")});
        }
        return this.standardPropertyEvaluator;
    }

    private PropertyProvider computeDelegate(PropertyEvaluator findUserPropertiesFile) {
        String userPropertiesFile = findUserPropertiesFile.getProperty("user.properties.file");
        if (userPropertiesFile != null) {
            File f = this.helper.resolveFile(userPropertiesFile);
            if (f.equals(PropertyUtils.userBuildProperties())) {
                return PropertyUtils.globalPropertyProvider();
            }
            return PropertyUtils.propertiesFilePropertyProvider(f);
        }
        return PropertyUtils.globalPropertyProvider();
    }

    static {
        $assertionsDisabled = !ProjectProperties.class.desiredAssertionStatus();
    }

    private final class UserPropertiesProvider
    extends PropertyUtils.DelegatingPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator findUserPropertiesFile;

        public UserPropertiesProvider(PropertyEvaluator findUserPropertiesFile) {
            super(ProjectProperties.this.computeDelegate(findUserPropertiesFile));
            this.findUserPropertiesFile = findUserPropertiesFile;
            findUserPropertiesFile.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("user.properties.file".equals(ev.getPropertyName())) {
                this.setDelegate(ProjectProperties.this.computeDelegate(this.findUserPropertiesFile));
            }
        }
    }

    private static final class PP
    implements PropertyProvider,
    FileChangeSupportListener {
        private static final RequestProcessor RP;
        private final String path;
        private final AntProjectHelper helper;
        private EditableProperties properties = null;
        private boolean loaded = false;
        private final List listeners = new ArrayList();
        private boolean writing = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PP(String path, AntProjectHelper helper) {
            this.path = path;
            this.helper = helper;
            FileChangeSupport.DEFAULT.addListener(this, new File(FileUtil.toFile((FileObject)this.dir()), path.replace('/', File.separatorChar)));
        }

        private FileObject dir() {
            return this.helper.getProjectDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EditableProperties getEditablePropertiesOrNull() {
            if (!this.loaded) {
                this.properties = null;
                FileObject fo = this.dir().getFileObject(this.path);
                if (fo != null) {
                    try {
                        EditableProperties p;
                        InputStream is = fo.getInputStream();
                        try {
                            p = new EditableProperties(true);
                            p.load(is);
                        }
                        finally {
                            is.close();
                        }
                        this.properties = p;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
                this.loaded = true;
            }
            return this.properties;
        }

        public boolean put(EditableProperties nue) {
            boolean modifying;
            this.loaded = true;
            boolean bl = modifying = !Utilities.compareObjects((Object)nue, (Object)this.properties);
            if (modifying) {
                this.properties = nue != null ? nue.cloneProperties() : null;
                this.fireChange();
            }
            return modifying;
        }

        public FileLock write() throws IOException {
            if (!$assertionsDisabled && !this.loaded) {
                throw new AssertionError();
            }
            final FileObject f = this.dir().getFileObject(this.path);
            if (!$assertionsDisabled && this.writing) {
                throw new AssertionError();
            }
            final FileLock[] _lock = new FileLock[1];
            this.writing = true;
            try {
                if (this.properties != null) {
                    this.dir().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){
                        static final /* synthetic */ boolean $assertionsDisabled;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            FileObject _f;
                            if (f == null) {
                                _f = FileUtil.createData((FileObject)PP.this.dir(), (String)PP.this.path);
                                if (!$assertionsDisabled && _f == null) {
                                    throw new AssertionError((Object)("FU.cD must not return null; called on " + PP.this.dir() + " + " + PP.this.path));
                                }
                            } else {
                                _f = f;
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PP.this.properties.store(baos);
                            final byte[] data = baos.toByteArray();
                            try {
                                _lock[0] = _f.lock();
                                OutputStream os = _f.getOutputStream(_lock[0]);
                                try {
                                    os.write(data);
                                }
                                finally {
                                    os.close();
                                }
                            }
                            catch (UserQuestionException uqe) {
                                PP.this.helper.needPendingHook();
                                UserQuestionHandler.handle(uqe, new UserQuestionHandler.Callback(){
                                    static final /* synthetic */ boolean $assertionsDisabled;

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void accepted() {
                                        if (!$assertionsDisabled && PP.this.writing) {
                                            throw new AssertionError();
                                        }
                                        PP.this.writing = true;
                                        try {
                                            FileLock lock = _f.lock();
                                            try {
                                                OutputStream os = _f.getOutputStream(lock);
                                                try {
                                                    os.write(data);
                                                }
                                                finally {
                                                    os.close();
                                                }
                                            }
                                            finally {
                                                lock.releaseLock();
                                            }
                                            PP.this.helper.maybeCallPendingHook();
                                        }
                                        catch (IOException e) {
                                            ErrorManager.getDefault().notify((Throwable)e);
                                            this.reload();
                                        }
                                        finally {
                                            PP.this.writing = false;
                                        }
                                    }

                                    public void denied() {
                                        this.reload();
                                    }

                                    public void error(IOException e) {
                                        ErrorManager.getDefault().notify((Throwable)e);
                                        this.reload();
                                    }

                                    private void reload() {
                                        PP.this.helper.cancelPendingHook();
                                        PP.this.diskChange();
                                    }

                                    static {
                                        $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ProjectProperties == null ? (class$org$netbeans$spi$project$support$ant$ProjectProperties = ProjectProperties.class$("org.netbeans.spi.project.support.ant.ProjectProperties")) : class$org$netbeans$spi$project$support$ant$ProjectProperties).desiredAssertionStatus();
                                    }
                                });
                            }
                        }

                        static {
                            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ProjectProperties == null ? (class$org$netbeans$spi$project$support$ant$ProjectProperties = ProjectProperties.class$("org.netbeans.spi.project.support.ant.ProjectProperties")) : class$org$netbeans$spi$project$support$ant$ProjectProperties).desiredAssertionStatus();
                        }
                    });
                } else if (f != null) {
                    f.delete();
                }
            }
            catch (IOException e) {
                if (_lock[0] != null) {
                    _lock[0].releaseLock();
                }
                throw e;
            }
            finally {
                this.writing = false;
            }
            return _lock[0];
        }

        public Map getProperties() {
            EditableProperties props = this.getEditablePropertiesOrNull();
            if (props != null) {
                return Collections.unmodifiableMap(props);
            }
            return Collections.EMPTY_MAP;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] ls;
            PP pP = this;
            synchronized (pP) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            final ChangeEvent ev = new ChangeEvent(this);
            final Mutex.Action action = new Mutex.Action(){

                public Object run() {
                    for (int i = 0; i < ls.length; ++i) {
                        ls[i].stateChanged(ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess(action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable(){

                    public void run() {
                        ProjectManager.mutex().readAccess(action);
                    }
                });
            }
        }

        private void diskChange() {
            if (!this.writing) {
                this.loaded = false;
            }
            this.fireChange();
            if (!this.writing) {
                this.helper.fireExternalChange(this.path);
            }
        }

        public void fileCreated(FileChangeSupportEvent event) {
            this.diskChange();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            this.diskChange();
        }

        public void fileModified(FileChangeSupportEvent event) {
            this.diskChange();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$ProjectProperties == null ? (class$org$netbeans$spi$project$support$ant$ProjectProperties = ProjectProperties.class$("org.netbeans.spi.project.support.ant.ProjectProperties")) : class$org$netbeans$spi$project$support$ant$ProjectProperties).desiredAssertionStatus();
            RP = new RequestProcessor("ProjectProperties.PP.RP");
        }
    }
}

