/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public class FreeformProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private FreeformProject project;

    public FreeformProjectOperations(FreeformProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList files = new ArrayList();
        FreeformProjectOperations.addFile(projectDirectory, "nbproject", files);
        return files;
    }

    public List getDataFiles() {
        Element genldata = this.project.helper().getPrimaryConfigurationData(true);
        Element foldersEl = Util.findElement(genldata, "folders", "http://www.netbeans.org/ns/freeform-project/1");
        List folders = foldersEl != null ? Util.findSubElements(foldersEl) : Collections.EMPTY_LIST;
        ArrayList result = new ArrayList();
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!"source-folder".equals(el.getLocalName()) || !"http://www.netbeans.org/ns/freeform-project/1".equals(el.getNamespaceURI())) continue;
            this.addFile(el, result);
        }
        FreeformProjectOperations.addFile(this.project.getProjectDirectory(), "build.xml", result);
        return result;
    }

    private void addFile(Element folder, List result) {
        Element location = Util.findElement(folder, "location", "http://www.netbeans.org/ns/freeform-project/1");
        if (location == null) {
            return;
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String val = evaluator.evaluate(Util.findText(location));
        if (val == null) {
            return;
        }
        File f = this.project.helper().resolveFile(val);
        if (f == null) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo != null && FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fo)) {
            result.add(fo);
        }
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        this.project.helper().notifyDeleted();
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) throws IOException {
        if (original != null) {
            this.project.setName(nueName);
        }
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        if (original != null) {
            this.project.setName(nueName);
        } else {
            this.project.helper().notifyDeleted();
        }
    }
}

