/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.io.File;
import java.util.Iterator;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class CollocationQuery {
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(CollocationQueryImplementation.class));

    private CollocationQuery() {
    }

    public static boolean areCollocated(File file1, File file2) {
        if (!file1.equals(FileUtil.normalizeFile((File)file1))) {
            throw new IllegalArgumentException("Parameter file1 was not normalized. Was " + file1 + " instead of " + FileUtil.normalizeFile((File)file1));
        }
        if (!file2.equals(FileUtil.normalizeFile((File)file2))) {
            throw new IllegalArgumentException("Parameter file2 was not normalized. Was " + file2 + " instead of " + FileUtil.normalizeFile((File)file2));
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            CollocationQueryImplementation cqi = (CollocationQueryImplementation)it.next();
            if (!cqi.areCollocated(file1, file2)) continue;
            return true;
        }
        return false;
    }

    public static File findRoot(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            CollocationQueryImplementation cqi = (CollocationQueryImplementation)it.next();
            File root = cqi.findRoot(file);
            if (root == null) continue;
            return root;
        }
        return null;
    }
}

