/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.form.RADProperty;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertyAction
extends AbstractAction {
    private static final String OK_COMMAND = "OK";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String RESTORE_COMMAND = "Restore";
    private RADProperty property;
    private Dialog dialog;

    public PropertyAction(RADProperty property) {
        this.property = property;
        String name = (String)property.getValue("actionName");
        if (name == null) {
            StringBuffer sb = new StringBuffer(property.getName());
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            name = sb.toString();
        }
        this.putValue("Name", name);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            PropertyEditor propEd = this.property.getPropertyEditor();
            propEd.setValue(this.property.getValue());
            final Component custEditor = propEd.getCustomEditor();
            Object[] options = this.buttons();
            DialogDescriptor descriptor = new DialogDescriptor((Object)custEditor, (String)this.getValue("Name"), true, options, DialogDescriptor.CANCEL_OPTION, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String action = e.getActionCommand();
                        if (PropertyAction.OK_COMMAND.equals(action)) {
                            Object value = ((EnhancedCustomPropertyEditor)custEditor).getPropertyValue();
                            PropertyAction.this.property.setValue(value);
                        } else if (PropertyAction.RESTORE_COMMAND.equals(action)) {
                            PropertyAction.this.property.restoreDefaultValue();
                        }
                        PropertyAction.this.dialog.dispose();
                    }
                    catch (Exception ex) {
                        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getBundle(PropertyAction.class).getString("MSG_InvalidValue"));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    }
                }
            });
            descriptor.setClosingOptions(new Object[0]);
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.setVisible(true);
            this.dialog = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object[] buttons() {
        ResourceBundle bundle = NbBundle.getBundle(PropertyAction.class);
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)bundle.getString("CTL_OK"));
        okButton.setActionCommand(OK_COMMAND);
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)bundle.getString("CTL_Cancel"));
        cancelButton.setActionCommand(CANCEL_COMMAND);
        if (this.property.isDefaultValue()) {
            return new Object[]{okButton, cancelButton};
        }
        JButton restoreButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)restoreButton, (String)bundle.getString("CTL_RestoreDefault"));
        restoreButton.setActionCommand(RESTORE_COMMAND);
        return new Object[]{okButton, restoreButton, cancelButton};
    }
}

