/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;

class LayoutFeeder
implements LayoutConstants {
    boolean imposeSize;
    boolean optimizeStructure;
    private LayoutModel layoutModel;
    private LayoutOperations operations;
    private LayoutDragger dragger;
    private IncludeDesc[] originalPositions1 = new IncludeDesc[2];
    private IncludeDesc[] originalPositions2 = new IncludeDesc[2];
    private boolean[] originalLPositionsFixed = new boolean[2];
    private boolean[] originalTPositionsFixed = new boolean[2];
    private LayoutDragger.PositionDef[] newPositions = new LayoutDragger.PositionDef[2];
    private LayoutInterval[] addingIntervals;
    private boolean[] becomeResizing = new boolean[2];
    private int dimension;
    private LayoutInterval addingInterval;
    private LayoutRegion addingSpace;
    private boolean solveOverlap;
    private boolean originalLPosFixed;
    private boolean originalTPosFixed;
    private int aEdge;
    private LayoutInterval aSnappedParallel;
    private LayoutInterval aSnappedNextTo;

    private static boolean sameInclusionGroup(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        LayoutInterval parent1 = iDesc1.parent.isSequential() && !iDesc1.newSubGroup ? iDesc1.parent.getParent() : iDesc1.parent;
        LayoutInterval parent2 = iDesc2.parent.isSequential() && !iDesc2.newSubGroup ? iDesc2.parent.getParent() : iDesc2.parent;
        return parent1 == parent2;
    }

    LayoutFeeder(LayoutOperations operations, LayoutDragger dragger, LayoutInterval[] addingIntervals) {
        this.layoutModel = operations.getModel();
        this.operations = operations;
        this.dragger = dragger;
        this.addingIntervals = addingIntervals;
        for (int dim = 0; dim < 2; ++dim) {
            this.dimension = dim;
            if (dragger.isResizing()) {
                LayoutInterval adding = addingIntervals[dim];
                if (dragger.isResizing(dim)) {
                    IncludeDesc pos = LayoutFeeder.findOutCurrentPosition(adding, dim, dragger.getResizingEdge(dim) ^ 1);
                    LayoutDragger.PositionDef newPos = dragger.getPositions()[dim];
                    if (!(newPos != null && newPos.snapped || pos.snapped())) {
                        pos.alignment = LayoutInterval.getEffectiveAlignment(adding);
                    }
                    this.originalPositions1[dim] = pos;
                    this.newPositions[dim] = newPos;
                    this.becomeResizing[dim] = this.checkResizing();
                } else {
                    IncludeDesc pos2;
                    IncludeDesc pos1;
                    int alignment = -1;
                    this.originalPositions1[dim] = pos1 = LayoutFeeder.findOutCurrentPosition(adding, dim, alignment);
                    alignment = pos1.alignment;
                    if ((alignment == 0 || alignment == 1) && (pos2 = LayoutFeeder.findOutCurrentPosition(adding, dim, alignment ^ 1)).snapped()) {
                        this.originalPositions2[dim] = pos2;
                    }
                }
                this.originalLPositionsFixed[dim] = LayoutFeeder.isFixedRelativePosition(adding, 0);
                this.originalTPositionsFixed[dim] = LayoutFeeder.isFixedRelativePosition(adding, 1);
                continue;
            }
            this.newPositions[dim] = dragger.getPositions()[dim];
        }
    }

    void add() {
        int overlapDim;
        int dim = overlapDim = this.getDimensionSolvingOverlap(this.newPositions);
        for (int dc = 0; dc < 2; ++dc) {
            LayoutDragger.PositionDef newPos;
            this.dimension = dim;
            this.addingInterval = this.addingIntervals[dim];
            this.addingSpace = this.dragger.getMovingSpace();
            this.addingInterval.setCurrentSpace(this.addingSpace);
            this.solveOverlap = overlapDim == dim;
            IncludeDesc originalPos1 = this.originalPositions1[dim];
            IncludeDesc originalPos2 = this.originalPositions2[dim];
            LayoutFeeder.correctNeighborInSequence(originalPos1);
            LayoutFeeder.correctNeighborInSequence(originalPos2);
            if (this.dragger.isResizing()) {
                this.originalLPosFixed = this.originalLPositionsFixed[dim];
                this.originalTPosFixed = this.originalTPositionsFixed[dim];
                if (this.dragger.isResizing(dim)) {
                    this.layoutModel.setIntervalSize(this.addingInterval, this.becomeResizing[dim] ? -1 : -2, this.addingSpace.size(dim), this.becomeResizing[dim] ? Short.MAX_VALUE : -2);
                }
            }
            if ((newPos = this.newPositions[dim]) != null && (newPos.alignment == 2 || newPos.alignment == 3)) {
                this.aEdge = newPos.alignment;
                this.aSnappedParallel = newPos.interval;
                this.addSimplyAligned();
            } else if (this.dragger.isResizing() && (originalPos1.alignment == 2 || originalPos1.alignment == 3)) {
                this.aEdge = originalPos1.alignment;
                this.aSnappedParallel = originalPos1.snappedParallel;
                this.addSimplyAligned();
            } else {
                IncludeDesc inclusion1 = null;
                IncludeDesc inclusion2 = null;
                LinkedList<IncludeDesc> inclusions = new LinkedList<IncludeDesc>();
                boolean preserveOriginal = false;
                if (this.dragger.isResizing(dim ^ 1)) {
                    this.aEdge = originalPos1.alignment;
                    this.aSnappedParallel = originalPos1.snappedParallel;
                    this.aSnappedNextTo = originalPos1.snappedNextTo;
                } else if (newPos != null) {
                    this.aEdge = newPos.alignment;
                    this.aSnappedParallel = !newPos.nextTo ? newPos.interval : null;
                    this.aSnappedNextTo = newPos.snapped && newPos.nextTo ? newPos.interval : null;
                    preserveOriginal = this.dragger.isResizing(dim);
                } else if (this.dragger.isResizing(dim)) {
                    this.aEdge = originalPos1.alignment;
                    this.aSnappedParallel = originalPos1.snappedParallel;
                    this.aSnappedNextTo = originalPos1.snappedNextTo;
                    preserveOriginal = true;
                } else {
                    this.aEdge = -1;
                    this.aSnappedNextTo = null;
                    this.aSnappedParallel = null;
                }
                LayoutInterval root = this.dragger.getTargetContainer().getLayoutRoot(dim);
                this.analyzeParallel(root, inclusions);
                if (inclusions.isEmpty()) {
                    assert (this.aSnappedParallel != null);
                    if (originalPos1 != null && originalPos1.alignment == this.aEdge) {
                        inclusions.add(originalPos1);
                    } else {
                        this.addAligningInclusion(inclusions);
                    }
                } else {
                    IncludeDesc preferred = this.addAligningInclusion(inclusions);
                    if (inclusions.size() > 1) {
                        if (preferred == null || preserveOriginal && originalPos1.alignment == this.aEdge) {
                            preferred = originalPos1;
                        }
                        this.mergeParallelInclusions(inclusions, preferred, preserveOriginal);
                        assert (inclusions.size() == 1);
                    }
                }
                IncludeDesc found = (IncludeDesc)inclusions.get(0);
                inclusions.clear();
                if (preserveOriginal) {
                    inclusion1 = originalPos1;
                    if (found != originalPos1) {
                        if (newPos != null) {
                            inclusion2 = found;
                        }
                        if (found.parent == originalPos1.parent && found.newSubGroup) {
                            originalPos1.newSubGroup = true;
                        }
                    }
                } else {
                    inclusion1 = found;
                    if (this.dragger.isResizing(dim ^ 1) && (newPos != null || originalPos2 != null)) {
                        if (newPos != null) {
                            assert (this.dragger.isResizing(dim));
                            this.aEdge = newPos.alignment;
                            this.aSnappedParallel = !newPos.nextTo ? newPos.interval : null;
                            this.aSnappedNextTo = newPos.snapped && newPos.nextTo ? newPos.interval : null;
                        } else {
                            assert (!this.dragger.isResizing(dim));
                            this.aEdge = originalPos2.alignment;
                            this.aSnappedParallel = originalPos2.snappedParallel;
                            this.aSnappedNextTo = originalPos2.snappedNextTo;
                        }
                        this.analyzeParallel(root, inclusions);
                        if (inclusions.isEmpty()) {
                            assert (this.aSnappedParallel != null);
                            if (originalPos2 != null && originalPos2.alignment == this.aEdge) {
                                inclusions.add(originalPos2);
                            } else {
                                this.addAligningInclusion(inclusions);
                            }
                        } else {
                            IncludeDesc preferred = this.addAligningInclusion(inclusions);
                            if (inclusions.size() > 1) {
                                if (preferred == null) {
                                    preferred = originalPos2 != null ? originalPos2 : originalPos1;
                                }
                                this.mergeParallelInclusions(inclusions, preferred, false);
                                assert (inclusions.size() == 1);
                            }
                        }
                        inclusion2 = (IncludeDesc)inclusions.get(0);
                        inclusions.clear();
                    }
                }
                if (!this.mergeSequentialInclusions(inclusion1, inclusion2)) {
                    inclusion2 = null;
                }
                this.addInterval(inclusion1, inclusion2);
            }
            dim ^= 1;
        }
    }

    private static IncludeDesc findOutCurrentPosition(LayoutInterval interval, int dimension, int alignment) {
        LayoutInterval prev;
        LayoutInterval gap;
        LayoutInterval parent = interval.getParent();
        int nonEmptyCount = LayoutInterval.getCount(parent, Integer.MAX_VALUE, true);
        IncludeDesc iDesc = new IncludeDesc();
        if (parent.isSequential() && nonEmptyCount > 1) {
            if (alignment < 0) {
                alignment = 0;
            }
            if (nonEmptyCount == 2) {
                iDesc.parent = parent.getParent();
                int index = 0;
                for (int i = parent.getSubIntervalCount() - 1; i >= 0; --i) {
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li == interval) {
                        index = i;
                        continue;
                    }
                    if (li.isEmptySpace()) continue;
                    iDesc.neighbor = li;
                    iDesc.index = index;
                    break;
                }
            } else {
                iDesc.parent = parent;
                iDesc.index = parent.indexOf(interval);
            }
        } else {
            if (parent.isSequential()) {
                parent = parent.getParent();
                nonEmptyCount = LayoutInterval.getCount(parent, Integer.MAX_VALUE, true);
                if (alignment < 0) {
                    alignment = 0;
                }
            } else {
                int currentAlign = interval.getAlignment();
                if (alignment < 0 || currentAlign != 0 && currentAlign != 1) {
                    alignment = currentAlign;
                }
            }
            if (nonEmptyCount <= 2 && parent.getParent() != null) {
                LayoutInterval subGroup = parent;
                if ((parent = parent.getParent()).isSequential()) {
                    boolean ortOverlap = false;
                    Iterator it = parent.getSubIntervals();
                    while (it.hasNext()) {
                        LayoutInterval li = (LayoutInterval)it.next();
                        if (li.isEmptySpace() || li.isParentOf(interval) || !LayoutRegion.overlap(interval.getCurrentSpace(), li.getCurrentSpace(), dimension ^ 1, 0)) continue;
                        ortOverlap = true;
                        break;
                    }
                    if (ortOverlap) {
                        iDesc.newSubGroup = true;
                        iDesc.index = parent.indexOf(subGroup);
                    } else {
                        parent = parent.getParent();
                    }
                }
                iDesc.parent = parent;
            } else {
                iDesc.parent = parent;
            }
        }
        if (alignment == 0 || alignment == 1) {
            iDesc.fixedPosition = LayoutFeeder.isFixedRelativePosition(interval, alignment);
        }
        iDesc.snappedParallel = LayoutFeeder.findAlignedInterval(interval, dimension, alignment);
        if (iDesc.snappedParallel == null && (alignment == 0 || alignment == 1) && (gap = LayoutInterval.getNeighbor(interval, alignment, false, true, false)) != null && LayoutInterval.isFixedDefaultPadding(gap) && ((prev = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true)) == interval || LayoutInterval.isPlacedAtBorder(interval, prev, dimension, alignment))) {
            LayoutInterval next = LayoutInterval.getNeighbor(gap, alignment, true, true, false);
            if (next != null) {
                if (next.getParent() == gap.getParent() || next.getCurrentSpace().positions[dimension][alignment ^ 1] == gap.getParent().getCurrentSpace().positions[dimension][alignment]) {
                    iDesc.snappedNextTo = next;
                }
            } else {
                next = LayoutInterval.getRoot(interval);
                if (LayoutInterval.isPlacedAtBorder(gap.getParent(), next, dimension, alignment)) {
                    iDesc.snappedNextTo = next;
                }
            }
        }
        iDesc.alignment = alignment;
        return iDesc;
    }

    private static boolean isFixedRelativePosition(LayoutInterval interval, int edge) {
        assert (edge == 0 || edge == 1);
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isSequential()) {
            LayoutInterval li = LayoutInterval.getDirectNeighbor(interval, edge, false);
            if (li != null) {
                return !LayoutInterval.wantResize(li);
            }
            interval = parent;
            parent = interval.getParent();
        }
        if (!LayoutInterval.isAlignedAtBorder(interval, parent, edge) && LayoutInterval.contentWantResize(parent)) {
            return false;
        }
        return LayoutFeeder.isFixedRelativePosition(parent, edge);
    }

    private static LayoutInterval findAlignedInterval(LayoutInterval interval, int dimension, int alignment) {
        LayoutInterval neighbor;
        LayoutInterval alignedInterval = null;
        boolean indent = false;
        LayoutInterval parent = interval.getParent();
        if ((alignment == 0 || alignment == 1) && parent.isSequential() && LayoutInterval.getCount(parent, -1, true) == 1 && (neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false)) != null && neighbor.isEmptySpace() && !LayoutInterval.canResize(neighbor) && LayoutInterval.getCount(parent.getParent(), Integer.MAX_VALUE, true) == 2) {
            indent = true;
        }
        do {
            parent = LayoutInterval.getFirstParent(interval, 103);
            if (!indent) {
                boolean aligned;
                boolean bl = alignment == 0 || alignment == 1 ? LayoutInterval.isAlignedAtBorder(interval, parent, alignment) : (aligned = interval.getParent() == parent && interval.getAlignment() == alignment);
                if (!aligned) {
                    return null;
                }
                if (parent.getParent() == null) {
                    return parent;
                }
            }
            Iterator it = parent.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval sub = (LayoutInterval)it.next();
                if (sub.isEmptySpace() || sub == interval || sub.isParentOf(interval)) continue;
                if (alignment == 0 || alignment == 1) {
                    LayoutInterval li = LayoutUtils.getOutermostComponent(sub, dimension, alignment);
                    if (!LayoutInterval.isAlignedAtBorder(li, parent, alignment) && !LayoutInterval.isPlacedAtBorder(li, parent, dimension, alignment)) continue;
                    LayoutInterval p = LayoutInterval.getFirstParent(li, 103);
                    while (p != parent) {
                        li = p;
                        p = LayoutInterval.getFirstParent(li, 103);
                    }
                    alignedInterval = li;
                    break;
                }
                alignedInterval = sub;
                break;
            }
            if (indent) {
                return alignedInterval;
            }
            interval = parent;
        } while (alignedInterval == null);
        return parent.getSubIntervalCount() > 2 ? parent : alignedInterval;
    }

    private static void correctNeighborInSequence(IncludeDesc iDesc) {
        if (iDesc != null && iDesc.neighbor != null && iDesc.neighbor.getParent().isSequential()) {
            assert (iDesc.parent == iDesc.neighbor.getParent().getParent());
            iDesc.parent = iDesc.neighbor.getParent();
            iDesc.neighbor = null;
        }
    }

    private int getDimensionSolvingOverlap(LayoutDragger.PositionDef[] positions) {
        boolean[] overlapDim;
        if (this.dragger.isResizing(0) && !this.dragger.isResizing(1)) {
            return 0;
        }
        if (this.dragger.isResizing(1) && !this.dragger.isResizing(0) || positions[0] != null && positions[0].snapped && (positions[1] == null || !positions[1].snapped) || positions[1] != null && !positions[1].nextTo && positions[1].snapped && positions[1].interval.getParent() == null && !LayoutFeeder.existsComponentPlacedAtBorder(positions[1].interval, 1, positions[1].alignment)) {
            return 1;
        }
        if (positions[1] != null && positions[1].nextTo && positions[1].snapped && positions[1].interval.getParent() == null) {
            int alignment = positions[1].alignment;
            int[][] overlapSides = LayoutFeeder.overlappingGapSides(this.dragger.getTargetContainer().getLayoutRoot(0), this.dragger.getMovingSpace());
            if ((alignment == 0 || alignment == 1) && overlapSides[1][1 - alignment] != 0 && overlapSides[1][alignment] == 0) {
                return 1;
            }
        }
        if (!(positions[0] != null && positions[0].snapped || positions[1] != null && positions[1].snapped || !(overlapDim = LayoutFeeder.overlappingGapDimensions(this.dragger.getTargetContainer().getLayoutRoot(0), this.dragger.getMovingSpace()))[1] || overlapDim[0])) {
            return 1;
        }
        return 0;
    }

    private static boolean existsComponentPlacedAtBorder(LayoutInterval interval, int dimension, int alignment) {
        Iterator iter = interval.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = (LayoutInterval)iter.next();
            if (!LayoutInterval.isPlacedAtBorder(interval, dimension, alignment)) continue;
            if (subInterval.isComponent()) {
                return true;
            }
            if (!subInterval.isGroup() || !LayoutFeeder.existsComponentPlacedAtBorder(subInterval, dimension, alignment)) continue;
            return true;
        }
        return false;
    }

    private static void fillOverlappingComponents(List overlaps, LayoutInterval group, LayoutRegion region) {
        Iterator iter = group.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = (LayoutInterval)iter.next();
            if (subInterval.isGroup()) {
                LayoutFeeder.fillOverlappingComponents(overlaps, subInterval, region);
                continue;
            }
            if (!subInterval.isComponent()) continue;
            LayoutComponent component = subInterval.getComponent();
            LayoutRegion compRegion = subInterval.getCurrentSpace();
            if (!LayoutRegion.overlap(compRegion, region, 0, 0) || !LayoutRegion.overlap(compRegion, region, 1, 0)) continue;
            overlaps.add(component);
        }
    }

    private static boolean[] overlappingGapDimensions(LayoutInterval layoutRoot, LayoutRegion region) {
        boolean[] result = new boolean[2];
        int[][] overlapSides = LayoutFeeder.overlappingGapSides(layoutRoot, region);
        for (int i = 0; i < 2; ++i) {
            result[i] = overlapSides[i][0] == 1 && overlapSides[i][1] == 1;
        }
        return result;
    }

    private static int[][] overlappingGapSides(LayoutInterval layoutRoot, LayoutRegion region) {
        int[][] overlapSides = new int[][]{{0, 0}, {0, 0}};
        LinkedList overlaps = new LinkedList();
        LayoutFeeder.fillOverlappingComponents(overlaps, layoutRoot, region);
        for (LayoutComponent component : overlaps) {
            LayoutRegion compRegion = component.getLayoutInterval(0).getCurrentSpace();
            for (int i = 0; i < 2; ++i) {
                int[] edges = LayoutFeeder.overlappingSides(compRegion, region, i);
                for (int j = 0; j < 2; ++j) {
                    if (edges[j] == 1) {
                        overlapSides[i][j] = 1;
                        continue;
                    }
                    if (edges[j] != -1) continue;
                    if (overlapSides[i][j] == -1) {
                        overlapSides[i][j] = 1;
                        continue;
                    }
                    if (overlapSides[i][j] != 0) continue;
                    overlapSides[i][j] = -1;
                }
            }
        }
        return overlapSides;
    }

    private static int[] overlappingSides(LayoutRegion compRegion, LayoutRegion region, int dimension) {
        int[] sides = new int[2];
        int compLeading = compRegion.positions[dimension][0];
        int compTrailing = compRegion.positions[dimension][1];
        int regLeading = region.positions[dimension][0];
        int regTrailing = region.positions[dimension][1];
        if (regLeading < compTrailing && compTrailing < regTrailing) {
            sides[0] = 1;
        }
        if (regLeading < compLeading && compLeading < regTrailing) {
            sides[1] = 1;
        }
        if (sides[0] == 1 && sides[1] == 1) {
            sides[1] = -1;
            sides[0] = -1;
        }
        return sides;
    }

    private boolean checkResizing() {
        LayoutInterval interval = this.addingIntervals[this.dimension];
        int resizingEdge = this.dragger.getResizingEdge(this.dimension);
        int fixedEdge = resizingEdge ^ 1;
        LayoutDragger.PositionDef newPos = this.newPositions[this.dimension];
        boolean resizing = false;
        if (newPos != null && newPos.snapped && newPos.interval != null) {
            int align2;
            int align1;
            if (newPos.interval.isParentOf(interval)) {
                LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
                if (!LayoutRegion.pointInside(this.dragger.getMovingSpace(), resizingEdge, parent.getCurrentSpace(), this.dimension)) {
                    parent = newPos.interval;
                }
                align1 = LayoutInterval.getEffectiveAlignmentInParent(interval, parent, fixedEdge);
                align2 = resizingEdge;
            } else {
                LayoutInterval parent = LayoutInterval.getCommonParent(interval, newPos.interval);
                align1 = LayoutInterval.getEffectiveAlignmentInParent(interval, parent, fixedEdge);
                int n = align2 = newPos.nextTo ? LayoutInterval.getEffectiveAlignmentInParent(newPos.interval, parent, newPos.alignment ^ 1) : resizingEdge;
            }
            if (!(align1 == align2 || align1 != 0 && align1 != 1 || align2 != 0 && align2 != 1)) {
                resizing = true;
            }
        }
        return resizing;
    }

    private void addSimplyAligned() {
        int alignment = this.aEdge;
        assert (alignment == 2 || alignment == 3);
        this.layoutModel.setIntervalAlignment(this.addingInterval, alignment);
        if (this.aSnappedParallel.isParallel() && this.aSnappedParallel.getGroupAlignment() == alignment) {
            this.layoutModel.addInterval(this.addingInterval, this.aSnappedParallel, -1);
            return;
        }
        LayoutInterval parent = this.aSnappedParallel.getParent();
        if (parent.isParallel() && parent.getGroupAlignment() == alignment) {
            this.layoutModel.addInterval(this.addingInterval, parent, -1);
            return;
        }
        int alignIndex = this.layoutModel.removeInterval(this.aSnappedParallel);
        LayoutInterval subGroup = new LayoutInterval(103);
        subGroup.setGroupAlignment(alignment);
        if (parent.isParallel()) {
            subGroup.setAlignment(this.aSnappedParallel.getAlignment());
        }
        this.layoutModel.setIntervalAlignment(this.aSnappedParallel, alignment);
        this.layoutModel.addInterval(this.aSnappedParallel, subGroup, -1);
        this.layoutModel.addInterval(this.addingInterval, subGroup, -1);
        this.layoutModel.addInterval(subGroup, parent, alignIndex);
    }

    void addInterval(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        int nonEmptyCount;
        this.addToGroup(iDesc1, iDesc2, true);
        if (iDesc1.snappedParallel != null || iDesc2 != null && iDesc2.snappedParallel != null) {
            if (iDesc2 != null && iDesc2.snappedParallel != null) {
                this.alignInParallel(this.addingInterval, iDesc2.snappedParallel, iDesc2.alignment);
            }
            if (iDesc1.snappedParallel != null) {
                this.alignInParallel(this.addingInterval, iDesc1.snappedParallel, iDesc1.alignment);
            }
        }
        this.checkParallelResizing(this.addingInterval, iDesc1, iDesc2);
        LayoutInterval parent = this.addingInterval.getParent();
        int accAlign = -1;
        if (parent.isSequential()) {
            int tryAlign;
            int n = tryAlign = parent.getAlignment() != 1 ? 1 : 0;
            if (LayoutInterval.getDirectNeighbor(this.addingInterval, tryAlign, true) == null) {
                accAlign = tryAlign;
            } else if (LayoutInterval.getDirectNeighbor(this.addingInterval, tryAlign ^= 1, true) == null) {
                accAlign = tryAlign;
            }
        } else {
            accAlign = this.addingInterval.getAlignment() ^ 1;
        }
        if (accAlign != -1) {
            this.accommodateOutPosition(this.addingInterval, accAlign);
        }
        if (this.dragger.isResizing(this.dimension) && LayoutInterval.wantResize(this.addingInterval)) {
            this.operations.suppressResizingOfSurroundingGaps(this.addingInterval);
        }
        this.operations.optimizeGaps(LayoutInterval.getFirstParent(this.addingInterval, 103), this.dimension);
        parent = this.addingInterval.getParent();
        if (parent.isSequential() && (nonEmptyCount = LayoutInterval.getCount(parent, Integer.MAX_VALUE, true)) > 1 && this.dimension == 0) {
            this.operations.moveInsideSequential(parent, this.dimension);
        }
        this.operations.mergeParallelGroups(LayoutInterval.getFirstParent(this.addingInterval, 103));
    }

    private void addToGroup(IncludeDesc iDesc1, IncludeDesc iDesc2, boolean definite) {
        assert (iDesc2 == null || iDesc1.parent == iDesc2.parent && iDesc1.newSubGroup == iDesc2.newSubGroup && iDesc1.neighbor == iDesc2.neighbor);
        LayoutInterval parent = iDesc1.parent;
        LayoutInterval seq = null;
        int index = 0;
        if (parent.isSequential()) {
            LayoutRegion space;
            LayoutInterval subgroup;
            if (iDesc1.newSubGroup && (subgroup = this.extractParallelSequence(parent, space = this.addingSpace, false, iDesc1.alignment)) != null) {
                seq = new LayoutInterval(102);
                parent = subgroup;
            }
            if (seq == null) {
                seq = parent;
                parent = seq.getParent();
                index = iDesc1.index;
            }
        } else {
            LayoutInterval neighbor = iDesc1.neighbor;
            if (neighbor != null) {
                assert (neighbor.getParent() == parent);
                seq = new LayoutInterval(102);
                this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(neighbor));
                seq.setAlignment(neighbor.getAlignment());
                this.layoutModel.setIntervalAlignment(neighbor, -1);
                this.layoutModel.addInterval(neighbor, seq, 0);
                index = iDesc1.index;
            } else {
                seq = new LayoutInterval(102);
                seq.setAlignment(iDesc1.alignment);
            }
        }
        assert (iDesc1.alignment >= 0 || iDesc2 == null);
        assert (iDesc2 == null || iDesc2.alignment == (iDesc1.alignment ^ 1));
        assert (parent.isParallel());
        LayoutInterval[] neighbors = new LayoutInterval[2];
        LayoutInterval[] gaps = new LayoutInterval[2];
        LayoutInterval originalGap = null;
        int[] centerDst = new int[2];
        int count = seq.getSubIntervalCount();
        if (index > count) {
            index = count;
        }
        for (int i = 0; i <= 1; ++i) {
            int idx2;
            int idx1 = i == 0 ? index - 1 : index;
            int n = idx2 = i == 0 ? index - 2 : index + 1;
            if (idx1 >= 0 && idx1 < count) {
                LayoutInterval li = seq.getSubInterval(idx1);
                if (li.isEmptySpace()) {
                    originalGap = li;
                    if (idx2 >= 0 && idx2 < count) {
                        neighbors[i] = seq.getSubInterval(idx2);
                    }
                } else {
                    neighbors[i] = li;
                }
            }
            if (iDesc1.alignment >= 0) continue;
            centerDst[i] = this.addingSpace.positions[this.dimension][2] - (neighbors[i] != null ? LayoutFeeder.getPerceivedNeighborPosition(neighbors[i], this.addingSpace, this.dimension, i ^ 1) : LayoutFeeder.getPerceivedParentPosition(seq, parent, this.addingSpace, this.dimension, i));
            if (i != 1) continue;
            int n2 = i;
            centerDst[n2] = centerDst[n2] * -1;
        }
        int i = 0;
        for (int edges = 2; edges > 0; --edges) {
            block43: {
                boolean fixedGap;
                boolean minorGap;
                boolean aligned;
                IncludeDesc iiDesc;
                block44: {
                    LayoutInterval parallel;
                    gaps[i] = null;
                    LayoutInterval outerNeighbor = neighbors[i] == null ? LayoutInterval.getNeighbor(parent, i, false, true, false) : null;
                    IncludeDesc includeDesc = iiDesc = iDesc1.alignment < 0 || iDesc1.alignment == i ? iDesc1 : iDesc2;
                    if (neighbors[i] == null && iiDesc != null && (iiDesc.snappedNextTo != null && outerNeighbor != null && LayoutInterval.isDefaultPadding(outerNeighbor) || iiDesc.snappedParallel != null && (!seq.isParentOf(iiDesc.snappedParallel) || originalGap == null))) break block43;
                    aligned = iDesc1.alignment < 0 ? centerDst[i] < centerDst[i ^ 1] || centerDst[i] == centerDst[i ^ 1] && i == 0 : (iDesc2 != null ? iiDesc.fixedPosition || i == 0 && this.originalLPosFixed || i == 1 && this.originalTPosFixed : (iDesc1.snappedParallel == null || !seq.isParentOf(iDesc1.snappedParallel) ? i == iDesc1.alignment : i == (iDesc1.alignment ^ 1)));
                    minorGap = false;
                    if (aligned || neighbors[i] != null || originalGap != null) break block44;
                    IncludeDesc otherDesc = iiDesc == iDesc1 ? iDesc2 : iDesc1;
                    LayoutInterval layoutInterval = parallel = otherDesc != null ? otherDesc.snappedParallel : null;
                    if (parallel == null && seq.getSubIntervalCount() == 0 && seq.getAlignment() != (i ^ 1)) {
                        this.layoutModel.setIntervalAlignment(seq, i ^ 1);
                    }
                    if (outerNeighbor != null && outerNeighbor.isEmptySpace()) break block43;
                    boolean bl = minorGap = parallel != null && parallel.getParent() != null || parent.getParent() != null && LayoutInterval.getCount(parent, i ^ 1, true) > 0;
                }
                if (!(fixedGap = aligned)) {
                    if (minorGap || LayoutInterval.wantResize(this.addingInterval)) {
                        fixedGap = true;
                    } else if (originalGap != null && !LayoutInterval.canResize(originalGap)) {
                        IncludeDesc otherDesc;
                        IncludeDesc includeDesc = otherDesc = iiDesc == iDesc1 ? iDesc2 : iDesc1;
                        if (otherDesc == null || otherDesc.snappedParallel == null || neighbors[i] == null || LayoutInterval.getEffectiveAlignment(neighbors[i], i ^ 1) == (i ^ 1)) {
                            fixedGap = true;
                        }
                    } else if (originalGap == null && (neighbors[i] != null && LayoutInterval.getEffectiveAlignment(neighbors[i], i ^ 1) == (i ^ 1) || LayoutInterval.wantResize(seq))) {
                        fixedGap = true;
                    }
                }
                LayoutInterval gap = new LayoutInterval(101);
                if (!(minorGap || iiDesc != null && iiDesc.snappedNextTo != null)) {
                    int distance;
                    LayoutRegion space = iiDesc != null && iiDesc.snappedParallel != null ? iiDesc.snappedParallel.getCurrentSpace() : this.addingSpace;
                    int n = distance = neighbors[i] != null ? LayoutRegion.distance(neighbors[i].getCurrentSpace(), space, this.dimension, i ^ 1, i) : LayoutRegion.distance(parent.getCurrentSpace(), space, this.dimension, i, i);
                    if (i == 1) {
                        distance *= -1;
                    }
                    if (distance > 0) {
                        int pad;
                        int n3 = pad = neighbors[i] != null || LayoutInterval.getNeighbor(parent, i, false, true, false) == null ? this.determineExpectingPadding(this.addingInterval, neighbors[i], seq, i) : Short.MIN_VALUE;
                        if (distance > pad || fixedGap && distance != pad) {
                            gap.setPreferredSize(distance);
                            if (fixedGap) {
                                gap.setMinimumSize(-2);
                                gap.setMaximumSize(-2);
                            }
                        }
                    }
                }
                if (!fixedGap) {
                    IncludeDesc otherDesc;
                    gap.setMaximumSize(Short.MAX_VALUE);
                    IncludeDesc includeDesc = otherDesc = iiDesc == iDesc1 ? iDesc2 : iDesc1;
                    if (definite && neighbors[i] != null && parent.getParent() != null && (otherDesc == null || otherDesc.alignment == -1) && !LayoutFeeder.isSignificantGroupEdge(seq, i ^ 1)) {
                        parent = this.separateSequence(seq, i ^ 1);
                        if (i == 1) {
                            ++edges;
                        }
                    }
                }
                gaps[i] = gap;
            }
            i ^= 1;
        }
        if (seq.getParent() == null) {
            assert (seq.getSubIntervalCount() == 0);
            if (gaps[0] == null && gaps[1] == null) {
                this.layoutModel.setIntervalAlignment(this.addingInterval, seq.getAlignment());
                this.layoutModel.addInterval(this.addingInterval, parent, -1);
                return;
            }
            this.layoutModel.addInterval(seq, parent, -1);
        }
        if (iDesc1.snappedParallel != null && seq.isParentOf(iDesc1.snappedParallel)) {
            iDesc1.snappedParallel = null;
        }
        index = originalGap != null ? this.layoutModel.removeInterval(originalGap) : (neighbors[1] != null ? seq.indexOf(neighbors[1]) : (neighbors[0] != null ? seq.getSubIntervalCount() : 0));
        if (gaps[0] != null) {
            this.layoutModel.addInterval(gaps[0], seq, index++);
        }
        this.layoutModel.setIntervalAlignment(this.addingInterval, -1);
        this.layoutModel.addInterval(this.addingInterval, seq, index++);
        if (gaps[1] != null) {
            this.layoutModel.addInterval(gaps[1], seq, index);
        }
    }

    private LayoutInterval extractParallelSequence(LayoutInterval seq, LayoutRegion space, boolean close, int alignment) {
        LayoutInterval li;
        int count = seq.getSubIntervalCount();
        int startIndex = 0;
        int endIndex = count - 1;
        int startPos = seq.getCurrentSpace().positions[this.dimension][0];
        int endPos = seq.getCurrentSpace().positions[this.dimension][1];
        int point = alignment < 0 ? 2 : alignment;
        for (int i = 0; i < count; ++i) {
            boolean forcedParallel;
            li = seq.getSubInterval(i);
            if (li.isEmptySpace()) continue;
            LayoutRegion subSpace = li.getCurrentSpace();
            boolean bl = forcedParallel = !this.solveOverlap && LayoutUtils.contentOverlap(space, li, this.dimension);
            if (!forcedParallel && LayoutUtils.contentOverlap(space, li, this.dimension ^ 1)) {
                if (LayoutFeeder.getAddDirection(space, subSpace, this.dimension, point) == 0) {
                    endIndex = i - 1;
                    endPos = subSpace.positions[this.dimension][0];
                    break;
                }
                startIndex = i + 1;
                startPos = subSpace.positions[this.dimension][1];
                continue;
            }
            if (!close) continue;
            int[] detPos = space.positions[this.dimension];
            int[] subPos = subSpace.positions[this.dimension];
            if (detPos[0] >= subPos[1]) {
                startIndex = i + 1;
                startPos = subPos[1];
                continue;
            }
            if (detPos[0] >= subPos[0]) {
                startIndex = i;
                startPos = subPos[0];
                continue;
            }
            if (detPos[1] > subPos[1]) continue;
            if (detPos[1] > subPos[0]) {
                endIndex = i;
                endPos = subPos[1];
                break;
            }
            endIndex = i - 1;
            endPos = subPos[0];
            break;
        }
        if (startIndex > endIndex) {
            return null;
        }
        if (startIndex == 0 && endIndex == count - 1) {
            return seq.getParent();
        }
        LayoutInterval group = new LayoutInterval(103);
        if (alignment != -1) {
            group.setGroupAlignment(alignment);
        }
        if (startIndex == endIndex) {
            li = this.layoutModel.removeInterval(seq, startIndex);
            this.layoutModel.addInterval(li, group, 0);
        } else {
            LayoutInterval interSeq = new LayoutInterval(102);
            group.add(interSeq, 0);
            int i = startIndex;
            while (i <= endIndex) {
                LayoutInterval li2 = this.layoutModel.removeInterval(seq, i);
                --endIndex;
                this.layoutModel.addInterval(li2, interSeq, -1);
            }
        }
        this.layoutModel.addInterval(group, seq, startIndex);
        group.getCurrentSpace().set(this.dimension, startPos, endPos);
        return group;
    }

    private static int getPerceivedParentPosition(LayoutInterval interval, LayoutInterval parent, LayoutRegion space, int dimension, int alignment) {
        int position = Integer.MIN_VALUE;
        do {
            if (parent.isSequential()) {
                interval = parent;
                parent = interval.getParent();
            }
            LayoutInterval neighbor = null;
            while (neighbor == null && parent.getParent() != null) {
                boolean significantEdge;
                boolean bl = significantEdge = interval.getParent() != null ? LayoutFeeder.isSignificantGroupEdge(interval, alignment) : LayoutInterval.isClosedGroup(parent, alignment);
                if (significantEdge) break;
                neighbor = LayoutInterval.getDirectNeighbor(parent, alignment, true);
                if (neighbor != null || !(parent = (interval = parent).getParent()).isSequential()) continue;
                interval = parent;
                parent = interval.getParent();
            }
            if (neighbor == null) {
                position = parent.getCurrentSpace().positions[dimension][alignment];
                continue;
            }
            while ((position = LayoutFeeder.getPerceivedNeighborPosition(neighbor, space, dimension, alignment ^ 1)) == Integer.MIN_VALUE && (neighbor = LayoutInterval.getDirectNeighbor(neighbor, alignment, true)) != null) {
            }
            if (neighbor != null) continue;
            interval = parent;
            parent = interval.getParent();
        } while (position == Integer.MIN_VALUE);
        return position;
    }

    private static boolean isSignificantGroupEdge(LayoutInterval interval, int alignment) {
        LayoutInterval neighborGap;
        LayoutInterval group = interval.getParent();
        assert (group.isParallel());
        if (interval.getAlignment() == alignment || LayoutInterval.wantResize(interval)) {
            return true;
        }
        if (!LayoutInterval.isClosedGroup(group, alignment)) {
            return false;
        }
        return LayoutInterval.isExplicitlyClosedGroup(group) || (neighborGap = LayoutInterval.getNeighbor(group, alignment, false, true, true)) == null || !LayoutInterval.isDefaultPadding(neighborGap);
    }

    private static int getPerceivedNeighborPosition(LayoutInterval neighbor, LayoutRegion space, int dimension, int alignment) {
        int i;
        int d;
        assert (!neighbor.isEmptySpace());
        if (neighbor.isComponent()) {
            return neighbor.getCurrentSpace().positions[dimension][alignment];
        }
        int neighborPos = Integer.MIN_VALUE;
        int n = neighbor.getSubIntervalCount();
        if (neighbor.isParallel() || alignment == 0) {
            d = 1;
            i = 0;
        } else {
            d = -1;
            i = n - 1;
        }
        while (i >= 0 && i < n) {
            int pos;
            LayoutInterval sub = neighbor.getSubInterval(i);
            i += d;
            if (sub.isEmptySpace() || sub.isComponent() && !LayoutRegion.overlap(space, sub.getCurrentSpace(), dimension ^ 1, 0) || (pos = LayoutFeeder.getPerceivedNeighborPosition(sub, space, dimension, alignment)) == Integer.MIN_VALUE) continue;
            if (neighbor.isSequential()) {
                neighborPos = pos;
                break;
            }
            if (neighborPos != Integer.MIN_VALUE && pos * d >= neighborPos * d) continue;
            neighborPos = pos;
        }
        return neighborPos;
    }

    private LayoutInterval separateSequence(LayoutInterval seq, int alignment) {
        LayoutInterval sub;
        int end;
        LayoutInterval parentPar = seq.getParent();
        assert (parentPar.isParallel());
        while (!parentPar.getParent().isSequential()) {
            parentPar = parentPar.getParent();
        }
        LayoutInterval parentSeq = parentPar.getParent();
        int d = alignment == 0 ? -1 : 1;
        int n = parentSeq.getSubIntervalCount();
        for (end = parentSeq.indexOf(parentPar) + d; end >= 0 && end < n && ((sub = parentSeq.getSubInterval(end)).isEmptySpace() || !LayoutUtils.contentOverlap(this.addingSpace, sub, this.dimension ^ 1)); end += d) {
        }
        int endPos = end >= 0 && end < n ? parentSeq.getSubInterval((int)end).getCurrentSpace().positions[this.dimension][alignment ^ 1] : parentSeq.getParent().getCurrentSpace().positions[this.dimension][alignment];
        this.operations.parallelizeWithParentSequence(seq, end -= d, this.dimension);
        parentPar = seq.getParent();
        parentPar.getCurrentSpace().positions[this.dimension][alignment] = endPos;
        return parentPar;
    }

    private void accommodateOutPosition(LayoutInterval interval, int alignment) {
        if (alignment == 2 || alignment == 3) {
            return;
        }
        int pos = interval.getCurrentSpace().positions[this.dimension][alignment];
        assert (pos != Integer.MIN_VALUE);
        int sizeIncrement = Integer.MIN_VALUE;
        int d = alignment == 0 ? -1 : 1;
        int[] groupPos = null;
        LayoutInterval parent = interval.getParent();
        LayoutInterval prev = null;
        do {
            if (parent.isSequential()) {
                LayoutInterval neighbor;
                if (sizeIncrement > 0) {
                    int accommodated = this.accommodateSizeInSequence(interval, prev, sizeIncrement, alignment);
                    sizeIncrement -= accommodated;
                    if (groupPos != null) {
                        int n = alignment;
                        groupPos[n] = groupPos[n] + accommodated * d;
                    }
                }
                if ((neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false)) != null && (!neighbor.isEmptySpace() || LayoutInterval.canResize(neighbor))) {
                    return;
                }
                prev = interval;
            } else {
                groupPos = parent.getCurrentSpace().positions[this.dimension];
                if (groupPos[alignment] != Integer.MIN_VALUE) {
                    sizeIncrement = (pos - groupPos[alignment]) * d;
                    if (sizeIncrement > 0) {
                        int[] subPos = interval.getCurrentSpace().positions[this.dimension];
                        if (!interval.getCurrentSpace().isSet(this.dimension) || subPos[alignment] * d < groupPos[alignment] * d) {
                            subPos[alignment] = groupPos[alignment];
                        }
                    }
                } else {
                    groupPos = null;
                }
                if (!interval.isSequential()) {
                    prev = interval;
                }
            }
            interval = parent;
            parent = interval.getParent();
        } while ((sizeIncrement > 0 || sizeIncrement == Integer.MIN_VALUE) && parent != null && (!parent.isParallel() || interval.getAlignment() != alignment));
    }

    private int accommodateSizeInSequence(LayoutInterval interval, LayoutInterval lower, int sizeIncrement, int alignment) {
        LayoutInterval parent = interval.getParent();
        assert (parent.isSequential());
        LayoutRegion space = lower.getCurrentSpace();
        int increment = sizeIncrement;
        int pos = interval.getCurrentSpace().positions[this.dimension][alignment];
        int outPos = parent.getParent().getCurrentSpace().positions[this.dimension][alignment];
        boolean parallel = false;
        int d = alignment == 0 ? -1 : 1;
        int start = parent.indexOf(interval);
        int end = lower.isComponent() ? start : -1;
        int n = parent.getSubIntervalCount();
        for (int i = start + d; i >= 0 && i < n; i += d) {
            LayoutInterval li = parent.getSubInterval(i);
            if (end != -1) {
                int endPos = Integer.MIN_VALUE;
                if (!li.isEmptySpace()) {
                    if (LayoutUtils.contentOverlap(space, li, this.dimension ^ 1)) {
                        if (end != start) {
                            end = i - d;
                            endPos = li.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                        } else {
                            end = -1;
                        }
                    } else {
                        end = i;
                        if (!parallel && LayoutUtils.contentOverlap(space, li, this.dimension)) {
                            parallel = true;
                        }
                    }
                }
                if ((i == 0 || i + d == n) && endPos == Integer.MIN_VALUE && end != -1) {
                    if (end != start && (parallel || this.dimension == 0)) {
                        end = i;
                        endPos = outPos;
                    } else {
                        end = -1;
                    }
                }
                if (endPos != Integer.MIN_VALUE) {
                    LayoutInterval toPar = lower.getParent().isSequential() ? lower.getParent() : lower;
                    LayoutInterval endGap = LayoutInterval.getDirectNeighbor(lower, alignment, false);
                    if (endGap == null && !LayoutInterval.isAlignedAtBorder(toPar, alignment)) {
                        endGap = new LayoutInterval(101);
                        if (!toPar.isSequential()) {
                            toPar = new LayoutInterval(102);
                            this.layoutModel.addInterval(toPar, lower.getParent(), this.layoutModel.removeInterval(lower));
                            this.layoutModel.setIntervalAlignment(toPar, lower.getRawAlignment());
                            this.layoutModel.setIntervalAlignment(lower, -1);
                            this.layoutModel.addInterval(lower, toPar, 0);
                        }
                        this.layoutModel.addInterval(endGap, toPar, alignment == 0 ? 0 : -1);
                    } else assert (endGap == null || endGap.isEmptySpace());
                    this.operations.parallelizeWithParentSequence(toPar, end, this.dimension);
                    if (alignment == 1) {
                        i -= n - parent.getSubIntervalCount();
                    }
                    n = parent.getSubIntervalCount();
                    end = -1;
                    if ((increment -= Math.abs(endPos - pos)) >= 0) continue;
                    increment = 0;
                    continue;
                }
                if (end != -1) continue;
                i = start;
                continue;
            }
            if (li.isEmptySpace() && li.getPreferredSize() != -1) {
                int pad = this.determinePadding(interval, this.dimension, alignment);
                int currentSize = LayoutInterval.getIntervalCurrentSize(li, this.dimension);
                int size = currentSize - increment;
                if (size <= pad) {
                    size = -1;
                    increment -= currentSize - pad;
                } else {
                    increment = 0;
                }
                this.operations.resizeInterval(li, size);
                if (!LayoutInterval.wantResize(li) || !LayoutInterval.wantResize(interval)) break;
                this.layoutModel.setIntervalSize(li, li.getMinimumSize(), li.getPreferredSize(), -2);
                break;
            }
            interval = li;
        }
        return sizeIncrement - increment;
    }

    private LayoutInterval alignInParallel(LayoutInterval interval, LayoutInterval toAlignWith, int alignment) {
        LayoutInterval aligning1;
        LayoutInterval commonSeq;
        LayoutInterval group;
        LayoutInterval alignParent;
        assert (alignment == 0 || alignment == 1);
        if (toAlignWith.isParentOf(interval) || interval.isParentOf(toAlignWith)) {
            return null;
        }
        LayoutInterval commonParent = LayoutInterval.getCommonParent(interval, toAlignWith);
        if (commonParent == null || commonParent.isSequential()) {
            return null;
        }
        boolean resizing = LayoutInterval.wantResize(interval);
        LayoutInterval aligning = interval;
        LayoutInterval parParent = LayoutInterval.getFirstParent(interval, 103);
        while (!parParent.isParentOf(toAlignWith)) {
            if (LayoutInterval.isAlignedAtBorder(aligning, parParent, alignment)) {
                if (resizing && !LayoutInterval.canResize(parParent)) {
                    this.operations.enableGroupResizing(parParent);
                }
                aligning = parParent;
                parParent = LayoutInterval.getFirstParent(aligning, 103);
            } else {
                parParent = null;
            }
            if (parParent != null) continue;
            return null;
        }
        boolean resizingOp = this.dragger.isResizing(this.dimension);
        LayoutInterval tempRemoved = aligning;
        while (tempRemoved.getParent() != parParent) {
            tempRemoved = tempRemoved.getParent();
        }
        int removedIndex = parParent.remove(tempRemoved);
        boolean alignWithParent = false;
        do {
            if ((alignParent = LayoutInterval.getFirstParent(toAlignWith, 103)) == null) {
                return null;
            }
            if (!LayoutFeeder.canSubstAlignWithParent(toAlignWith, this.dimension, alignment, resizingOp)) continue;
            if (alignParent == parParent) {
                alignWithParent = true;
                continue;
            }
            toAlignWith = alignParent;
        } while (toAlignWith == alignParent);
        parParent.add(tempRemoved, removedIndex);
        if (alignParent != parParent) {
            return null;
        }
        if (aligning != interval) {
            int dst;
            if (!LayoutInterval.isAlignedAtBorder(toAlignWith, alignment) && (dst = LayoutRegion.distance(aligning.getCurrentSpace(), toAlignWith.getCurrentSpace(), this.dimension, alignment, alignment) * (alignment == 1 ? -1 : 1)) > 0) {
                tempRemoved = interval;
                while (tempRemoved.getParent() != aligning) {
                    tempRemoved = tempRemoved.getParent();
                }
                removedIndex = aligning.remove(tempRemoved);
                this.operations.cutStartingGap(aligning, dst, this.dimension, alignment);
                aligning.add(tempRemoved, removedIndex);
            }
            this.optimizeStructure = true;
        }
        int effAlign1 = LayoutInterval.getEffectiveAlignment(toAlignWith, alignment);
        ArrayList<LayoutInterval> alignedList = new ArrayList<LayoutInterval>(2);
        ArrayList remainder = new ArrayList(2);
        int originalCount = parParent.getSubIntervalCount();
        int extAlign1 = this.extract(toAlignWith, alignedList, remainder, alignment);
        this.extract(aligning, alignedList, remainder, alignment);
        assert (!alignWithParent || remainder.isEmpty());
        int indent = LayoutRegion.distance(toAlignWith.getCurrentSpace(), interval.getCurrentSpace(), this.dimension, alignment, alignment);
        assert (indent == 0 || alignment == 0);
        if (indent != 0) {
            LayoutInterval indentGap = new LayoutInterval(101);
            indentGap.setSize(Math.abs(indent));
            LayoutInterval parent = interval.getParent();
            if (parent == null || !parent.isSequential()) {
                LayoutInterval seq = new LayoutInterval(102);
                if (parent != null) {
                    this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(interval));
                }
                this.layoutModel.setIntervalAlignment(interval, -1);
                this.layoutModel.addInterval(interval, seq, 0);
                parent = seq;
            }
            this.layoutModel.addInterval(indentGap, parent, alignment == 0 ? 0 : -1);
            if (interval == aligning) {
                alignedList.set(alignedList.size() - 1, parent);
            }
        }
        if (alignWithParent || originalCount == 2 && parParent.getParent() != null) {
            group = parParent;
            if (!remainder.isEmpty()) {
                LayoutInterval groupParent = group.getParent();
                if (groupParent.isSequential()) {
                    commonSeq = groupParent;
                } else {
                    int index = this.layoutModel.removeInterval(group);
                    commonSeq = new LayoutInterval(102);
                    commonSeq.setAlignment(group.getAlignment());
                    this.layoutModel.addInterval(commonSeq, groupParent, index);
                    this.layoutModel.setIntervalAlignment(group, -1);
                    this.layoutModel.addInterval(group, commonSeq, -1);
                }
            } else {
                commonSeq = null;
            }
        } else {
            group = new LayoutInterval(103);
            group.setGroupAlignment(alignment);
            if (!remainder.isEmpty()) {
                commonSeq = new LayoutInterval(102);
                commonSeq.add(group, 0);
                if (effAlign1 == 0 || effAlign1 == 1) {
                    commonSeq.setAlignment(effAlign1);
                }
                this.layoutModel.addInterval(commonSeq, parParent, -1);
            } else {
                commonSeq = null;
                if (effAlign1 == 0 || effAlign1 == 1) {
                    group.setAlignment(effAlign1);
                }
                this.layoutModel.addInterval(group, parParent, -1);
            }
            if (alignment == 0 || alignment == 1) {
                int alignPos = toAlignWith.getCurrentSpace().positions[this.dimension][alignment];
                int outerPos = parParent.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                group.getCurrentSpace().set(this.dimension, alignment == 0 ? alignPos : outerPos, alignment == 0 ? outerPos : alignPos);
            }
        }
        LayoutInterval aligning2 = (LayoutInterval)alignedList.get(1);
        if (aligning2.getParent() != group) {
            if (aligning2.getParent() != null) {
                this.layoutModel.removeInterval(aligning2);
            }
            this.layoutModel.addInterval(aligning2, group, -1);
        }
        if (!LayoutInterval.isAlignedAtBorder(aligning2, alignment)) {
            this.layoutModel.setIntervalAlignment(aligning2, alignment);
        }
        if ((aligning1 = (LayoutInterval)alignedList.get(0)).getParent() != group) {
            if (aligning1.getParent() != null) {
                this.layoutModel.setIntervalAlignment(aligning1, extAlign1);
                this.layoutModel.removeInterval(aligning1);
            }
            this.layoutModel.addInterval(aligning1, group, -1);
        }
        if (!(resizingOp || group.getSubIntervalCount() != 2 || LayoutInterval.isAlignedAtBorder(aligning1, alignment) || LayoutInterval.isAlignedAtBorder(aligning2, alignment ^ 1))) {
            this.layoutModel.setIntervalAlignment(aligning1, alignment);
        }
        if (!remainder.isEmpty()) {
            LayoutInterval sideGroup;
            int index = commonSeq.indexOf(group);
            if (alignment == 1) {
                ++index;
            }
            if ((sideGroup = this.operations.addGroupContent(remainder, commonSeq, index, this.dimension, alignment)) != null) {
                int pos1 = parParent.getCurrentSpace().positions[this.dimension][alignment];
                int pos2 = toAlignWith.getCurrentSpace().positions[this.dimension][alignment];
                sideGroup.getCurrentSpace().set(this.dimension, alignment == 0 ? pos1 : pos2, alignment == 0 ? pos2 : pos1);
                this.operations.optimizeGaps(sideGroup, this.dimension);
                this.operations.mergeParallelGroups(sideGroup);
            }
        }
        return group;
    }

    private int extract(LayoutInterval interval, List toAlign, List toRemain, int alignment) {
        int effAlign = LayoutInterval.getEffectiveAlignment(interval, alignment);
        LayoutInterval parent = interval.getParent();
        if (parent.isSequential()) {
            int extractCount = this.operations.extract(interval, alignment, false, alignment == 0 ? toRemain : null, alignment == 0 ? null : toRemain);
            if (extractCount == 1) {
                if (effAlign == 0 || effAlign == 1) {
                    this.layoutModel.setIntervalAlignment(interval, effAlign);
                }
                this.layoutModel.removeInterval(parent);
                toAlign.add(interval);
            } else {
                toAlign.add(parent);
            }
        } else {
            toAlign.add(interval);
        }
        return effAlign;
    }

    private void checkParallelResizing(LayoutInterval interval, IncludeDesc iDesc1, IncludeDesc iDesc2) {
        LayoutInterval parallelInt;
        LayoutInterval group = interval.getParent();
        if (group.isSequential()) {
            parallelInt = group;
            group = group.getParent();
        } else {
            parallelInt = interval;
        }
        if (group.getParent() == null) {
            return;
        }
        int rootAlign = -1;
        if (iDesc1.snappedNextTo != null && iDesc1.snappedNextTo.getParent() == null) {
            rootAlign = iDesc1.alignment;
        }
        if (iDesc2 != null && iDesc2.snappedNextTo != null && iDesc2.snappedNextTo.getParent() == null) {
            int n = rootAlign = rootAlign == -1 ? iDesc2.alignment : Integer.MAX_VALUE;
        }
        if (rootAlign == 0 || rootAlign == 1) {
            int remIdx = group.remove(parallelInt);
            LayoutInterval neighbor = LayoutInterval.getNeighbor(group, rootAlign ^ 1, false, true, true);
            if (neighbor != null && neighbor.getPreferredSize() == -1 && LayoutInterval.isAlignedAtBorder(neighbor.getParent(), LayoutInterval.getRoot(neighbor), rootAlign ^ 1) || neighbor == null && LayoutInterval.isAlignedAtBorder(group, LayoutInterval.getRoot(group), rootAlign ^ 1)) {
                rootAlign = Integer.MAX_VALUE;
            }
            group.add(parallelInt, remIdx);
        }
        if (rootAlign == Integer.MAX_VALUE) {
            return;
        }
        LayoutInterval neighborGap = null;
        if (interval != parallelInt) {
            assert (parallelInt.isSequential());
            for (int i = 0; i <= 1; ++i) {
                LayoutInterval gap = LayoutInterval.getDirectNeighbor(interval, i, false);
                if (gap == null || !gap.isEmptySpace() || !LayoutInterval.canResize(gap)) continue;
                neighborGap = gap;
                break;
            }
        }
        if (LayoutInterval.wantResize(interval) ? !this.dragger.isResizing(this.dimension) : neighborGap == null) {
            return;
        }
        if (!LayoutInterval.canResize(group) && (iDesc1.snappedNextTo != null && !group.isParentOf(iDesc1.snappedNextTo) || iDesc2 != null && iDesc2.snappedNextTo != null && !group.isParentOf(iDesc2.snappedNextTo))) {
            this.operations.enableGroupResizing(group);
        }
        if (LayoutInterval.canResize(group) && group.getParent() != null) {
            boolean contentResizing = false;
            boolean samePosition = false;
            Iterator it = group.getSubIntervals();
            while (it.hasNext()) {
                int align;
                LayoutInterval li = (LayoutInterval)it.next();
                if (li == parallelInt) continue;
                if (LayoutInterval.wantResize(li)) {
                    contentResizing = true;
                    break;
                }
                if (samePosition || (align = li.getAlignment()) != 0 && align != 1) continue;
                samePosition = this.getExpectedBorderPosition(parallelInt, this.dimension, align ^ 1) == this.getExpectedBorderPosition(li, this.dimension, align ^ 1);
            }
            if (!contentResizing && samePosition) {
                this.operations.suppressGroupResizing(group);
            }
        }
        if (!LayoutInterval.canResize(group)) {
            this.layoutModel.changeIntervalAttribute(parallelInt, 1, true);
            if (neighborGap != null) {
                this.layoutModel.setIntervalSize(neighborGap, -1, -1, Short.MAX_VALUE);
            } else if (interval.isComponent()) {
                int pref;
                LayoutComponent lc = interval.getComponent();
                Dimension sizeLimit = lc.isLayoutContainer() ? this.operations.getMapper().getComponentMinimumSize(lc.getId()) : this.operations.getMapper().getComponentPreferredSize(lc.getId());
                int n = pref = this.dimension == 0 ? sizeLimit.width : sizeLimit.height;
                if (interval.getPreferredSize() < pref) {
                    this.layoutModel.setIntervalSize(interval, 0, 0, interval.getMaximumSize());
                } else {
                    this.layoutModel.setIntervalSize(interval, interval.getMinimumSize() != -2 ? interval.getMinimumSize() : -1, -1, interval.getMaximumSize());
                }
            }
        }
        if (interval.isComponent() && neighborGap == null && (parallelInt == interval || LayoutInterval.getCount(parallelInt, -1, true) == 1)) {
            this.setParallelSameSize(group, parallelInt, this.dimension);
        }
    }

    private void setParallelSameSize(LayoutInterval group, LayoutInterval aligned, int dimension) {
        LayoutInterval alignedComp = LayoutFeeder.getOneNonEmpty(aligned);
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = (LayoutInterval)it.next();
            if (li == aligned) continue;
            if (li.isParallel()) {
                this.setParallelSameSize(li, alignedComp, dimension);
                continue;
            }
            LayoutInterval sub = LayoutFeeder.getOneNonEmpty(li);
            if (sub == null || !LayoutRegion.sameSpace(alignedComp.getCurrentSpace(), sub.getCurrentSpace(), dimension) || LayoutInterval.wantResize(li)) continue;
            if (sub.isParallel()) {
                this.setParallelSameSize(sub, alignedComp, dimension);
                continue;
            }
            this.layoutModel.setIntervalAlignment(li, aligned.getAlignment());
            int min = sub.getMinimumSize();
            this.layoutModel.setIntervalSize(sub, sub.getMinimumSize() != -2 ? sub.getMinimumSize() : -1, sub.getPreferredSize(), Short.MAX_VALUE);
            this.layoutModel.changeIntervalAttribute(sub, 1, true);
        }
    }

    private static LayoutInterval getOneNonEmpty(LayoutInterval interval) {
        if (!interval.isSequential()) {
            return interval;
        }
        LayoutInterval nonEmpty = null;
        Iterator it = interval.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = (LayoutInterval)it.next();
            if (li.isEmptySpace()) continue;
            if (nonEmpty == null) {
                nonEmpty = li;
                continue;
            }
            return null;
        }
        return nonEmpty;
    }

    private int getExpectedBorderPosition(LayoutInterval interval, int dimension, int alignment) {
        LayoutInterval comp = LayoutUtils.getOutermostComponent(interval, dimension, alignment);
        int pos = comp.getCurrentSpace().positions[dimension][alignment];
        LayoutInterval neighbor = LayoutInterval.getNeighbor(comp, alignment, false, true, false);
        if (neighbor != null && neighbor.isEmptySpace() && interval.isParentOf(neighbor)) {
            int diff = neighbor.getPreferredSize();
            if (diff == -1) {
                diff = LayoutUtils.getSizeOfDefaultGap(neighbor, this.operations.getMapper());
            }
            if (alignment == 0) {
                diff *= -1;
            }
            pos += diff;
        }
        return pos;
    }

    private int determinePadding(LayoutInterval interval, int dimension, int alignment) {
        LayoutInterval neighbor = LayoutInterval.getNeighbor(interval, alignment, true, true, false);
        return this.dragger.findPadding(neighbor, interval, dimension, alignment);
    }

    private int determineExpectingPadding(LayoutInterval addingInt, LayoutInterval baseInt, LayoutInterval baseParent, int alignment) {
        if (baseInt == null) {
            baseInt = LayoutInterval.getNeighbor(baseParent, 102, alignment);
        }
        return this.dragger.findPadding(baseInt, addingInt, this.dimension, alignment);
    }

    private void analyzeParallel(LayoutInterval group, List inclusions) {
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            IncludeDesc iDesc;
            LayoutInterval neighbor;
            IncludeDesc origPos;
            boolean dimOverlap;
            LayoutInterval sub = (LayoutInterval)it.next();
            if (sub.isEmptySpace()) continue;
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isParallel() && LayoutFeeder.pointInside(this.addingSpace, this.aEdge, sub, this.dimension) && this.shouldEnterGroup(sub)) {
                this.analyzeParallel(sub, inclusions);
                continue;
            }
            if (sub.isSequential()) {
                this.analyzeSequential(sub, inclusions);
                continue;
            }
            if (!this.orthogonalOverlap(sub) || (dimOverlap = LayoutRegion.overlap(this.addingSpace, subSpace, this.dimension, 0)) && !this.solveOverlap && ((origPos = this.originalPositions1[this.dimension]) == null || (this.aEdge ^ 1) != origPos.alignment || origPos.parent != sub && !sub.isParentOf(origPos.parent))) continue;
            if (dimOverlap) {
                this.imposeSize = true;
            }
            int distance = Integer.MIN_VALUE;
            if (this.aSnappedNextTo != null && (sub == this.aSnappedNextTo || sub.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null || (neighbor = LayoutInterval.getNeighbor(sub, this.aEdge, true, true, false)) == this.aSnappedNextTo || neighbor != null && neighbor.isParentOf(this.aSnappedNextTo))) {
                distance = -1;
            }
            if (distance != -1) {
                if (!dimOverlap) {
                    int dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension, 1, 0);
                    int dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension, 1, 0);
                    distance = dstL >= 0 ? dstL : dstT;
                } else {
                    distance = 0;
                }
            }
            if ((iDesc = this.addInclusion(group, false, distance, 0, inclusions)) == null) continue;
            iDesc.neighbor = sub;
            int point = this.aEdge < 0 ? 2 : this.aEdge;
            iDesc.index = LayoutFeeder.getAddDirection(this.addingSpace, subSpace, this.dimension, point) == 0 ? 0 : 1;
        }
        if (inclusions.isEmpty() && group.getParent() == null && (this.aSnappedParallel == null || this.canAlignWith(this.aSnappedParallel, group, this.aEdge))) {
            int distance = this.aSnappedNextTo == group ? -1 : Integer.MAX_VALUE;
            this.addInclusion(group, false, distance, Integer.MAX_VALUE, inclusions);
        }
    }

    private void analyzeSequential(LayoutInterval group, List inclusions) {
        boolean inSequence = false;
        boolean parallelWithSequence = false;
        int index = -1;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;
        int n = group.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (sub.isEmptySpace()) {
                if (index != i) continue;
                ++index;
                continue;
            }
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isParallel() && LayoutFeeder.pointInside(this.addingSpace, this.aEdge, sub, this.dimension) && this.shouldEnterGroup(sub)) {
                int count = inclusions.size();
                this.analyzeParallel(sub, inclusions);
                if (inclusions.size() > count) {
                    return;
                }
            }
            boolean ortOverlap = this.orthogonalOverlap(sub);
            int margin = this.dimension == 1 && !ortOverlap ? 4 : 0;
            boolean dimOverlap = LayoutRegion.overlap(this.addingSpace, subSpace, this.dimension, margin);
            if (ortOverlap || this.dimension == 1 && !dimOverlap && !parallelWithSequence) {
                int point;
                if (dimOverlap) {
                    IncludeDesc origPos;
                    if (!this.solveOverlap && ((origPos = this.originalPositions1[this.dimension]) == null || (this.aEdge ^ 1) != origPos.alignment || origPos.parent != sub && !sub.isParentOf(origPos.parent))) {
                        return;
                    }
                    if (ortOverlap) {
                        this.imposeSize = true;
                    }
                    inSequence = true;
                    ortDistance = 0;
                    distance = 0;
                } else {
                    int dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension, 1, 0);
                    int dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension, 1, 0);
                    if (dstL >= 0 && dstL < distance) {
                        distance = dstL;
                    }
                    if (dstT >= 0 && dstT < distance) {
                        distance = dstT;
                    }
                    if (ortOverlap) {
                        ortDistance = 0;
                        inSequence = true;
                    } else {
                        dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension ^ 1, 1, 0);
                        dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension ^ 1, 1, 0);
                        if (dstL > 0 && dstL < ortDistance) {
                            ortDistance = dstL;
                        }
                        if (dstT > 0 && dstT < ortDistance) {
                            ortDistance = dstT;
                        }
                    }
                }
                int n2 = point = this.aEdge < 0 ? 2 : this.aEdge;
                if (LayoutFeeder.getAddDirection(this.addingSpace, subSpace, this.dimension, point) == 0) {
                    if (this.aEdge == 0) break;
                    index = i;
                    break;
                }
                parallelWithSequence = false;
                if (this.aEdge != 0) continue;
                index = i + 1;
                continue;
            }
            parallelWithSequence = true;
        }
        if (inSequence || this.dimension == 1 && !parallelWithSequence) {
            IncludeDesc iDesc;
            if (this.aSnappedNextTo != null && (group.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null)) {
                distance = -1;
            }
            if ((iDesc = this.addInclusion(group, parallelWithSequence, distance, ortDistance, inclusions)) != null) {
                if (index == -1) {
                    index = this.aEdge == 0 ? 0 : group.getSubIntervalCount();
                }
                iDesc.index = index;
            }
        }
    }

    private static boolean pointInside(LayoutRegion space, int alignment, LayoutInterval group, int dimension) {
        LayoutRegion groupSpace = group.getCurrentSpace();
        if (alignment != -1) {
            return LayoutRegion.pointInside(space, alignment, groupSpace, dimension);
        }
        boolean leadingInside = LayoutRegion.pointInside(space, 0, groupSpace, dimension);
        boolean trailingInside = LayoutRegion.pointInside(space, 1, groupSpace, dimension);
        return leadingInside && trailingInside || leadingInside && !LayoutInterval.isClosedGroup(group, 1) || trailingInside && !LayoutInterval.isClosedGroup(group, 0);
    }

    private boolean orthogonalOverlap(LayoutInterval interval) {
        boolean ortOverlap;
        if (this.solveOverlap || !LayoutUtils.isOverlapPreventedInOtherDimension(this.addingInterval, interval, this.dimension)) {
            ortOverlap = LayoutUtils.contentOverlap(this.addingSpace, interval, this.dimension ^ 1);
            if (ortOverlap && this.dragger.isResizing(this.dimension) && !this.dragger.isResizing(this.dimension ^ 1) && this.originalPositions1[this.dimension] != null) {
                IncludeDesc original = this.originalPositions1[this.dimension];
                LayoutInterval parent = original.parent;
                if (parent.isParentOf(interval)) {
                    if (parent.isParallel() && (original.neighbor == null || original.neighbor != interval && !original.neighbor.isParentOf(interval))) {
                        ortOverlap = false;
                    }
                } else if (parent == interval) {
                    if (parent.isParallel() && original.neighbor == null) {
                        ortOverlap = false;
                    }
                } else if (!interval.isParentOf(parent) && (parent = LayoutInterval.getCommonParent(parent, interval)) != null && parent.isParallel()) {
                    ortOverlap = false;
                }
            }
        } else {
            ortOverlap = false;
        }
        return ortOverlap;
    }

    private IncludeDesc addInclusion(LayoutInterval parent, boolean subgroup, int distance, int ortDistance, List inclusions) {
        if (!inclusions.isEmpty()) {
            boolean ortOverlap2;
            int index = inclusions.size() - 1;
            IncludeDesc last = (IncludeDesc)inclusions.get(index);
            boolean useLast = false;
            boolean useNew = false;
            boolean ortOverlap1 = last.ortDistance == 0;
            boolean bl = ortOverlap2 = ortDistance == 0;
            if (ortOverlap1 != ortOverlap2) {
                useLast = ortOverlap1;
                useNew = ortOverlap2;
            } else if (ortOverlap1) {
                useNew = true;
                useLast = true;
            } else if (last.ortDistance != ortDistance) {
                useLast = last.ortDistance < ortDistance;
                useNew = ortDistance < last.ortDistance;
            } else if (last.distance != distance) {
                useLast = last.distance < distance;
                boolean bl2 = useNew = distance < last.distance;
            }
            if (!useLast && !useNew) {
                LayoutInterval parParent = last.parent.isParallel() ? last.parent : last.parent.getParent();
                useNew = parParent.isParentOf(parent);
                boolean bl3 = useLast = !useNew;
            }
            if (!useLast) {
                inclusions.remove(index);
            }
            if (!useNew) {
                return null;
            }
        }
        IncludeDesc iDesc = new IncludeDesc();
        iDesc.parent = parent;
        iDesc.newSubGroup = subgroup;
        iDesc.alignment = this.aEdge;
        iDesc.snappedParallel = this.aSnappedParallel;
        if (distance == -1) {
            iDesc.snappedNextTo = this.aSnappedNextTo;
            iDesc.fixedPosition = true;
        }
        iDesc.distance = distance;
        iDesc.ortDistance = ortDistance;
        inclusions.add(iDesc);
        return iDesc;
    }

    private static boolean sameSubGroupAlignment(LayoutInterval group, LayoutInterval subgroup) {
        assert (group.isParallel() && subgroup.isParallel());
        int align = subgroup.getAlignment();
        boolean sameAlign = true;
        Iterator it = subgroup.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = (LayoutInterval)it.next();
            if (LayoutInterval.wantResize(li)) {
                sameAlign = true;
                break;
            }
            if (li.getAlignment() == align) continue;
            sameAlign = false;
        }
        return sameAlign && LayoutInterval.canResize(subgroup) == LayoutInterval.canResize(group);
    }

    private IncludeDesc addAligningInclusion(List inclusions) {
        if (this.aSnappedParallel == null) {
            return null;
        }
        boolean compatibleFound = false;
        for (IncludeDesc iDesc : inclusions) {
            if (!this.canAlignWith(this.aSnappedParallel, iDesc.parent, this.aEdge)) continue;
            compatibleFound = true;
            break;
        }
        if (!compatibleFound) {
            IncludeDesc iDesc = new IncludeDesc();
            iDesc.parent = this.aSnappedParallel.getParent() != null ? LayoutInterval.getFirstParent(this.aSnappedParallel, 103) : this.aSnappedParallel;
            iDesc.snappedParallel = this.aSnappedParallel;
            iDesc.alignment = this.aEdge;
            inclusions.add(0, iDesc);
            return iDesc;
        }
        return null;
    }

    private void mergeParallelInclusions(List inclusions, IncludeDesc original, boolean preserveOriginal) {
        LayoutInterval separatingGap;
        int checkCount;
        LayoutInterval commonSeq;
        int index;
        IncludeDesc best = null;
        boolean bestOriginal = false;
        for (IncludeDesc iDesc : inclusions) {
            if (original != null && preserveOriginal && !this.canCombine(iDesc, original)) continue;
            if (best != null) {
                LayoutInterval group2;
                boolean originalCompatible;
                boolean bl = originalCompatible = original != null && !preserveOriginal && iDesc.parent == original.parent;
                if (!bestOriginal && originalCompatible) {
                    best = iDesc;
                    bestOriginal = true;
                    continue;
                }
                if (bestOriginal != originalCompatible) continue;
                LayoutInterval group1 = best.parent.isSequential() ? best.parent.getParent() : best.parent;
                LayoutInterval layoutInterval = group2 = iDesc.parent.isSequential() ? iDesc.parent.getParent() : iDesc.parent;
                if (group1.isParentOf(group2)) {
                    best = iDesc;
                    continue;
                }
                if (group2.isParentOf(group1) || iDesc.distance >= best.distance) continue;
                best = iDesc;
                continue;
            }
            best = iDesc;
            bestOriginal = original != null && !preserveOriginal && iDesc.parent == original.parent;
        }
        if (best == null) {
            assert (preserveOriginal);
            inclusions.clear();
            inclusions.add(original);
            return;
        }
        LayoutInterval commonGroup = best.parent.isSequential() ? best.parent.getParent() : best.parent;
        Iterator it = inclusions.iterator();
        while (it.hasNext()) {
            IncludeDesc iDesc = (IncludeDesc)it.next();
            if (iDesc == best) continue;
            if (!LayoutFeeder.compatibleInclusions(iDesc, best, this.dimension)) {
                it.remove();
                continue;
            }
            LayoutInterval group = iDesc.parent.isSequential() ? iDesc.parent.getParent() : iDesc.parent;
            if (!group.isParentOf(commonGroup)) continue;
            LayoutInterval neighbor = iDesc.parent.isSequential() ? iDesc.parent : iDesc.neighbor;
            this.layoutModel.removeInterval(neighbor);
            this.layoutModel.addInterval(neighbor, commonGroup, -1);
            if (group.getSubIntervalCount() == 1) {
                LayoutInterval parent = group.getParent();
                LayoutInterval last = this.layoutModel.removeInterval(group, 0);
                this.operations.addContent(last, parent, this.layoutModel.removeInterval(group));
                if (commonGroup == last && commonGroup.getParent() == null) {
                    commonGroup = parent;
                }
                this.updateReplacedOriginalGroup(commonGroup, null);
            }
            if (iDesc.parent != group) continue;
            iDesc.parent = commonGroup;
        }
        if (best.parent.isParallel() && best.snappedParallel != null && best.ortDistance != 0 && inclusions.size() > 1) {
            inclusions.remove(best);
        }
        if (inclusions.size() == 1) {
            return;
        }
        LayoutInterval subGroup = null;
        LayoutInterval nextTo = null;
        LinkedList separatedLeading = new LinkedList();
        LinkedList separatedTrailing = new LinkedList();
        for (IncludeDesc iDesc : inclusions) {
            if (!iDesc.parent.isSequential() || !iDesc.newSubGroup) continue;
            LayoutInterval parSeq = this.extractParallelSequence(iDesc.parent, this.addingSpace, false, iDesc.alignment);
            assert (parSeq.isParallel());
            if (subGroup == null) {
                subGroup = parSeq;
            } else {
                LayoutInterval sub = this.layoutModel.removeInterval(parSeq, 0);
                this.layoutModel.addInterval(sub, subGroup, -1);
            }
            this.operations.extract(parSeq, -1, true, separatedLeading, separatedTrailing);
            this.layoutModel.removeInterval(parSeq);
            this.layoutModel.removeInterval(iDesc.parent);
        }
        int extractAlign = -1;
        if (subGroup != null) {
            if (separatedLeading.isEmpty()) {
                extractAlign = 1;
            }
            if (separatedTrailing.isEmpty()) {
                extractAlign = 0;
            }
        }
        LayoutInterval subsubGroup = null;
        Iterator it2 = inclusions.iterator();
        while (it2.hasNext()) {
            IncludeDesc iDesc = (IncludeDesc)it2.next();
            if (iDesc.parent.isParallel() || !iDesc.newSubGroup) {
                this.addToGroup(iDesc, null, false);
                this.operations.extract(this.addingInterval, extractAlign, extractAlign == -1, separatedLeading, separatedTrailing);
                LayoutInterval parent = this.addingInterval.getParent();
                this.layoutModel.removeInterval(this.addingInterval);
                this.layoutModel.removeInterval(parent);
                if (extractAlign != -1 && LayoutInterval.getCount(parent, -1, true) >= 1) {
                    if (subsubGroup == null) {
                        subsubGroup = new LayoutInterval(103);
                        subsubGroup.setGroupAlignment(extractAlign);
                    }
                    this.operations.addContent(parent, subsubGroup, -1);
                }
            }
            if (iDesc.snappedNextTo != null) {
                nextTo = iDesc.snappedNextTo;
            }
            if (iDesc == best) continue;
            it2.remove();
        }
        int[] borderPos = commonGroup.getCurrentSpace().positions[this.dimension];
        int[] neighborPos = (subGroup != null ? subGroup : this.addingInterval).getCurrentSpace().positions[this.dimension];
        if (commonGroup.getSubIntervalCount() == 0 && commonGroup.getParent() != null) {
            LayoutInterval parent = commonGroup.getParent();
            index = this.layoutModel.removeInterval(commonGroup);
            if (parent.isSequential()) {
                commonSeq = parent;
                commonGroup = parent.getParent();
            } else {
                commonSeq = new LayoutInterval(102);
                commonSeq.setAlignment(commonGroup.getAlignment());
                this.layoutModel.addInterval(commonSeq, parent, index);
                commonGroup = parent;
                index = 0;
            }
        } else {
            commonSeq = new LayoutInterval(102);
            this.layoutModel.addInterval(commonSeq, commonGroup, -1);
            index = 0;
        }
        if (commonSeq.getSubIntervalCount() == 0) {
            commonSeq.getCurrentSpace().set(this.dimension, commonGroup.getCurrentSpace());
        }
        this.updateReplacedOriginalGroup(commonGroup, commonSeq);
        LayoutInterval sideGroupLeading = null;
        LayoutInterval sideGroupTrailing = null;
        if (!separatedLeading.isEmpty()) {
            checkCount = commonSeq.getSubIntervalCount();
            sideGroupLeading = this.operations.addGroupContent(separatedLeading, commonSeq, index, this.dimension, 0);
            index += commonSeq.getSubIntervalCount() - checkCount;
        }
        if (!separatedTrailing.isEmpty()) {
            sideGroupTrailing = this.operations.addGroupContent(separatedTrailing, commonSeq, index, this.dimension, 1);
        }
        if (sideGroupLeading != null) {
            checkCount = commonSeq.getSubIntervalCount();
            sideGroupLeading.getCurrentSpace().set(this.dimension, borderPos[0], neighborPos[0]);
            this.operations.optimizeGaps(sideGroupLeading, this.dimension);
            index += commonSeq.getSubIntervalCount() - checkCount;
        }
        if (sideGroupTrailing != null) {
            sideGroupTrailing.getCurrentSpace().set(this.dimension, neighborPos[1], borderPos[1]);
            this.operations.optimizeGaps(sideGroupTrailing, this.dimension);
        }
        best.parent = commonSeq;
        best.newSubGroup = false;
        best.neighbor = null;
        int gapIdx = index;
        if (gapIdx == commonSeq.getSubIntervalCount()) {
            separatingGap = commonSeq.getSubInterval(--gapIdx);
        } else {
            separatingGap = commonSeq.getSubInterval(gapIdx);
            if (!separatingGap.isEmptySpace() && --gapIdx > 0) {
                separatingGap = commonSeq.getSubInterval(gapIdx);
            }
        }
        if (!separatingGap.isEmptySpace()) {
            separatingGap = null;
        } else if (subGroup == null) {
            index = gapIdx;
            if (index == 0 && !LayoutInterval.isAlignedAtBorder(commonSeq, 0)) {
                this.layoutModel.removeInterval(separatingGap);
                separatingGap = null;
            } else if (index == commonSeq.getSubIntervalCount() - 1 && !LayoutInterval.isAlignedAtBorder(commonSeq, 1)) {
                this.layoutModel.removeInterval(separatingGap);
                separatingGap = null;
            }
        }
        best.snappedNextTo = nextTo;
        if (nextTo != null) {
            best.fixedPosition = true;
        }
        if (subGroup != null) {
            if (separatingGap != null && (extractAlign == -1 || extractAlign == 0 && index > gapIdx || extractAlign == 1 && index <= gapIdx)) {
                this.layoutModel.removeInterval(separatingGap);
                if (index >= gapIdx && index > 0) {
                    --index;
                }
            }
            int subIdx = index;
            if (subsubGroup != null && subsubGroup.getSubIntervalCount() > 0) {
                LayoutInterval seq = new LayoutInterval(102);
                seq.setAlignment(best.alignment);
                this.operations.addContent(subsubGroup, seq, 0);
                this.layoutModel.addInterval(seq, subGroup, -1);
                best.parent = seq;
                index = extractAlign == 0 ? 0 : seq.getSubIntervalCount();
            } else {
                best.newSubGroup = true;
            }
            this.operations.addContent(subGroup, commonSeq, subIdx);
            this.updateMovedOriginalNeighbor();
        }
        best.index = index;
    }

    private static boolean compatibleInclusions(IncludeDesc iDesc1, IncludeDesc iDesc2, int dimension) {
        LayoutRegion spaceAvailable;
        LayoutInterval neighbor;
        LayoutInterval group2;
        LayoutInterval group1 = iDesc1.parent.isSequential() ? iDesc1.parent.getParent() : iDesc1.parent;
        LayoutInterval layoutInterval = group2 = iDesc2.parent.isSequential() ? iDesc2.parent.getParent() : iDesc2.parent;
        if (group1 == group2) {
            return true;
        }
        if (group1.isParentOf(group2)) {
            LayoutInterval temp = group1;
            group1 = group2;
            group2 = temp;
            IncludeDesc itemp = iDesc1;
            iDesc1 = iDesc2;
            iDesc2 = itemp;
        } else if (!group2.isParentOf(group1)) {
            return false;
        }
        LayoutInterval layoutInterval2 = neighbor = iDesc2.parent.isSequential() ? iDesc2.parent : iDesc2.neighbor;
        if (neighbor == null) {
            return false;
        }
        LayoutRegion spaceToHold = neighbor.getCurrentSpace();
        return LayoutRegion.pointInside(spaceToHold, 0, spaceAvailable = group1.getCurrentSpace(), dimension) && LayoutRegion.pointInside(spaceToHold, 1, spaceAvailable, dimension);
    }

    private void updateReplacedOriginalGroup(LayoutInterval newGroup, LayoutInterval newSeq) {
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPositions1[this.dimension], newGroup, newSeq);
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPositions2[this.dimension], newGroup, newSeq);
    }

    private static void updateReplacedOriginalGroup(IncludeDesc iDesc, LayoutInterval newGroup, LayoutInterval newSeq) {
        if (iDesc != null && LayoutInterval.getRoot(newGroup) != LayoutInterval.getRoot(iDesc.parent)) {
            if (iDesc.parent.isParallel()) {
                iDesc.parent = newGroup;
            } else if (newSeq != null) {
                iDesc.parent = newSeq;
            }
        }
    }

    private void updateMovedOriginalNeighbor() {
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPositions1[this.dimension]);
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPositions2[this.dimension]);
    }

    private static void updateMovedOriginalNeighbor(IncludeDesc iDesc) {
        if (iDesc != null && iDesc.neighbor != null) {
            iDesc.parent = LayoutInterval.getFirstParent(iDesc.neighbor, 103);
            LayoutFeeder.correctNeighborInSequence(iDesc);
        }
    }

    private boolean mergeSequentialInclusions(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        boolean nextTo;
        LayoutInterval commonGroup;
        if (iDesc2 == null || !this.canCombine(iDesc1, iDesc2)) {
            return false;
        }
        assert (!(iDesc1.alignment != 0 && iDesc1.alignment != 1 || iDesc2.alignment != 0 && iDesc2.alignment != 1 || iDesc1.alignment != (iDesc2.alignment ^ 1)));
        if (iDesc1.parent == iDesc2.parent) {
            return true;
        }
        if (iDesc1.parent.isParentOf(iDesc2.parent)) {
            commonGroup = iDesc1.parent;
            nextTo = iDesc1.neighbor != null || iDesc2.snappedNextTo != null;
        } else if (iDesc2.parent.isParentOf(iDesc1.parent)) {
            commonGroup = iDesc2.parent;
            nextTo = iDesc2.neighbor != null || iDesc1.snappedNextTo != null;
        } else {
            commonGroup = LayoutInterval.getFirstParent(iDesc1.parent, 102);
            nextTo = false;
        }
        if (commonGroup.isSequential() || nextTo) {
            if (iDesc1.alignment == 1) {
                IncludeDesc temp = iDesc1;
                iDesc1 = iDesc2;
                iDesc2 = temp;
            }
            int startIndex = 0;
            LayoutInterval ext1 = null;
            boolean startGap = false;
            int endIndex = 0;
            LayoutInterval ext2 = null;
            boolean endGap = false;
            if (commonGroup.isSequential()) {
                LayoutInterval inCommon;
                if (commonGroup.isParentOf(iDesc1.parent)) {
                    LayoutInterval layoutInterval = ext1 = iDesc1.parent.isSequential() ? iDesc1.parent : iDesc1.neighbor;
                    if (ext1 != null) {
                        while (ext1.getParent().getParent() != commonGroup) {
                            ext1 = ext1.getParent();
                        }
                        startIndex = commonGroup.indexOf(ext1.getParent());
                    } else {
                        inCommon = iDesc1.parent;
                        while (inCommon.getParent() != commonGroup) {
                            inCommon = inCommon.getParent();
                        }
                        startIndex = commonGroup.indexOf(inCommon);
                    }
                } else {
                    startIndex = iDesc1.index;
                    if (startIndex == commonGroup.getSubIntervalCount()) {
                        --startIndex;
                    }
                    startGap = commonGroup.getSubInterval(startIndex).isEmptySpace();
                }
                if (commonGroup.isParentOf(iDesc2.parent)) {
                    LayoutInterval layoutInterval = ext2 = iDesc2.parent.isSequential() ? iDesc2.parent : iDesc2.neighbor;
                    if (ext2 != null) {
                        while (ext2.getParent().getParent() != commonGroup) {
                            ext2 = ext2.getParent();
                        }
                        endIndex = commonGroup.indexOf(ext2.getParent());
                    } else {
                        inCommon = iDesc2.parent;
                        while (inCommon.getParent() != commonGroup) {
                            inCommon = inCommon.getParent();
                        }
                        endIndex = commonGroup.indexOf(inCommon);
                    }
                } else {
                    endIndex = iDesc2.index;
                    if (iDesc2.snappedParallel == null || !commonGroup.isParentOf(iDesc2.snappedParallel)) {
                        endGap = commonGroup.getSubInterval(--endIndex).isEmptySpace();
                    }
                }
            }
            if ((endIndex > startIndex + 1 || endIndex == startIndex + 1 && !startGap && !endGap) && (ext1 != null && !iDesc1.newSubGroup || ext2 != null && !iDesc2.newSubGroup)) {
                LayoutInterval last;
                LayoutInterval parGroup;
                if (startIndex == 0 && endIndex == commonGroup.getSubIntervalCount() - 1) {
                    parGroup = commonGroup.getParent();
                } else {
                    parGroup = new LayoutInterval(103);
                    LayoutInterval parSeq = new LayoutInterval(102);
                    this.layoutModel.addInterval(parSeq, parGroup, 0);
                    parGroup.getCurrentSpace().set(this.dimension, LayoutUtils.getVisualPosition(commonGroup.getSubInterval(startIndex), this.dimension, 0), LayoutUtils.getVisualPosition(commonGroup.getSubInterval(endIndex), this.dimension, 1));
                    int i = startIndex;
                    while (i <= endIndex) {
                        LayoutInterval li = this.layoutModel.removeInterval(commonGroup, i);
                        --endIndex;
                        this.layoutModel.addInterval(li, parSeq, -1);
                    }
                    this.layoutModel.addInterval(parGroup, commonGroup, startIndex);
                }
                LayoutInterval extSeq = new LayoutInterval(102);
                this.layoutModel.addInterval(extSeq, parGroup, -1);
                if (ext1 != null) {
                    LayoutInterval parent = ext1.getParent();
                    this.layoutModel.removeInterval(ext1);
                    if (parent.getSubIntervalCount() == 1) {
                        last = this.layoutModel.removeInterval(parent, 0);
                        this.operations.addContent(last, parent.getParent(), this.layoutModel.removeInterval(parent));
                    }
                    this.operations.addContent(ext1, extSeq, 0);
                    if (ext2 != null) {
                        LayoutInterval gap = new LayoutInterval(101);
                        int size = LayoutRegion.distance(ext1.getCurrentSpace(), ext2.getCurrentSpace(), this.dimension, 0, 1);
                        gap.setSize(size);
                        this.layoutModel.addInterval(gap, extSeq, -1);
                        iDesc1.index = iDesc2.index = extSeq.indexOf(gap);
                    } else {
                        iDesc2.index = iDesc1.index;
                    }
                } else {
                    iDesc1.index = iDesc2.index;
                }
                if (ext2 != null) {
                    LayoutInterval parent = ext2.getParent();
                    this.layoutModel.removeInterval(ext2);
                    if (parent.getSubIntervalCount() == 1) {
                        last = this.layoutModel.removeInterval(parent, 0);
                        this.operations.addContent(last, parent.getParent(), this.layoutModel.removeInterval(parent));
                    }
                    this.operations.addContent(ext2, extSeq, -1);
                }
                iDesc1.parent = iDesc2.parent = extSeq;
                iDesc2.newSubGroup = false;
                iDesc1.newSubGroup = false;
                iDesc2.neighbor = null;
                iDesc1.neighbor = null;
            } else if (iDesc2.parent.isParentOf(iDesc1.parent)) {
                iDesc2.parent = iDesc1.parent;
                iDesc2.index = iDesc1.index;
                iDesc2.newSubGroup = iDesc1.newSubGroup;
                iDesc2.neighbor = iDesc1.neighbor;
                if (endGap) {
                    iDesc2.fixedPosition = false;
                }
            } else if (iDesc1.parent.isParentOf(iDesc2.parent)) {
                iDesc1.parent = iDesc2.parent;
                iDesc1.index = iDesc2.index;
                iDesc1.newSubGroup = iDesc2.newSubGroup;
                iDesc1.neighbor = iDesc2.neighbor;
                if (startGap) {
                    iDesc1.fixedPosition = false;
                }
            }
        } else {
            assert (iDesc1.parent.isParallel() && iDesc2.parent.isParallel() && (commonGroup == iDesc1.parent || commonGroup == iDesc2.parent) && iDesc1.neighbor == null && iDesc2.neighbor == null);
            if (iDesc2.snappedNextTo == null && iDesc2.snappedParallel == null || iDesc2.snappedParallel != null && this.canAlignWith(iDesc2.snappedParallel, iDesc1.parent, iDesc2.alignment)) {
                iDesc2.parent = iDesc1.parent;
                return true;
            }
            if (iDesc2.parent == commonGroup) {
                IncludeDesc temp = iDesc1;
                iDesc1 = iDesc2;
                iDesc2 = temp;
            }
            assert (iDesc2.snappedNextTo == null);
            if (iDesc2.snappedParallel == iDesc2.parent) {
                iDesc2.parent = LayoutInterval.getFirstParent(iDesc2.parent, 103);
                if (iDesc2.parent == iDesc1.parent) {
                    return true;
                }
            }
            if (iDesc2.snappedParallel == null || this.canAlignWith(iDesc2.snappedParallel, iDesc1.parent, iDesc2.alignment)) {
                iDesc2.parent = iDesc1.parent;
                return true;
            }
            if (LayoutInterval.isAlignedAtBorder(iDesc2.parent, iDesc1.parent, iDesc1.alignment)) {
                iDesc1.parent = iDesc2.parent;
                return true;
            }
            LayoutInterval seq = iDesc2.parent.getParent();
            if (seq.isSequential() && seq.getParent() == iDesc1.parent) {
                LayoutInterval gap;
                int index = seq.indexOf(iDesc2.parent) + (iDesc1.alignment == 0 ? -1 : 1);
                LayoutInterval layoutInterval = gap = index == 0 || index == seq.getSubIntervalCount() - 1 ? seq.getSubInterval(index) : null;
                if (gap != null && LayoutInterval.isFixedDefaultPadding(gap) && iDesc1.snappedNextTo == iDesc1.parent && LayoutInterval.wantResize(seq)) {
                    iDesc1.parent = iDesc2.parent;
                    iDesc1.snappedNextTo = null;
                    iDesc1.snappedParallel = iDesc2.parent;
                    return true;
                }
                if (gap != null && gap.isEmptySpace() && iDesc1.snappedParallel == iDesc1.parent) {
                    int gapSize = LayoutInterval.getIntervalCurrentSize(gap, this.dimension);
                    this.copyGapInsideGroup(gap, gapSize, iDesc2.parent, iDesc1.alignment);
                    this.layoutModel.removeInterval(gap);
                    iDesc1.parent = iDesc2.parent;
                    return true;
                }
            }
            iDesc2.parent = iDesc1.parent;
        }
        return true;
    }

    private void copyGapInsideGroup(LayoutInterval gap, int gapSize, LayoutInterval group, int alignment) {
        assert (gap.isEmptySpace() && (alignment == 0 || alignment == 1));
        if (alignment == 0) {
            gapSize = -gapSize;
        }
        int[] nArray = group.getCurrentSpace().positions[this.dimension];
        int n = alignment;
        nArray[n] = nArray[n] + gapSize;
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sub = (LayoutInterval)it.next();
            LayoutInterval gapClone = LayoutInterval.cloneInterval(gap, null);
            if (sub.isSequential()) {
                int[] nArray2 = sub.getCurrentSpace().positions[this.dimension];
                int n2 = alignment;
                nArray2[n2] = nArray2[n2] + gapSize;
                int index = alignment == 0 ? 0 : sub.getSubIntervalCount();
                this.operations.insertGapIntoSequence(gapClone, sub, index, this.dimension);
                continue;
            }
            LayoutInterval seq = new LayoutInterval(102);
            seq.getCurrentSpace().set(this.dimension, sub.getCurrentSpace());
            int[] nArray3 = seq.getCurrentSpace().positions[this.dimension];
            int n3 = alignment;
            nArray3[n3] = nArray3[n3] + gapSize;
            seq.setAlignment(sub.getRawAlignment());
            this.layoutModel.addInterval(seq, group, this.layoutModel.removeInterval(sub));
            this.layoutModel.setIntervalAlignment(sub, -1);
            this.layoutModel.addInterval(sub, seq, 0);
            this.layoutModel.addInterval(gapClone, seq, alignment == 0 ? 0 : 1);
        }
    }

    private boolean shouldEnterGroup(LayoutInterval group) {
        assert (group.isParallel());
        int alignment = this.aEdge;
        int groupAlign = group.getGroupAlignment();
        if (groupAlign != alignment && (groupAlign != 0 && groupAlign != 1 || alignment != 0 && alignment != 1 && alignment != -1)) {
            return false;
        }
        return this.aSnappedParallel == null || this.allowsSubAlignWith(this.aSnappedParallel, group, alignment);
    }

    private boolean allowsSubAlignWith(LayoutInterval interval, LayoutInterval group, int alignment) {
        if (group == interval || group.isParentOf(interval)) {
            return true;
        }
        LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
        while (parent != null) {
            if (LayoutInterval.isAlignedAtBorder(interval, parent, alignment)) {
                if (parent.isParentOf(group) && LayoutInterval.isAlignedAtBorder(group, parent, alignment)) {
                    return true;
                }
                interval = parent;
                parent = LayoutInterval.getFirstParent(interval, 103);
                continue;
            }
            parent = null;
        }
        return false;
    }

    private boolean canAlignWith(LayoutInterval interval, LayoutInterval group, int alignment) {
        if (group.isSequential()) {
            group = group.getParent();
        }
        if (interval == group) {
            return true;
        }
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            parent = interval;
        } else if (parent.isSequential()) {
            parent = parent.getParent();
        }
        while (parent != null && parent != group && !parent.isParentOf(group)) {
            if (LayoutFeeder.canSubstAlignWithParent(interval, this.dimension, alignment, this.dragger.isResizing(this.dimension))) {
                interval = parent;
                parent = LayoutInterval.getFirstParent(interval, 103);
                continue;
            }
            parent = null;
        }
        if (parent == null) {
            return false;
        }
        if (parent == group) {
            return true;
        }
        return LayoutInterval.isAlignedAtBorder(group, parent, alignment);
    }

    private static boolean canSubstAlignWithParent(LayoutInterval interval, int dimension, int alignment, boolean placedAtBorderEnough) {
        LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
        boolean aligned = LayoutInterval.isAlignedAtBorder(interval, parent, alignment);
        if (!aligned && LayoutInterval.getDirectNeighbor(interval, alignment, false) == null && LayoutInterval.isPlacedAtBorder(interval, parent, dimension, alignment)) {
            boolean bl = aligned = placedAtBorderEnough || LayoutInterval.getDirectNeighbor(parent, alignment, true) != null || LayoutInterval.isClosedGroup(parent, alignment);
            if (!aligned) {
                boolean allTouching = true;
                Iterator it = parent.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = (LayoutInterval)it.next();
                    if (li.getAlignment() == alignment || LayoutInterval.wantResize(li)) {
                        aligned = true;
                        break;
                    }
                    if (!allTouching || LayoutInterval.isPlacedAtBorder(li, dimension, alignment)) continue;
                    allTouching = false;
                }
                if (allTouching) {
                    aligned = true;
                }
            }
        }
        return aligned;
    }

    private boolean canCombine(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        if (iDesc1.parent == iDesc2.parent) {
            return true;
        }
        if (iDesc1.parent.isParentOf(iDesc2.parent)) {
            return this.isBorderInclusion(iDesc2);
        }
        if (iDesc2.parent.isParentOf(iDesc1.parent)) {
            return this.isBorderInclusion(iDesc1);
        }
        LayoutInterval parParent1 = iDesc1.parent.isParallel() ? iDesc1.parent : iDesc1.parent.getParent();
        LayoutInterval parParent2 = iDesc2.parent.isParallel() ? iDesc2.parent : iDesc2.parent.getParent();
        return parParent1.getParent() == parParent2.getParent() && this.isBorderInclusion(iDesc1) && this.isBorderInclusion(iDesc2) && LayoutInterval.getDirectNeighbor(parParent1, iDesc1.alignment ^ 1, true) == parParent2;
    }

    private boolean isBorderInclusion(IncludeDesc iDesc) {
        if (iDesc.alignment != 0 && iDesc.alignment != 1) {
            return false;
        }
        if (iDesc.parent.isSequential()) {
            int startIndex = iDesc.alignment == 0 ? iDesc.index : 0;
            int endIndex = iDesc.alignment == 0 ? iDesc.parent.getSubIntervalCount() - 1 : iDesc.index - 1;
            return startIndex > endIndex || !LayoutUtils.contentOverlap(this.addingSpace, iDesc.parent, startIndex, endIndex, this.dimension ^ 1);
        }
        return iDesc.neighbor == null || iDesc.alignment == 0 && iDesc.index >= 1 || iDesc.alignment == 1 && iDesc.index == 0;
    }

    private static int getAddDirection(LayoutRegion adding, LayoutRegion existing, int dimension, int alignment) {
        return LayoutRegion.distance(adding, existing, dimension, alignment, 2) > 0 ? 0 : 1;
    }

    private static class IncludeDesc {
        LayoutInterval parent;
        int index = -1;
        boolean newSubGroup;
        LayoutInterval neighbor;
        LayoutInterval snappedParallel;
        LayoutInterval snappedNextTo;
        int alignment;
        boolean fixedPosition;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;

        private IncludeDesc() {
        }

        boolean snapped() {
            return this.snappedNextTo != null || this.snappedParallel != null;
        }
    }
}

